/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.fields.SFDouble;
import org.web3d.x3d.jsail.fields.SFVec3d;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class MFVec3d
extends X3DConcreteField
implements org.web3d.x3d.sai.MFVec3d {
    public static final String NAME = "MFVec3d";
    public static final double[] DEFAULT_VALUE = new double[0];
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 3;
    public static final String REGEX = "\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*";
    public static final Pattern PATTERN = Pattern.compile("\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*");
    private static boolean priorRegexStackOverflowFound = false;
    private double[] MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);

    public static final boolean isArray() {
        return true;
    }

    public MFVec3d() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
    }

    public boolean equals(MFVec3d comparisonMFVec3d) {
        return this.getPrimitiveValue() == comparisonMFVec3d.getPrimitiveValue();
    }

    public final String validate() {
        MFVec3d tempHold = new MFVec3d(this.getPrimitiveValue());
        if (!this.equals(tempHold)) {
            return "MFVec3d validate() error: failed get/set round-trip test";
        }
        return DEFAULT_VALUE_STRING;
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new MFVec3d PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec3d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return DEFAULT_VALUE_STRING;
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for MFVec3d array";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public MFVec3d setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.MFVec3d.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new MFVec3d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        try {
            String[] newValues = newValue.replace(",", " ").trim().split("\\s+");
            if (newValues.length % 3 != 0) {
                String errorNotice = "illegal number of values (" + newValues.length + ") in initialization string, must be multiple of 3 when declaring new MFVec3d(" + newValue + ")";
                validationResult.append(errorNotice).append("\n");
                throw new InvalidFieldValueException(errorNotice);
            }
            this.MFVec3d = new double[newValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                this.MFVec3d[i] = Double.parseDouble(newValues[i]);
            }
        }
        catch (NumberFormatException e) {
            String errorNotice = "new MFVec3d(" + newValue + ") " + e.getMessage();
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return this;
    }

    public MFVec3d(MFVec3d newValue) {
        if (newValue == null) {
            this.MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return;
        }
        this.MFVec3d = newValue.getPrimitiveValue();
    }

    public MFVec3d(double[] newValue) {
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length % 3 != 0) {
            String errorNotice = "Illegal MFVec3d newValue array length=" + newValue.length + ", must be multiple of 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec3d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.MFVec3d = newValue;
    }

    public MFVec3d normalize() {
        int index = 0;
        while (index + 3 < this.MFVec3d.length) {
            double length = Math.sqrt(this.MFVec3d[index + 0] * this.MFVec3d[index + 0] + this.MFVec3d[index + 1] * this.MFVec3d[index + 1] + this.MFVec3d[index + 2] * this.MFVec3d[index + 2]);
            if (length > 0.0) {
                this.MFVec3d[index + 0] = this.MFVec3d[index + 0] / length;
                this.MFVec3d[index + 1] = this.MFVec3d[index + 1] / length;
                this.MFVec3d[index + 2] = this.MFVec3d[index + 2] / length;
            }
            index += 3;
        }
        return this;
    }

    public MFVec3d(SFVec3d newValue) {
        this.setValue(newValue);
    }

    public MFVec3d(float[] newValue) {
        this.setValue(newValue);
    }

    public static String toString(double[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(value[i])).append(" ");
                continue;
            }
            result.append(value[i]).append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public void getValue(double[] valueDestination) {
        valueDestination = this.MFVec3d;
    }

    public double[] getPrimitiveValue() {
        return this.MFVec3d;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.MFVec3d.length; ++i) {
            if (ConfigurationProperties.isStripTrailingZeroes()) {
                result.append(SFDouble.stripTrailingZeroes(this.MFVec3d[i]));
            } else {
                result.append(this.MFVec3d[i]);
            }
            if (i >= this.MFVec3d.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void get1Value(int index, double[] destinationValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot get1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec3d.length / 3) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3d array length=" + this.MFVec3d.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        destinationValue = Arrays.copyOfRange(this.MFVec3d, index * 3, index * 3 + 3 - 1);
    }

    @Override
    public void setValue(int size, double[] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
        this.MFVec3d = Arrays.copyOf(newValue, size);
    }

    @Override
    public void getValue(double[][] valueDestination) {
    }

    @Override
    public void setValue(int size, double[][] newValue) {
        if (newValue == null) {
            throw new InvalidFieldValueException(" newValue is null and cannot be set");
        }
        if (size < 0) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is negative");
        }
        if (size > newValue.length) {
            throw new InvalidFieldValueException("requested setValue() array-copy size=" + size + " is greater than newValue.length()=" + newValue.length);
        }
    }

    public void setValue(double[] newValue) {
        if (newValue == null) {
            newValue = new double[]{};
        }
        this.MFVec3d = new double[newValue.length];
        this.MFVec3d = newValue;
    }

    public MFVec3d setValue(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        this.MFVec3d = new double[newValue.length];
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec3d[i] = newValue[i];
        }
        return this;
    }

    public MFVec3d setValue(SFVec3d newValue) {
        if (newValue == null) {
            this.MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.setValue(newValue.toDoubleArray());
        return this;
    }

    @Override
    public void set1Value(int index, double[] newValue) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot set1Value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue == null) {
            newValue = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
        } else if (newValue.length != 3) {
            String errorNotice = "Illegal MFVec3d newValue array length=" + newValue.length + ", must equal 3 or else be empty (newValue=" + org.web3d.x3d.jsail.fields.MFVec3d.toString(newValue) + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec3d.length / 3) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3d array length=" + this.MFVec3d.length / 3;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec3d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public void append(double[] newValue) {
        if (newValue.length % 3 != 0) {
            String errorNotice = "illegal number of values (" + newValue.length + ") in initialization array, must be multiple of 3 when declaring new MFVec3d(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        int originalLength = this.MFVec3d.length;
        this.MFVec3d = Arrays.copyOf(this.MFVec3d, this.MFVec3d.length + newValue.length);
        for (int i = 0; i < newValue.length; ++i) {
            this.MFVec3d[originalLength + i] = newValue[i];
        }
    }

    public MFVec3d append(SFVec3d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    public MFVec3d append(MFVec3d newValue) {
        this.append(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public void insertValue(int index, double[] newValue) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot insertValue at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (newValue.length != 3) {
            String errorNotice = "illegal number of values (" + newValue.length + ") for insertValue newValue array, must equal 3 for MFVec3dinsertValue(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (index >= this.MFVec3d.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3d array length=" + this.MFVec3d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int sliceLength = this.MFVec3d.length - index;
        this.MFVec3d = Arrays.copyOf(this.MFVec3d, this.MFVec3d.length + 3);
        System.arraycopy(this.MFVec3d, index, this.MFVec3d, index + 3, sliceLength);
        int offset = 0;
        double[] dArray = newValue;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double value;
            this.MFVec3d[index + offset] = value = dArray[i];
            ++offset;
        }
    }

    @Override
    public int size() {
        return this.MFVec3d.length;
    }

    @Override
    public void clear() {
        this.MFVec3d = new double[0];
    }

    @Override
    public void remove(int index) {
        if (index < 0) {
            String errorNotice = "Index value is negative, thus cannot remove() value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (this.MFVec3d.length == 0) {
            String errorNotice = "Value array is empty, thus cannot remove value at index=" + index + ".";
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        if (index >= this.MFVec3d.length) {
            String errorNotice = "Provided array index=" + index + " must be less than MFVec3d array length=" + this.MFVec3d.length;
            validationResult.append(errorNotice).append("\n");
            throw new ArrayIndexOutOfBoundsException(errorNotice);
        }
        int offsetLength = this.MFVec3d.length - (index + 1) * 3;
        System.arraycopy(this.MFVec3d, (index + 1) * 3, this.MFVec3d, index * 3, offsetLength);
        this.MFVec3d = Arrays.copyOfRange(this.MFVec3d, 0, this.MFVec3d.length - 3);
    }

    public double[] toDoubleArray() {
        return this.MFVec3d;
    }

    public MFVec3d setValue(MFVec3d newValue) {
        if (newValue == null) {
            this.MFVec3d = Arrays.copyOf(DEFAULT_VALUE, DEFAULT_VALUE.length);
            return this;
        }
        this.MFVec3d = newValue.getPrimitiveValue();
        return this;
    }

    public MFVec3d multiply(double scaleFactor) {
        int i = 0;
        while (i < this.MFVec3d.length) {
            int n = i++;
            this.MFVec3d[n] = this.MFVec3d[n] * scaleFactor;
        }
        return this;
    }

    public boolean isDefaultValue() {
        return Arrays.equals(this.MFVec3d, DEFAULT_VALUE);
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new MFVec3d(DEFAULT_VALUE).matches()) {
                System.out.println("MFVec3d.initialize() problem: failed to match DEFAULT_VALUE=" + Arrays.toString(DEFAULT_VALUE));
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in MFVec3d initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"\\s*((([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s+){2}([+-]?((0|[1-9][0-9]*)(\\.[0-9]*)?|\\.[0-9]+)([Ee][+-]?[0-9]+)?)\\s*,?\\s*)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

