/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.fields;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.web3d.x3d.jsail.fields.X3DConcreteField;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class SFString
extends X3DConcreteField
implements org.web3d.x3d.sai.SFString {
    public static final String NAME = "SFString";
    public static final String DEFAULT_VALUE = "";
    public static final String DEFAULT_VALUE_STRING = "";
    public static final int TUPLE_SIZE = 1;
    public static final String REGEX = "(\\s|\\S)*";
    public static final Pattern PATTERN = Pattern.compile("(\\s|\\S)*");
    private static boolean priorRegexStackOverflowFound = false;
    private String SFString = "";
    public static final String NameStartCharFilter = "A-Z_a-z";
    public static final String NameCharFilter = "A-Z_a-z-.0-9";
    public static final String NameFilter = "[A-Z_a-z][A-Z_a-z-.0-9]*";
    public static final String NmtokenFilter = "[A-Z_a-z-.0-9]+";

    public static final boolean isArray() {
        return false;
    }

    public SFString() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        this.SFString = "";
    }

    public static final boolean isNMTOKEN(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        boolean result = value.matches(NmtokenFilter);
        return result;
    }

    public static final boolean meetsX3dInteroperabilityNamingConventions(String value) {
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        boolean result = value.matches("[a-zA-Z_][a-zA-Z0-9_]*");
        return result;
    }

    public void appendValue(String newValue) {
        this.SFString = this.SFString + newValue;
    }

    public void prependValue(String newValue) {
        this.SFString = newValue + this.SFString;
    }

    public boolean equals(SFString comparisonSFString) {
        return this.getPrimitiveValue() == comparisonSFString.getPrimitiveValue();
    }

    public final String validate() {
        return this.validateRegex();
    }

    public final String validateRegex() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            if (!m.matches()) {
                String errorNotice = "*** Regular expression (regex) failure, new SFString PATTERN mismatch (\"" + this.toString() + "\")";
                return errorNotice;
            }
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFString";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return validationMessage;
        }
        return "";
    }

    public final boolean matches() {
        try {
            Matcher m = PATTERN.matcher(this.toString());
            return m.matches();
        }
        catch (StackOverflowError soe) {
            String validationMessage = "java.lang.StackOverflow warning: regular expression (regex) unable to evaluate large corresponding String value for SFString";
            validationResult.append(validationMessage).append("\n");
            System.out.println("*** " + validationMessage);
            return false;
        }
    }

    public static final boolean matches(String value) {
        Matcher m = PATTERN.matcher(value);
        return m.matches();
    }

    public SFString setValueByString(String newValue) throws InvalidFieldValueException {
        if (newValue == null) {
            newValue = new String();
        }
        if (!org.web3d.x3d.jsail.fields.SFString.matches(newValue)) {
            String errorNotice = "*** Regular expression (regex) failure, new SFString(" + newValue + ")";
            validationResult.append(errorNotice).append("\n");
        }
        if (newValue.trim().isEmpty()) {
            this.SFString = "";
            return this;
        }
        this.SFString = newValue;
        return this;
    }

    public SFString(SFString newValue) {
        if (newValue == null) {
            this.SFString = "";
            return;
        }
        this.SFString = newValue.getPrimitiveValue();
    }

    public SFString(String newValue) {
        this.SFString = newValue;
    }

    public static String toString(String value) {
        return String.valueOf(value);
    }

    public static String toStringX3D(String value) {
        return new SFString(value).toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "\\\"");
    }

    public String toStringX3D() {
        return org.web3d.x3d.jsail.fields.SFString.toStringX3D(this.SFString);
    }

    @Override
    public String getValue() {
        return this.SFString;
    }

    public String getPrimitiveValue() {
        return this.SFString;
    }

    public String toString() {
        return this.SFString;
    }

    @Override
    public void setValue(String newValue) {
        this.SFString = newValue;
    }

    public SFString setValue(SFString newValue) {
        if (newValue == null) {
            this.SFString = "";
            return this;
        }
        this.SFString = newValue.getPrimitiveValue();
        return this;
    }

    public boolean isDefaultValue() {
        return this.SFString == "";
    }

    static {
        try {
            Pattern.compile(REGEX);
            if (!new SFString("").matches()) {
                System.out.println("SFString.initialize() problem: failed to match DEFAULT_VALUE=");
            }
        }
        catch (PatternSyntaxException exception) {
            System.out.println("Exception in SFString initialization testing, regex pattern compilation failure.");
            System.out.println("REGEX=\"(\\s|\\S)*\"");
            System.out.println(exception.getDescription());
        }
    }
}

