/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;

public class SPSSStringVariable
extends SPSSVariable {
    public List<String> data;
    public String value;

    public SPSSStringVariable(SPSSFile sPSSFile) {
        super(sPSSFile);
        this.type = SPSSVariable.VariableType.STRING;
        this.data = new ArrayList<String>();
    }

    @Override
    public SPSSVariableCategory addCategory(byte[] byArray, String string) {
        String string2 = this.file.charset == null ? SPSSUtils.byte8ToString(byArray) : SPSSUtils.byte8ToString(byArray, this.file.charset);
        SPSSVariableCategory sPSSVariableCategory = (SPSSVariableCategory)this.categoryMap.get(string2);
        if (sPSSVariableCategory == null) {
            sPSSVariableCategory = new SPSSVariableCategory();
            this.categoryMap.put(string2, sPSSVariableCategory);
        }
        sPSSVariableCategory.strValue = string2;
        sPSSVariableCategory.label = string;
        return sPSSVariableCategory;
    }

    @Override
    public SPSSVariableCategory getCategory(byte[] byArray) {
        String string = this.file.charset == null ? SPSSUtils.byte8ToString(byArray) : SPSSUtils.byte8ToString(byArray, this.file.charset);
        return this.getCategory(string);
    }

    public SPSSVariableCategory getCategory(String string) {
        return (SPSSVariableCategory)this.categoryMap.get(string);
    }

    @Override
    public String getSPSSFormat() {
        return "A" + this.variableRecord.writeFormatWidth;
    }

    @Override
    public String getValueAsString(int n, FileFormatInfo fileFormatInfo) throws SPSSFileException {
        String string;
        if (n < 0 || n > this.data.size()) {
            throw new SPSSFileException("Invalid observation number [" + n + ". Range is 1 to " + this.data.size() + "] or 0.");
        }
        if (n == 0) {
            string = this.value;
        } else {
            if (n > 0 && this.data.size() == 0) {
                throw new SPSSFileException("No data availble");
            }
            string = this.data.get(n - 1);
        }
        if (fileFormatInfo.format == FileFormatInfo.Format.ASCII) {
            if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.FIXED) {
                string = string + Utils.leftPad("", this.getLength() - string.length());
            } else if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                if (string.contains("\"")) {
                    string = string.replaceAll("\"", "\"\"");
                }
                if (string.contains(",") || string.contains("\"") || string.contains("\n")) {
                    string = "\"" + string + "\"";
                }
            }
        }
        return string;
    }
}

