/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.swing.SwingCanvasHandler;
import com.macrofocus.geom.Point;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.treemap.AbstractTreeMapView;
import com.treemap.DefaultTreeMapToolTip;
import com.treemap.LabelingFactory;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.TGraphics;
import com.treemap.swing.crossplatform.SwingHeadless;
import com.treemap.swing.crossplatform.SwingTGraphics;
import com.treemap.swing.plaf.TreeMapUI;
import com.treemap.swing.plaf.basic.BasicTreeMapUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SwingTreeMapView<N, Row, Column>
extends AbstractTreeMapView<JComponent, N, Row, Column, Color, Font> {
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private NativeComponent nativeComponent = new NativeComponent();
    private final SwingCanvasHandler handler = new SwingCanvasHandler((JComponent)this.nativeComponent);
    private RenderingHints _renderingHints = new RenderingHints(new HashMap());

    public SwingTreeMapView() {
        super((Headless)new SwingHeadless());
        this._renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this._renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this._renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this._renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.probingToolTip = new DefaultTreeMapToolTip((TreeMapView)this);
        this.selectionToolTip = null;
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingTreeMapView.this.updateModelDimension();
                SwingTreeMapView.this.updateSize();
            }
        });
        this.setLicenseModel(this.licenseModel);
    }

    public RenderingHints getRenderingHints() {
        return this._renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._renderingHints = renderingHints;
        this.repaint();
    }

    public void setModel(TreeMapModel<N, Row, Column, Color, Font> model) {
        if (model != null) {
            LabelingFactory.SURROUND.setHeadless((Headless)new SwingHeadless());
            LabelingFactory.COLORED_SURROUND.setHeadless((Headless)new SwingHeadless());
        }
        super.setModel(model);
    }

    protected void updateSize() {
        int h;
        int w;
        double height;
        double width;
        com.macrofocus.common.geom.Dimension m;
        com.macrofocus.common.geom.Dimension dimension = m = this._model != null && this._model.getSettings().getDimension() != null ? this._model.getSettings().getDimension() : new com.macrofocus.common.geom.Dimension(0, 0);
        if (this.nativeComponent != null) {
            Dimension v = this.nativeComponent.getSize();
            width = Math.max(0.0, Math.max(m.getWidth(), v.getWidth()));
            height = Math.max(0.0, Math.max(m.getHeight(), v.getHeight()));
            w = Math.max(0, v.width);
            h = Math.max(0, v.height);
        } else {
            width = Math.max(0.0, m.getWidth());
            height = Math.max(0.0, m.getHeight());
            w = 0;
            h = 0;
        }
        this.xRangeModel.setMinMax(0.0, width);
        this.yRangeModel.setMinMax(0.0, height);
        this.xRangeModel.setMaximumExtent((double)w);
        this.yRangeModel.setMaximumExtent((double)h);
        this.xRangeModel.setValue(0.0, this.xRangeModel.getMaximumExtent());
        this.yRangeModel.setValue(height - this.yRangeModel.getMaximumExtent(), this.yRangeModel.getMaximumExtent());
        this.screenTransform.setScreenSize(w, h);
    }

    public void updateModelDimension() {
        if (this._model != null && this.isUpdateModelDimension() && !this._model.getSettings().getDimensionFixed().booleanValue()) {
            Dimension v = this.nativeComponent.getSize();
            this._model.getSettings().setDimension(new com.macrofocus.common.geom.Dimension(v.width, v.height));
        }
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            this.nativeComponent.add(this.unregisteredPanel, JLayeredPane.MODAL_LAYER, 0);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingTreeMapView.this.nativeComponent, (Component)SwingTreeMapView.this.unregisteredPanel);
                }
            };
            this.nativeComponent.addComponentListener(this.unregisteredPanelListener);
        } else if (this.unregisteredPanel != null) {
            this.nativeComponent.removeComponentListener(this.unregisteredPanelListener);
            this.nativeComponent.remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
    }

    public BufferedImage getImage() {
        int height;
        com.macrofocus.common.geom.Dimension dimension;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        int width = (dimension = this.getModel().getSettings().getDimension()) != null ? dimension.width : -1;
        int n = height = dimension != null ? dimension.height : -1;
        if (width > 0 && height > 0) {
            BufferedImage b = new BufferedImage(width, height, 1);
            final Graphics2D g = b.createGraphics();
            g.setBackground(Color.white);
            g.clearRect(0, 0, width, height);
            this.getModel().waitUntilReady();
            TreeMapToolTip toolTip = this.getToolTip();
            Object oldNode = toolTip != null ? toolTip.getNode() : null;
            try {
                Runnable paint = new Runnable(){

                    @Override
                    public void run() {
                        SwingTreeMapView.this.nativeComponent.paint(g);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(paint);
                } else {
                    paint.run();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (toolTip != null) {
                toolTip.setNode(oldNode);
            }
            g.dispose();
            return b;
        }
        return null;
    }

    public synchronized BufferedImage getToolTipImage(N node) {
        final TreeMapToolTip toolTip = this.getToolTip();
        Object oldNode = toolTip.getNode();
        toolTip.setNode(node);
        com.macrofocus.common.geom.Dimension d = toolTip.getPreferredSize(null);
        toolTip.setSize(d);
        if (toolTip.getWidth() > 0 && toolTip.getHeight() > 0) {
            BufferedImage background = new BufferedImage(toolTip.getWidth(), toolTip.getHeight(), 2);
            BufferedImage text = new BufferedImage(toolTip.getWidth(), toolTip.getHeight(), 2);
            Graphics2D bg = background.createGraphics();
            SwingTGraphics tbg = new SwingTGraphics(bg);
            Graphics2D tg = text.createGraphics();
            SwingTGraphics ttg = new SwingTGraphics(tg);
            tbg.setTextAntialias(true);
            tbg.setAntialias(true);
            try {
                Runnable paint = new Runnable(){
                    final /* synthetic */ TGraphics val$tbg;
                    final /* synthetic */ TGraphics val$ttg;
                    final /* synthetic */ BufferedImage val$text;
                    {
                        this.val$tbg = tGraphics;
                        this.val$ttg = tGraphics2;
                        this.val$text = bufferedImage;
                    }

                    @Override
                    public void run() {
                        toolTip.paintBackground(this.val$tbg);
                        toolTip.paintText(this.val$ttg);
                        this.val$tbg.drawNativeImage((Image)this.val$text, 0, 0);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(paint);
                } else {
                    paint.run();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            bg.dispose();
            tg.dispose();
            toolTip.setNode(oldNode);
            return background;
        }
        toolTip.setNode(oldNode);
        return null;
    }

    public synchronized Point getToolTipPreferredLocation(N node) {
        TreeMapToolTip toolTip = this.getToolTip();
        Object oldNode = toolTip.getNode();
        toolTip.setNode(node);
        Point p = toolTip.getPreferredLocation();
        toolTip.setNode(oldNode);
        return p;
    }

    public void waitUntilReady() {
        if (this._model != null) {
            this._model.waitUntilReady();
        }
        while (this.nativeComponent.getWidth() <= 0 || this.nativeComponent.getHeight() <= 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setShowTiming(boolean showTiming) {
        this._showTiming = showTiming;
        this.nativeComponent.repaint();
    }

    public void setProgressive(TreeMapView.Progressive progressive) {
        if (this._progressive != progressive) {
            TreeMapView.Progressive old = this._progressive;
            this._progressive = progressive;
            this.nativeComponent.firePropertyChange("progressive", old, this._progressive);
            this.nativeComponent.repaint();
        }
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public CPColor<Color> getBackground() {
        Color background = this.nativeComponent.getBackground();
        return new SwingColor(background != null ? background : Color.white);
    }

    public com.macrofocus.common.geom.Dimension getSize() {
        Dimension d = this.nativeComponent.getSize();
        return new com.macrofocus.common.geom.Dimension(d.width, d.height);
    }

    public void setSize(com.macrofocus.common.geom.Dimension dimension) {
        this.nativeComponent.setSize(new Dimension(dimension.width, dimension.height));
    }

    protected void repaint(long delay) {
        if (this.nativeComponent != null) {
            this.nativeComponent.repaint(delay);
        }
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.handler.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.handler.addMouseMotionListener(l);
    }

    public void addMouseWheelListener(CPCanvas.MouseWheelListener l) {
        this.handler.addMouseWheelListener(l);
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
        this.handler.addKeyListener(l);
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
        this.handler.addContextMenuListener(l);
    }

    public final class NativeComponent
    extends JComponent {
        public static final String uiClassID = "TreeMapUI";

        public SwingTreeMapView<N, Row, Column> getTreeMapView() {
            return SwingTreeMapView.this;
        }

        public void setUI(TreeMapUI ui) {
            super.setUI(ui);
        }

        public NativeComponent() {
            this.updateUI();
        }

        @Override
        public void updateUI() {
            if (UIManager.get(this.getUIClassID()) != null) {
                this.setUI((TreeMapUI)UIManager.getUI(this));
            } else {
                this.setUI(new BasicTreeMapUI());
            }
        }

        @Override
        public TreeMapUI getUI() {
            return (TreeMapUI)this.ui;
        }

        @Override
        public String getUIClassID() {
            return uiClassID;
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

