/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.fastvoronoi.originalconvexhull;

import com.treemap.swing.fastvoronoi.originalconvexhull.ConflictList;
import com.treemap.swing.fastvoronoi.originalconvexhull.Edge;
import com.treemap.swing.fastvoronoi.originalconvexhull.Plane3D;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vector;
import com.treemap.swing.fastvoronoi.originalconvexhull.Vertex;
import com.treemap.swing.fastvoronoi.polygon.Point2D;

public class Facet {
    private ConflictList list = new ConflictList(true);
    private boolean marked;
    private Vertex[] v = new Vertex[3];
    private Edge[] e = new Edge[3];
    private Vector normal;
    private static final double epsilon = 1.0E-10;
    private int index;
    private Point2D dualPoint;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Facet(Vertex a, Vertex b, Vertex c) {
        this.v[0] = a;
        this.v[1] = b;
        this.v[2] = c;
        this.setMarked(false);
        Vertex t = this.v[0].subtract(this.v[1]).crossProduct(this.v[1].subtract(this.v[2]));
        this.normal = new Vector(-t.x, -t.y, -t.z);
        this.normal.normalize();
        this.createEdges();
    }

    public Facet(Vertex a, Vertex b, Vertex c, Vertex orient) {
        this(a, b, c);
        this.orient(orient);
    }

    public void orient(Vertex orient) {
        if (!this.behind(orient)) {
            Vertex temp = this.v[1];
            this.v[1] = this.v[2];
            this.v[2] = temp;
            this.normal.negate();
            this.createEdges();
        }
    }

    private void createEdges() {
        this.e[0] = new Edge(this.v[0], this.v[1], this);
        this.e[1] = new Edge(this.v[1], this.v[2], this);
        this.e[2] = new Edge(this.v[2], this.v[0], this);
        this.e[0].setNext(this.e[1]);
        this.e[0].setPrev(this.e[2]);
        this.e[1].setNext(this.e[2]);
        this.e[1].setPrev(this.e[0]);
        this.e[2].setNext(this.e[0]);
        this.e[2].setPrev(this.e[1]);
    }

    public ConflictList getList() {
        return this.list;
    }

    public void setList(ConflictList list) {
        this.list = list;
    }

    public String toString() {
        return super.toString();
    }

    public Vertex getVertex(int i) {
        return this.v[i];
    }

    public boolean isVisibleFromBelow() {
        return this.normal.z < -1.4259414393190911E-9;
    }

    public int getEdgeCount() {
        return this.e.length;
    }

    public Edge getEdge(int index) {
        return this.e[index];
    }

    public Vector getNormal() {
        return this.normal;
    }

    public void setNormal(Vector normal) {
        this.normal = normal;
    }

    public void link(Facet f0, Vertex v0, Vertex v1) {
        Edge twin = f0.getEdge(v0, v1);
        if (twin == null) {
            throw new RuntimeException("Twin of Edge is NULL. Cannot Connect Edges!");
        }
        Edge edge = this.getEdge(v0, v1);
        twin.setTwin(edge);
        edge.setTwin(twin);
    }

    public void link(Edge e) {
        Edge edge = this.getEdge(e.getSource(), e.getDest());
        assert (edge != null);
        e.setTwin(edge);
        edge.setTwin(e);
    }

    private Edge getEdge(Vertex v0, Vertex v1) {
        for (int i = 0; i < 3; ++i) {
            if (!this.e[i].isEqual(v0, v1)) continue;
            return this.e[i];
        }
        return null;
    }

    public Point2D getDualPoint() {
        if (this.dualPoint == null) {
            Plane3D plane3d = new Plane3D(this);
            this.dualPoint = plane3d.getDualPointMappedToPlane();
        }
        return this.dualPoint;
    }

    public boolean behind(Vertex test) {
        return this.normal.dot(test) < this.normal.dot(this.v[0]);
    }

    public boolean conflict(Vertex test) {
        return this.normal.dot(test) > this.normal.dot(this.v[0]) + 1.0E-10;
    }

    public int getVertexCount() {
        return this.v.length;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void removeConflict() {
        this.list.removeAll();
    }

    public Edge getHorizon() {
        for (int i = 0; i < 3; ++i) {
            if (this.e[i].getTwin() == null || !this.e[i].getTwin().isHorizon()) continue;
            return this.e[i];
        }
        return null;
    }
}

