/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.originalfastvoronoi.convexHull;

import com.treemap.swing.originalfastvoronoi.convexHull.HEdge;
import com.treemap.swing.originalfastvoronoi.convexHull.JConflictList;
import com.treemap.swing.originalfastvoronoi.convexHull.JVector;
import com.treemap.swing.originalfastvoronoi.convexHull.JVertex;
import com.treemap.swing.originalfastvoronoi.j2d.Point2D;
import com.treemap.swing.originalfastvoronoi.j3d.Plane3D;
import java.util.Arrays;

public class JFace {
    private JConflictList list = new JConflictList(true);
    private boolean marked;
    private JVertex[] v = new JVertex[3];
    private HEdge[] e = new HEdge[3];
    private JVector normal;
    private static final double epsilon = 1.0E-10;
    private int index;
    private Point2D dualPoint;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public JFace(JVertex a, JVertex b, JVertex c) {
        this.v[0] = a;
        this.v[1] = b;
        this.v[2] = c;
        this.setMarked(false);
        JVertex t = this.v[0].subtract(this.v[1]).crossProduct(this.v[1].subtract(this.v[2]));
        this.normal = new JVector(-t.x, -t.y, -t.z);
        this.normal.normalize();
        this.createEdges();
    }

    public JFace(JVertex a, JVertex b, JVertex c, JVertex orient) {
        this(a, b, c);
        this.orient(orient);
    }

    public void orient(JVertex orient) {
        if (!this.behind(orient)) {
            JVertex temp = this.v[1];
            this.v[1] = this.v[2];
            this.v[2] = temp;
            this.normal.negate();
            this.createEdges();
        }
    }

    private void createEdges() {
        this.e[0] = new HEdge(this.v[0], this.v[1], this);
        this.e[1] = new HEdge(this.v[1], this.v[2], this);
        this.e[2] = new HEdge(this.v[2], this.v[0], this);
        this.e[0].setNext(this.e[1]);
        this.e[0].setPrev(this.e[2]);
        this.e[1].setNext(this.e[2]);
        this.e[1].setPrev(this.e[0]);
        this.e[2].setNext(this.e[0]);
        this.e[2].setPrev(this.e[1]);
    }

    public JConflictList getList() {
        return this.list;
    }

    public void setList(JConflictList list) {
        this.list = list;
    }

    public String toString2() {
        return super.toString();
    }

    public JVertex getVertex(int i) {
        return this.v[i];
    }

    public boolean isVisibleFromBelow() {
        return this.normal.z < -1.4259414393190911E-9;
    }

    public int getEdgeCount() {
        return this.e.length;
    }

    public HEdge getEdge(int index) {
        return this.e[index];
    }

    public JVector getNormal() {
        return this.normal;
    }

    public void setNormal(JVector normal) {
        this.normal = normal;
    }

    public void link(JFace f0, JVertex v0, JVertex v1) {
        HEdge twin = f0.getEdge(v0, v1);
        if (twin == null) {
            throw new RuntimeException("Twin of Edge is NULL. Cannot Connect Edges!");
        }
        HEdge edge = this.getEdge(v0, v1);
        twin.setTwin(edge);
        edge.setTwin(twin);
    }

    public void link(HEdge e) {
        HEdge edge = this.getEdge(e.getOrigin(), e.getDest());
        e.setTwin(edge);
        edge.setTwin(e);
    }

    private HEdge getEdge(JVertex v0, JVertex v1) {
        for (int i = 0; i < 3; ++i) {
            if (!this.e[i].isEqual(v0, v1)) continue;
            return this.e[i];
        }
        return null;
    }

    public Point2D getDualPoint() {
        if (this.dualPoint == null) {
            Plane3D plane3d = new Plane3D(this);
            this.dualPoint = plane3d.getDualPointMappedToPlane();
        }
        return this.dualPoint;
    }

    public boolean behind(JVertex test) {
        return this.normal.dot(test) < this.normal.dot(this.v[0]);
    }

    public boolean conflict(JVertex test) {
        return this.normal.dot(test) > this.normal.dot(this.v[0]) + 1.0E-10;
    }

    public int getVertexCount() {
        return this.v.length;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void removeConflict() {
        this.list.removeAll();
    }

    public HEdge getHorizon() {
        for (int i = 0; i < 3; ++i) {
            if (this.e[i].getTwin() == null || !this.e[i].getTwin().isHorizon()) continue;
            return this.e[i];
        }
        return null;
    }

    public String toString() {
        return "JFace{, normal=" + String.valueOf(this.normal) + "v=" + Arrays.toString(this.v) + ", e=" + Arrays.toString(this.e) + ", index=" + this.index + ", dualPoint=" + String.valueOf(this.dualPoint) + "}";
    }
}

