/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.JDBCDatabaseDriver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class OracleDatabaseDriver
extends JDBCDatabaseDriver {
    private static final String className = "oracle.jdbc.driver.OracleDriver";

    public static boolean exist() {
        return OracleDatabaseDriver.exist(className);
    }

    @Override
    public String getClassName() {
        return className;
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "@" + host;
        }
        return url;
    }

    @Override
    public String getQuery(String query) {
        return query;
    }

    @Override
    public String getPrefix() {
        return "oracle:thin";
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        String url = this.getURL(host, null, username, password);
        Connection conn = DriverManager.getConnection(url, username, password);
        ArrayList<String> databases = new ArrayList<String>();
        ResultSet schemas = conn.getMetaData().getSchemas();
        while (schemas.next()) {
            databases.add(schemas.getString(1));
        }
        return databases;
    }

    @Override
    public Iterable<String> getTables(String url, String database, String username, String password) throws SQLException {
        Connection conn = DriverManager.getConnection(url, username, password);
        ArrayList<String> tables = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet result = meta.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
        while (result.next()) {
            String schema = result.getString("TABLE_SCHEM");
            if (database != null && !database.equalsIgnoreCase(schema)) continue;
            tables.add(result.getString("TABLE_NAME"));
        }
        return tables;
    }

    public String toString() {
        return "Oracle";
    }
}

