/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.resources;

import com.macrofocus.data.properties.SimplePropertiesModel;
import com.macrofocus.resources.AbstractResourcesModel;
import com.macrofocus.resources.LocaleHelper;
import com.macrofocus.resources.PreferencesHelper;
import com.macrofocus.resources.ResourcesEvent;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SimpleResourcesModel
extends AbstractResourcesModel {
    private final Class mainClass;
    private final List classes;
    private PropertiesModel propertiesModel;
    private Locale locale;
    private Set preferencesKeys;

    public SimpleResourcesModel(Class mainClass, Locale locale, String[] preferences) {
        this.mainClass = mainClass;
        this.classes = new Vector();
        this.preferencesKeys = new HashSet();
        for (int i = 0; i < preferences.length; ++i) {
            String preference = preferences[i];
            this.preferencesKeys.add(preference);
        }
        this.setLocale(locale);
    }

    public SimpleResourcesModel(Class mainClass, Locale locale) {
        this.mainClass = mainClass;
        this.classes = new Vector();
        this.preferencesKeys = null;
        this.setLocale(locale);
    }

    public URL getUrl(String filename) {
        return this.mainClass.getResource(filename);
    }

    public URL getUrl(Class context, String filename) {
        URL url = context.getResource(filename);
        return url;
    }

    public URL getLocalizedUrl(String name, String extension) {
        Enumeration enumeration = LocaleHelper.getCandidates((Locale)this.locale);
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            String filename = name + s2 + extension;
            URL url = this.getUrl(filename);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public PropertiesModel getPropertiesModel() {
        return this.propertiesModel;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.reload();
        }
    }

    public void reload() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new SimplePropertiesModel();
        }
        SimplePropertiesModel propertiesModel = new SimplePropertiesModel();
        for (int i = 0; i < this.classes.size(); ++i) {
            Class cl = (Class)this.classes.get(i);
            this.loadProperties((PropertiesModel)propertiesModel, cl);
        }
        this.propertiesModel.resetValues((PropertiesModel)propertiesModel);
        this.notifyResourcesLocaleChanged(new ResourcesEvent((Object)this, (ResourcesModel)this));
    }

    public void retrievePreferences() {
        if (this.preferencesKeys != null) {
            try {
                Object newValue;
                Object currentValue;
                String key;
                int i;
                Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
                String[] keys = userPreferencesRoot.keys();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!this.preferencesKeys.contains(key)) continue;
                    currentValue = this.propertiesModel.getValue(key);
                    try {
                        if (currentValue instanceof String) {
                            newValue = userPreferencesRoot.get(key, (String)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.put(key, (String)newValue);
                            continue;
                        }
                        if (currentValue instanceof Boolean) {
                            newValue = userPreferencesRoot.getBoolean(key, (Boolean)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putBoolean(key, (Boolean)newValue);
                            continue;
                        }
                        if (currentValue instanceof Double) {
                            newValue = userPreferencesRoot.getDouble(key, (Double)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putDouble(key, (Double)newValue);
                            continue;
                        }
                        if (currentValue instanceof Float) {
                            newValue = Float.valueOf(userPreferencesRoot.getFloat(key, ((Float)currentValue).floatValue()));
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putFloat(key, ((Float)newValue).floatValue());
                            continue;
                        }
                        if (currentValue instanceof Integer) {
                            newValue = userPreferencesRoot.getInt(key, (Integer)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putInt(key, (Integer)newValue);
                            continue;
                        }
                        if (currentValue instanceof Long) {
                            newValue = userPreferencesRoot.getLong(key, (Long)currentValue);
                            this.propertiesModel.setValue(key, newValue);
                            userPreferencesRoot.putLong(key, (Long)newValue);
                            continue;
                        }
                        if (currentValue instanceof String[]) continue;
                        try {
                            Object value = PreferencesHelper.getObject((Preferences)userPreferencesRoot, (String)key);
                            if (value == null) continue;
                            this.propertiesModel.setValue(key, value);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                }
                keys = userPreferencesRoot.childrenNames();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!this.preferencesKeys.contains(key) || !((currentValue = this.propertiesModel.getValue(key)) instanceof String[])) continue;
                    newValue = PreferencesHelper.loadArray((Preferences)userPreferencesRoot.node(key));
                    this.propertiesModel.setValue(key, newValue);
                }
            }
            catch (AccessControlException userPreferencesRoot) {
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void savePreferences() {
        if (this.preferencesKeys != null) {
            try {
                Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
                for (String key : this.preferencesKeys) {
                    if (!this.propertiesModel.isAvailable(key)) continue;
                    Object value = this.propertiesModel.getValue(key);
                    if (value instanceof String) {
                        userPreferencesRoot.put(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        userPreferencesRoot.putBoolean(key, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        userPreferencesRoot.putDouble(key, (Double)value);
                        continue;
                    }
                    if (value instanceof Float) {
                        userPreferencesRoot.putFloat(key, ((Float)value).floatValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        userPreferencesRoot.putInt(key, (Integer)value);
                        continue;
                    }
                    if (value instanceof Long) {
                        userPreferencesRoot.putLong(key, (Long)value);
                        continue;
                    }
                    if (value instanceof String[]) {
                        try {
                            PreferencesHelper.saveArray((Preferences)userPreferencesRoot.node(key), (String[])((String[])value));
                        }
                        catch (BackingStoreException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        PreferencesHelper.putObject((Preferences)userPreferencesRoot, (String)key, (Object)value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    userPreferencesRoot.sync();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    public void resetPreferences() {
        if (this.preferencesKeys != null) {
            Preferences userPreferencesRoot = Preferences.userNodeForPackage(this.mainClass);
            try {
                userPreferencesRoot.clear();
                userPreferencesRoot.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadProperties(PropertiesModel propertiesModel, Class cl) {
        URL localeUrl;
        URL url = this.getUrl(cl, "properties.txt");
        if (url != null) {
            if (propertiesModel != null) {
                propertiesModel.setValues((PropertiesModel)new SimplePropertiesModel(url));
            } else {
                propertiesModel = new SimplePropertiesModel(url);
            }
        }
        if ((localeUrl = this.getUrl(cl, "properties_" + this.locale.getLanguage() + ".txt")) != null) {
            if (propertiesModel != null) {
                propertiesModel.setValues((PropertiesModel)new SimplePropertiesModel(url));
            } else {
                propertiesModel = new SimplePropertiesModel(url);
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addClass(Class cl) {
        this.classes.add(cl);
        this.loadProperties(this.propertiesModel, cl);
        this.notifyResourcesLocaleChanged(new ResourcesEvent((Object)this, (ResourcesModel)this));
    }
}

