/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.source.HTMLTableDataSource;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.data.table.TreeMapTableModel;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.util.file.CharsetToolkit;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import nu.xom.Document;
import org.jsoup.Jsoup;

public class ClipboardDataSource
extends AbstractDataSource {
    public static final String type = "Clipboard";
    private final Clipboard clipboard;
    private final String defaultCharset;
    private final TypemapModel.Builder[] builders;

    public ClipboardDataSource(Clipboard clipboard, String defaultCharset, TypemapModel.Builder ... builders) {
        this.clipboard = clipboard;
        this.defaultCharset = defaultCharset;
        this.builders = builders;
    }

    public ClipboardDataSource(Clipboard clipboard) {
        this(clipboard, "UTF-8", new TypemapModel.Builder[0]);
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        try {
            Transferable t = this.clipboard.getContents(null);
            DataFlavor htmlFlavor = new DataFlavor("text/html;class=java.lang.String");
            if (t.isDataFlavorSupported(htmlFlavor)) {
                BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
                DefaultTableModel tableModel = HTMLTableDataSource.parseHtmlTable(Jsoup.parse((InputStream)bis, (String)"UTF-8", (String)""));
                bis.close();
                return tableModel;
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return this.loadTableModel(contentPane, true);
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        return null;
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        try {
            Transferable t = this.clipboard.getContents(null);
            DataFlavor htmlFlavor = new DataFlavor("text/html;class=java.lang.String");
            if (t.isDataFlavorSupported(htmlFlavor)) {
                BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
                DefaultTableModel tableModel = HTMLTableDataSource.parseHtmlTable(Jsoup.parse((InputStream)bis, (String)"UTF-8", (String)""));
                bis.close();
                return new DefaultDataFrame<Object>(tableModel, true);
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return new DefaultDataFrame<Object>(this.loadTableModel(contentPane, false), true);
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        return null;
    }

    BufferedInputStream getInputStream(Component contentPane) throws IOException, UnsupportedFlavorException, ClassNotFoundException {
        DataFlavor htmlFlavor;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(null);
        if (t.isDataFlavorSupported(htmlFlavor = new DataFlavor("text/html;class=java.lang.String"))) {
            String html = (String)t.getTransferData(htmlFlavor);
            return new BufferedInputStream(new ByteArrayInputStream(html.getBytes("UTF-8")));
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String text = (String)t.getTransferData(DataFlavor.stringFlavor);
            return new BufferedInputStream(new ByteArrayInputStream(text.getBytes("UTF-8")));
        }
        return null;
    }

    public TableModel loadTableModel(Component contentPane, boolean autoConvert) throws IOException, SQLException, UnsupportedFlavorException, ClassNotFoundException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        BufferedReader reader = new CharsetToolkit(bis, Charset.forName(this.defaultCharset)).getReader();
        PerfectDataReader dataReader = new PerfectDataReader(reader, TokenizerFactory.getTabDelimitedInstance(), true, false, "String", 0, Integer.MAX_VALUE, 1, DefaultTypemapModel.getInstance(), this.builders);
        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader, autoConvert);
        bis.close();
        if (TreeMapTableModel.containsEmptyColumn(tableModel)) {
            return new TreeMapTableModel(tableModel);
        }
        return tableModel;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }

    @Override
    public Element save(File file, ElementFactory elementFactory) {
        return null;
    }
}

