/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.AbstractDataSource;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.table.TableModel;
import nu.xom.Document;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

public class OSProcessesDataSource
extends AbstractDataSource {
    static final String type = "OSProcesses";

    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        final OSProcess[] processTable = os.getProcesses(0, OperatingSystem.ProcessSort.PID);
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return processTable.length;
            }

            @Override
            public int getColumnCount() {
                return 21;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                OSProcess entry = processTable[rowIndex];
                switch (columnIndex) {
                    case 0: {
                        return entry.getName();
                    }
                    case 1: {
                        return entry.getPath();
                    }
                    case 2: {
                        return entry.getCommandLine();
                    }
                    case 3: {
                        return entry.getCurrentWorkingDirectory();
                    }
                    case 4: {
                        return entry.getUser();
                    }
                    case 5: {
                        return entry.getUserID();
                    }
                    case 6: {
                        return entry.getGroup();
                    }
                    case 7: {
                        return entry.getGroupID();
                    }
                    case 8: {
                        return entry.getState().name();
                    }
                    case 9: {
                        return entry.getProcessID();
                    }
                    case 10: {
                        return entry.getParentProcessID();
                    }
                    case 11: {
                        return entry.getThreadCount();
                    }
                    case 12: {
                        return entry.getPriority();
                    }
                    case 13: {
                        return entry.getVirtualSize();
                    }
                    case 14: {
                        return entry.getResidentSetSize();
                    }
                    case 15: {
                        return entry.getKernelTime();
                    }
                    case 16: {
                        return entry.getUserTime();
                    }
                    case 17: {
                        return entry.getUpTime();
                    }
                    case 18: {
                        return entry.getStartTime();
                    }
                    case 19: {
                        return entry.getBytesRead();
                    }
                    case 20: {
                        return entry.getBytesWritten();
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Path";
                    }
                    case 2: {
                        return "Command Line";
                    }
                    case 3: {
                        return "Current Working Directory";
                    }
                    case 4: {
                        return "User";
                    }
                    case 5: {
                        return "User ID";
                    }
                    case 6: {
                        return "Group";
                    }
                    case 7: {
                        return "Group ID";
                    }
                    case 8: {
                        return "State";
                    }
                    case 9: {
                        return "Process ID";
                    }
                    case 10: {
                        return "Parent Process ID";
                    }
                    case 11: {
                        return "ThreadCount";
                    }
                    case 12: {
                        return "Priority";
                    }
                    case 13: {
                        return "Virtual Size";
                    }
                    case 14: {
                        return "Resident Set Size";
                    }
                    case 15: {
                        return "Kernel Time";
                    }
                    case 16: {
                        return "User Time";
                    }
                    case 17: {
                        return "Up Time";
                    }
                    case 18: {
                        return "Start Time";
                    }
                    case 19: {
                        return "Bytes Read";
                    }
                    case 20: {
                        return "Bytes Written";
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                    case 3: {
                        return String.class;
                    }
                    case 4: {
                        return String.class;
                    }
                    case 5: {
                        return String.class;
                    }
                    case 6: {
                        return String.class;
                    }
                    case 7: {
                        return String.class;
                    }
                    case 8: {
                        return String.class;
                    }
                    case 9: {
                        return Integer.class;
                    }
                    case 10: {
                        return Integer.class;
                    }
                    case 11: {
                        return Integer.class;
                    }
                    case 12: {
                        return Integer.class;
                    }
                    case 13: {
                        return Long.class;
                    }
                    case 14: {
                        return Long.class;
                    }
                    case 15: {
                        return Long.class;
                    }
                    case 16: {
                        return Long.class;
                    }
                    case 17: {
                        return Long.class;
                    }
                    case 18: {
                        return Long.class;
                    }
                    case 19: {
                        return Long.class;
                    }
                    case 20: {
                        return Long.class;
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Element save(File file, ElementFactory factory) {
        Element dataSource = factory.newElement("DataSource");
        dataSource.addAttribute(factory.newAttribute("type", this.getType()));
        return dataSource;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        return null;
    }
}

