/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractTableModel
implements TableModel {
    protected List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    @Override
    public String getColumnName(int column) {
        Object result = "";
        while (column >= 0) {
            result = (char)((char)(column % 26) + 65) + (String)result;
            column = column / 26 - 1;
        }
        return result;
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columnName.equals(this.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    protected void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    protected void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    protected void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    protected void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(e);
        }
    }
}

