/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.util.file.FileHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileSystemView;

public class DirectoryStructureTableModel
extends AbstractTableModel {
    private final List<Object[]> list;
    private final FileSystemView view;
    private final ProgressMonitor progressMonitor;
    private int progress = 0;
    private final Calendar calendar = Calendar.getInstance();

    public DirectoryStructureTableModel(File root, ProgressMonitor progressMonitor) {
        this.list = new ArrayList<Object[]>();
        this.progressMonitor = progressMonitor;
        this.view = FileSystemView.getFileSystemView();
        if (progressMonitor != null) {
            progressMonitor.setMaximum(1);
        }
        this.visit(root, new String[0]);
        ++this.progress;
        if (progressMonitor != null) {
            progressMonitor.setProgress(this.progress);
        }
    }

    private void visit(File parent, String[] path) {
        if (this.progressMonitor == null || !this.progressMonitor.isCanceled()) {
            ArrayList<File> toVisit = new ArrayList<File>();
            for (File child : parent.listFiles()) {
                if (child.isDirectory()) {
                    toVisit.add(child);
                    continue;
                }
                Icon icon = null;
                try {
                    if (child.exists()) {
                        icon = this.view.getSystemIcon(child);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.list.add(this.toArray(path, child, icon));
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.setMaximum(this.progressMonitor.getMaximum() + toVisit.size());
            }
            for (File child : toVisit) {
                if (this.progressMonitor != null) {
                    this.progressMonitor.setNote(child.getName());
                }
                String[] newPath = new String[path.length + 1];
                System.arraycopy(path, 0, newPath, 0, path.length);
                newPath[newPath.length - 1] = child.getName();
                this.visit(child, newPath);
                ++this.progress;
                if (this.progressMonitor == null) continue;
                this.progressMonitor.setProgress(this.progress);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Path";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Size";
            }
            case 4: {
                return "Modified";
            }
            case 5: {
                return "Year";
            }
            case 6: {
                return "Month";
            }
            case 7: {
                return "Day";
            }
            case 8: {
                return "Day of Week";
            }
            case 9: {
                return "Hour";
            }
            case 10: {
                return "Icon";
            }
            case 11: {
                return "Path";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String[].class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return Integer.class;
            }
            case 10: {
                return Icon.class;
            }
            case 11: {
                return String.class;
            }
        }
        return null;
    }

    private Object[] toArray(String[] path, File entry, Icon icon) {
        this.calendar.setTimeInMillis(entry.lastModified());
        Object[] array = new Object[]{path, FileHelper.getName(entry.getName()), FileHelper.getSuffix(entry.getName()), entry.length(), new Date(entry.lastModified()), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(7), this.calendar.get(10), icon, FileHelper.getPath(entry.getAbsolutePath())};
        return array;
    }
}

