/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.JDBCTypes;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.data.type.convert.ExtendedAutoConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class RowMajorTableModel
extends AbstractTableModel
implements Externalizable {
    public static final long serialVersionUID = -3175316423606085277L;
    private Object[][] objects;
    private String[] names;
    private Class[] classes;

    public RowMajorTableModel() {
    }

    public RowMajorTableModel(String[] names, Class[] classes, Object[][] objects) {
        this.names = names;
        this.classes = classes;
        this.objects = objects;
    }

    public RowMajorTableModel(TableModel tableModel) {
        this(tableModel, false, false);
    }

    public RowMajorTableModel(TableModel tableModel, boolean autoConvert, boolean stripEmptyColumn) {
        Map<Object, Object> recycler = this.createRecycler();
        if (stripEmptyColumn) {
            int c;
            ArrayList<Integer> columns = new ArrayList<Integer>();
            block0: for (c = 0; c < tableModel.getColumnCount(); ++c) {
                String columnName = tableModel.getColumnName(c);
                if (columnName != null && !columnName.trim().equals("")) {
                    columns.add(c);
                    continue;
                }
                for (int r = 0; r < tableModel.getRowCount(); ++r) {
                    Object value = tableModel.getValueAt(r, c);
                    if (value == null) continue;
                    if (value instanceof String) {
                        String s = (String)value;
                        if (s.trim().equals("")) continue;
                        columns.add(c);
                        continue block0;
                    }
                    columns.add(c);
                    continue block0;
                }
            }
            this.names = new String[columns.size()];
            this.classes = new Class[columns.size()];
            this.objects = new Object[tableModel.getRowCount()][columns.size()];
            for (c = 0; c < columns.size(); ++c) {
                int column = (Integer)columns.get(c);
                this.names[c] = tableModel.getColumnName(column);
                this.classes[c] = tableModel.getColumnClass(column);
                for (int row = 0; row < tableModel.getRowCount(); ++row) {
                    this.objects[row][c] = RowMajorTableModel.recycle(recycler, tableModel.getValueAt(row, column));
                }
            }
        } else {
            this.names = new String[tableModel.getColumnCount()];
            this.classes = new Class[tableModel.getColumnCount()];
            this.objects = new Object[tableModel.getRowCount()][tableModel.getColumnCount()];
            for (int column = 0; column < tableModel.getColumnCount(); ++column) {
                int row;
                this.names[column] = tableModel.getColumnName(column);
                this.classes[column] = tableModel.getColumnClass(column);
                if (this.classes[column] != null && (this.classes[column] != Float.class || this.classes[column] != Double.class)) {
                    for (row = 0; row < tableModel.getRowCount(); ++row) {
                        this.objects[row][column] = tableModel.getValueAt(row, column);
                    }
                    continue;
                }
                for (row = 0; row < tableModel.getRowCount(); ++row) {
                    this.objects[row][column] = RowMajorTableModel.recycle(recycler, tableModel.getValueAt(row, column));
                }
            }
        }
        if (autoConvert) {
            this.autoConvert();
        }
    }

    private Map<Object, Object> createRecycler() {
        try {
            return new WeakHashMap<Object, Object>();
        }
        catch (Error e) {
            e.printStackTrace();
            return new HashMap<Object, Object>();
        }
    }

    private static Object recycle(Map<Object, Object> recycler, Object object) {
        if (object != null) {
            if (!(object instanceof String) && !(object instanceof Integer)) {
                return object;
            }
            Object value = recycler.get(object);
            if (value != null) {
                return value;
            }
            if (object instanceof String && !RowMajorTableModel.isFloatingPoint((String)object) || object instanceof Integer) {
                recycler.put(object, object);
            }
            return object;
        }
        return object;
    }

    private static boolean isFloatingPoint(String string) {
        int length = string.length();
        boolean floatingPoint = false;
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (Character.isDigit(ch)) continue;
            if (ch != '.') {
                return false;
            }
            ++i;
            while (i < length) {
                ch = string.charAt(i);
                if (Character.isDigit(ch)) {
                    if (ch != '0') {
                        floatingPoint = true;
                    }
                } else {
                    return false;
                }
                ++i;
            }
        }
        return floatingPoint;
    }

    private void autoConvert() {
        boolean fireEvent = false;
        int column = 0;
        while (column < this.getColumnCount()) {
            final int c = column++;
            TypeConverter.Input input = new TypeConverter.Input(){

                public Class getType() {
                    return RowMajorTableModel.this.getColumnClass(c);
                }

                public Object get(int index) {
                    return RowMajorTableModel.this.getValueAt(index, c);
                }

                public int size() {
                    return RowMajorTableModel.this.getRowCount();
                }
            };
            TypeConverter.Output output = new TypeConverter.Output(){

                public void setType(Class type) {
                    RowMajorTableModel.this.classes[c] = type;
                }

                public void set(int index, Object value) {
                    RowMajorTableModel.this.objects[index][c] = value;
                }
            };
            fireEvent |= new ExtendedAutoConverter().convert(input, output);
        }
        if (fireEvent) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.objects.length;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.objects[row][column];
    }

    public RowMajorTableModel(TableModel tableModel, boolean autoConvert) {
        this(tableModel, autoConvert, true);
    }

    public RowMajorTableModel(boolean autoConvert, TableModel ... tableModels) {
        Map<Object, Object> recycler = this.createRecycler();
        TableModel tableModel = tableModels[0];
        int rowCount = 0;
        for (TableModel model : tableModels) {
            rowCount += model.getRowCount();
        }
        this.names = new String[tableModel.getColumnCount()];
        this.classes = new Class[tableModel.getColumnCount()];
        this.objects = new Object[rowCount + 50][tableModel.getColumnCount()];
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            this.names[column] = tableModel.getColumnName(column);
            this.classes[column] = tableModel.getColumnClass(column);
        }
        int r = 0;
        for (TableModel model : tableModels) {
            for (int column = 0; column < model.getColumnCount(); ++column) {
                int row;
                if (this.classes[column] != null && (this.classes[column] != Float.class || this.classes[column] != Double.class)) {
                    for (row = 0; row < model.getRowCount(); ++row) {
                        this.objects[r + row][column] = model.getValueAt(row, column);
                    }
                    continue;
                }
                for (row = 0; row < model.getRowCount(); ++row) {
                    this.objects[r + row][column] = RowMajorTableModel.recycle(recycler, model.getValueAt(row, column));
                }
            }
            r += tableModel.getRowCount();
        }
        if (autoConvert) {
            this.autoConvert();
        }
    }

    public RowMajorTableModel(ResultSet rs) throws SQLException {
        this(null, rs);
    }

    public RowMajorTableModel(DatabaseDriver driver, ResultSet rs) throws SQLException {
        Map<Object, Object> recycler = this.createRecycler();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        this.classes = new Class[columnCount];
        this.names = new String[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            String name;
            this.names[c - 1] = name = meta.getColumnName(c);
            if (driver != null) {
                this.classes[c - 1] = driver.getColumnType(meta, c);
                continue;
            }
            int type = meta.getColumnType(c);
            this.classes[c - 1] = JDBCTypes.getType(type);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int column = 1; column <= columnCount; ++column) {
                Object object;
                Class columnType = this.classes[column - 1];
                if (driver != null) {
                    row[column - 1] = driver.getColumnValue(rs, columnType, column);
                    continue;
                }
                if (columnType.equals(String.class)) {
                    object = rs.getString(column);
                } else if (columnType.equals(Byte.class)) {
                    object = rs.getByte(column);
                } else if (columnType.equals(Short.class)) {
                    object = rs.getShort(column);
                } else if (columnType.equals(Integer.class)) {
                    object = rs.getInt(column);
                } else if (columnType.equals(Long.class)) {
                    object = rs.getLong(column);
                } else if (columnType.equals(Float.class)) {
                    object = Float.valueOf(rs.getFloat(column));
                } else if (columnType.equals(Double.class)) {
                    object = rs.getDouble(column);
                } else if (columnType.equals(BigDecimal.class)) {
                    object = rs.getBigDecimal(column);
                } else if (columnType.equals(Boolean.class)) {
                    object = rs.getBoolean(column);
                } else if (columnType.equals(Date.class)) {
                    object = rs.getDate(column);
                } else if (columnType.equals(Timestamp.class)) {
                    object = rs.getTimestamp(column);
                } else {
                    object = rs.getObject(column);
                    System.err.println("RowMajorTableModel: Unknown class " + String.valueOf(columnType) + " for value " + String.valueOf(object.getClass()));
                }
                if (rs.wasNull()) {
                    object = null;
                }
                row[column - 1] = RowMajorTableModel.recycle(recycler, object);
            }
            rows.add(row);
        }
        this.objects = new Object[rows.size()][];
        for (int row = 0; row < rows.size(); ++row) {
            this.objects[row] = (Object[])rows.get(row);
        }
    }

    public RowMajorTableModel(DataReader reader) {
        this(reader, true);
    }

    public RowMajorTableModel(DataReader reader, boolean autoConvert) {
        Map<Object, Object> recycler = this.createRecycler();
        this.names = new String[reader.getColumnCount()];
        this.classes = new Class[reader.getColumnCount()];
        for (int i = 0; i < reader.getColumnCount(); ++i) {
            Object columnName = reader.getColumnName(i);
            this.names[i] = columnName != null ? columnName.toString() : null;
            this.classes[i] = reader.getClass(i);
        }
        Object[] previousRow = null;
        if (reader.getRowCount() == -1) {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (reader.hasMoreRow()) {
                reader.nextRow();
                if (!reader.hasMoreColumn()) continue;
                Object[] row = new Object[reader.getColumnCount()];
                boolean dataFound = false;
                for (int i = 0; i < reader.getColumnCount(); ++i) {
                    if (reader.hasMoreColumn()) {
                        Object feature = RowMajorTableModel.recycle(recycler, reader.nextColumn());
                        if (feature == null) continue;
                        row[i] = feature;
                        if (previousRow != null && previousRow[i] != null && previousRow[i].equals(row[i])) {
                            row[i] = previousRow[i];
                        }
                        dataFound = true;
                        continue;
                    }
                    row[i] = null;
                }
                if (!dataFound) continue;
                rows.add(row);
                previousRow = row;
            }
            this.objects = new Object[rows.size()][];
            for (int row = 0; row < rows.size(); ++row) {
                this.objects[row] = (Object[])rows.get(row);
            }
        } else {
            this.objects = new Object[reader.getRowCount()][reader.getColumnCount()];
            for (int row = 0; row < reader.getRowCount(); ++row) {
                for (int column = 0; column < reader.getColumnCount(); ++column) {
                    Object o = reader.nextColumn();
                    if (row > 0 && this.objects[row - 1][column] != null && this.objects[row - 1][column].equals(o)) {
                        o = this.objects[row - 1][column];
                    }
                    this.objects[row][column] = o;
                }
                reader.nextRow();
            }
        }
        if (autoConvert && !reader.isHasClassHeader()) {
            this.autoConvert();
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.names[column];
    }

    public Class getColumnClass(int column) {
        return this.classes[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.objects[rowIndex][columnIndex] = aValue;
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void convert(int column, Class cl, ValuesConverter converter) {
        for (int row = 0; row < this.objects.length; ++row) {
            this.objects[row][column] = converter.convert(this.objects[row][column]);
        }
        this.classes[column] = cl;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int column;
        out.writeInt(10000);
        out.writeInt(this.getRowCount());
        out.writeInt(this.getColumnCount());
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeUTF(this.names[column]);
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            out.writeObject(this.classes[column]);
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                out.writeBoolean(this.isAvailable(row, column2));
            }
        }
        for (column = 0; column < this.getColumnCount(); ++column) {
            Class cl = this.getColumnClass(column);
            if (cl == Double.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeDouble((Double)this.objects[row][column]);
                }
                continue;
            }
            if (cl == Float.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeFloat(((Float)this.objects[row][column]).floatValue());
                }
                continue;
            }
            if (cl == Long.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeLong((Long)this.objects[row][column]);
                }
                continue;
            }
            if (cl == Integer.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeInt((Integer)this.objects[row][column]);
                }
                continue;
            }
            if (cl == Short.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeShort(((Short)this.objects[row][column]).shortValue());
                }
                continue;
            }
            if (cl == Byte.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeByte(((Byte)this.objects[row][column]).byteValue());
                }
                continue;
            }
            if (cl == Boolean.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    out.writeBoolean((Boolean)this.objects[row][column]);
                }
                continue;
            }
            if (cl == BufferedImage.class) {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    boolean useCache = ImageIO.getUseCache();
                    ImageIO.setUseCache(false);
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((BufferedImage)this.objects[row][column]), "png", bao);
                    byte[] ba = bao.toByteArray();
                    out.writeObject(ba);
                    ImageIO.setUseCache(useCache);
                }
                continue;
            }
            if (Geometry.class.isAssignableFrom(cl)) {
                WKBWriter writer = new WKBWriter();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    if (!this.isAvailable(row, column)) continue;
                    byte[] write = writer.write((Geometry)this.objects[row][column]);
                    out.writeObject(write);
                }
                continue;
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                if (!this.isAvailable(row, column)) continue;
                out.writeObject(this.objects[row][column]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            int column;
            int rowCount = in.readInt();
            int columnCount = in.readInt();
            this.names = new String[columnCount];
            this.classes = new Class[columnCount];
            this.objects = new Object[rowCount][columnCount];
            for (column = 0; column < columnCount; ++column) {
                this.names[column] = in.readUTF();
            }
            for (column = 0; column < columnCount; ++column) {
                this.classes[column] = (Class)in.readObject();
            }
            boolean[][] isAvailable = new boolean[rowCount][columnCount];
            for (int row = 0; row < this.getRowCount(); ++row) {
                for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
                    isAvailable[row][column2] = in.readBoolean();
                }
            }
            for (int column3 = 0; column3 < this.getColumnCount(); ++column3) {
                byte[] array;
                Class cl = this.getColumnClass(column3);
                if (cl == Double.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Double.valueOf(in.readDouble()) : null;
                    }
                    continue;
                }
                if (cl == Float.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Float.valueOf(in.readFloat()) : null;
                    }
                    continue;
                }
                if (cl == Long.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Long.valueOf(in.readLong()) : null;
                    }
                    continue;
                }
                if (cl == Integer.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Integer.valueOf(in.readInt()) : null;
                    }
                    continue;
                }
                if (cl == Short.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Short.valueOf(in.readShort()) : null;
                    }
                    continue;
                }
                if (cl == Byte.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            Byte o = in.readByte();
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (cl == Boolean.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        this.objects[row][column3] = isAvailable[row][column3] ? Boolean.valueOf(in.readBoolean()) : null;
                    }
                    continue;
                }
                if (cl == BufferedImage.class) {
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            boolean useCache = ImageIO.getUseCache();
                            ImageIO.setUseCache(false);
                            array = (byte[])in.readObject();
                            ByteArrayInputStream bai = new ByteArrayInputStream(array);
                            BufferedImage o = ImageIO.read(bai);
                            ImageIO.setUseCache(useCache);
                            this.objects[row][column3] = o;
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                if (Geometry.class.isAssignableFrom(cl)) {
                    WKBReader reader = new WKBReader();
                    for (int row = 0; row < this.getRowCount(); ++row) {
                        if (isAvailable[row][column3]) {
                            array = (byte[])in.readObject();
                            try {
                                this.objects[row][column3] = reader.read(array);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        this.objects[row][column3] = null;
                    }
                    continue;
                }
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.objects[row][column3] = isAvailable[row][column3] ? in.readObject() : null;
                }
            }
        }
    }

    private boolean isAvailable(int row, int column) {
        return this.objects[row][column] != null;
    }

    public static interface ValuesConverter {
        public Object convert(Object var1);
    }
}

