/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.writer;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.writer.DataWriter;
import java.io.DataOutputStream;
import java.io.IOException;

public class BinaryDataWriter
implements DataWriter {
    private final DataOutputStream stream;
    private int row;
    private int column;
    private int lineNumber;
    private static final int MAGIC = 299792;

    public BinaryDataWriter(DataOutputStream stream) {
        this.stream = stream;
        this.row = -1;
        this.column = -1;
        this.lineNumber = 0;
    }

    @Override
    public void write(DataModel dataModel) {
        try {
            ++this.lineNumber;
            this.stream.writeInt(299792);
            this.nextColumn();
            this.stream.writeInt(dataModel.getRowCount());
            this.nextColumn();
            this.stream.writeInt(dataModel.getColumnCount());
            ++this.lineNumber;
            this.column = 0;
            while (this.column < dataModel.getColumnCount()) {
                this.writeColumnName(dataModel.getColumnName(this.column));
                if (this.column + 1 < dataModel.getColumnCount()) {
                    this.nextColumn();
                }
                ++this.column;
            }
            this.nextRow();
            ++this.lineNumber;
            this.column = 0;
            while (this.column < dataModel.getColumnCount()) {
                this.writeClass(dataModel.getColumnClass(this.column));
                if (this.column + 1 < dataModel.getColumnCount()) {
                    this.nextColumn();
                }
                ++this.column;
            }
            this.nextRow();
            this.row = 0;
            while (this.row < dataModel.getRowCount()) {
                ++this.lineNumber;
                this.column = 0;
                while (this.column < dataModel.getColumnCount()) {
                    if (dataModel.isAvailable(this.row, this.column)) {
                        this.writeValue(dataModel.getValueAt(this.row, this.column), dataModel.getColumnClass(this.column));
                    } else {
                        this.writeNotAvailable(dataModel.getColumnClass(this.column));
                    }
                    if (this.column + 1 < dataModel.getColumnCount()) {
                        this.nextColumn();
                    }
                    ++this.column;
                }
                this.nextRow();
                ++this.row;
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeColumnName(Object columnName) {
        try {
            this.stream.writeUTF(columnName.toString());
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeClass(Class cl) {
        try {
            if (cl == Byte.class) {
                this.stream.writeUTF("byte");
            } else if (cl == Character.class) {
                this.stream.writeUTF("char");
            } else if (cl == Double.class) {
                this.stream.writeUTF("double");
            } else if (cl == Float.class) {
                this.stream.writeUTF("float");
            } else if (cl == Integer.class) {
                this.stream.writeUTF("int");
            } else if (cl == Long.class) {
                this.stream.writeUTF("long");
            } else if (cl == Short.class) {
                this.stream.writeUTF("short");
            } else if (cl == Boolean.class) {
                this.stream.writeUTF("boolean");
            } else {
                String className = cl.getName();
                if (className.startsWith("java.lang.")) {
                    className = className.substring("java.lang.".length());
                }
                this.stream.writeUTF(className);
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeValue(Object value, Class cl) {
        try {
            if (cl == Byte.class) {
                this.stream.writeByte(((Byte)value).byteValue());
            } else if (cl == Character.class) {
                this.stream.writeChar(((Character)value).charValue());
            } else if (cl == Double.class) {
                this.stream.writeDouble((Double)value);
            } else if (cl == Float.class) {
                this.stream.writeFloat(((Float)value).floatValue());
            } else if (cl == Integer.class) {
                this.stream.writeInt((Integer)value);
            } else if (cl == Long.class) {
                this.stream.writeLong((Long)value);
            } else if (cl == Short.class) {
                this.stream.writeShort(((Short)value).shortValue());
            } else if (cl == Boolean.class) {
                this.stream.writeBoolean((Boolean)value);
            } else if (value == null) {
                this.writeNotAvailable(cl);
            } else {
                this.stream.writeUTF(value.toString());
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public void writeNotAvailable(Class cl) {
        try {
            if (cl == Byte.class) {
                this.stream.writeByte(127);
            } else if (cl == Character.class) {
                this.stream.writeChar(0);
            } else if (cl == Double.class) {
                this.stream.writeDouble(Double.NaN);
            } else if (cl == Float.class) {
                this.stream.writeFloat(Float.NaN);
            } else if (cl == Integer.class) {
                this.stream.writeInt(Integer.MAX_VALUE);
            } else if (cl == Long.class) {
                this.stream.writeLong(Long.MAX_VALUE);
            } else if (cl == Short.class) {
                this.stream.writeShort(Short.MAX_VALUE);
            } else if (cl == Boolean.class) {
                this.stream.writeBoolean(Boolean.FALSE);
            } else {
                this.stream.writeUTF("n.a.");
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void nextRow() {
    }

    @Override
    public void nextColumn() {
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }
}

