/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.persistence.jsonml;

import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.DefaultElements;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.Elements;
import com.macrofocus.persistence.jsonml.JSONMLAttribute;
import com.macrofocus.persistence.jsonml.JSONMLElements;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class JSONMLElement
implements Element {
    private final JSONObject jsonObject;

    public JSONMLElement(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public String getLocalName() {
        return this.jsonObject.getString("tagName");
    }

    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    public Attribute getAttribute(int index) {
        return this.getAttribute(this.getAttributes().get(index));
    }

    public Attribute getAttribute(String key) {
        if (this.jsonObject.has(key)) {
            return new JSONMLAttribute(this.jsonObject, key);
        }
        return null;
    }

    private List<String> getAttributes() {
        ArrayList<String> children = new ArrayList<String>();
        Iterator keys = this.jsonObject.keys();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (key.equals("tagName") || key.equals("childNodes")) continue;
            children.add((String)key);
        }
        return children;
    }

    public Elements getChildElements() {
        if (this.jsonObject.optJSONArray("childNodes") != null) {
            return new JSONMLElements(this.jsonObject.getJSONArray("childNodes"));
        }
        return new DefaultElements();
    }

    public String getAttributeValue(String key) {
        Attribute attribute = this.getAttribute(key);
        return attribute != null ? attribute.getValue() : null;
    }

    public void addAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    public void appendChild(Element element) {
        throw new UnsupportedOperationException();
    }
}

