/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.persistence.xml;

import com.macrofocus.persistence.Attribute;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.Elements;
import com.macrofocus.persistence.xml.TextWriter;
import com.macrofocus.persistence.xml.UnicodeWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public class XmlElementSerializer {
    private TextWriter escaper;

    public void write(OutputStream out, Element root) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        this.escaper = new UnicodeWriter(writer, "UTF-8");
        this.escaper.setIndent(4);
        this.escaper.setLineSeparator("\n");
        this.writeXMLDeclaration();
        this.writeChild(root);
        writer.flush();
    }

    private void writeChild(Element element) throws IOException {
        if (this.hasNonTextChildren(element)) {
            this.writeStartTag(element);
            Elements children = element.getChildElements();
            for (int i = 0; i < children.size(); ++i) {
                Element child = children.get(i);
                this.writeChild(child);
            }
            this.writeEndTag(element);
        } else {
            this.writeEmptyElementTag(element);
        }
    }

    private void writeEmptyElementTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('/');
        this.escaper.write('>');
    }

    private void writeStartTag(Element element) throws IOException {
        this.writeTagBeginning(element);
        this.escaper.write('>');
        this.escaper.incrementIndent();
    }

    private void writeEndTag(Element element) throws IOException {
        this.escaper.decrementIndent();
        if (this.escaper.getIndent() > 0 && !this.escaper.isPreserveSpace() && this.hasNonTextChildren(element)) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.write('/');
        this.escaper.writeName(element.getLocalName());
        this.escaper.write('>');
    }

    private boolean hasNonTextChildren(Element element) {
        return element.getChildElements().size() > 0;
    }

    private void writeTagBeginning(Element element) throws IOException {
        if (this.escaper.isIndenting() && !this.escaper.isPreserveSpace() && !this.escaper.justBroke()) {
            this.escaper.breakLine();
        }
        this.escaper.write('<');
        this.escaper.writeName(element.getLocalName());
        this.writeAttributes(element);
    }

    private void writeAttributes(Element element) throws IOException {
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            this.escaper.write(' ');
            this.write(attribute);
        }
    }

    private void write(Attribute attribute) throws IOException {
        this.escaper.writeName(attribute.getQualifiedName());
        this.escaper.write('=');
        this.escaper.write('\"');
        this.escaper.writeAttributeValue(attribute.getValue());
        this.escaper.write('\"');
    }

    private void writeXMLDeclaration() throws IOException {
        this.escaper.writeUncheckedMarkup("<?xml version=\"1.0\" encoding=\"");
        this.escaper.writeUncheckedMarkup(this.escaper.getEncoding());
        this.escaper.writeUncheckedMarkup("\"?>");
        this.escaper.breakLine();
    }
}

