/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole.biff.record;

import com.macrofocus.util.ole.OleInputStream;
import com.macrofocus.util.ole.biff.record.AbstractRecordModel;
import com.macrofocus.util.ole.biff.record.ArrayRecordModel;
import com.macrofocus.util.ole.biff.record.BlankRecordModel;
import com.macrofocus.util.ole.biff.record.BofRecordModel;
import com.macrofocus.util.ole.biff.record.BookpoolRecordModel;
import com.macrofocus.util.ole.biff.record.BoolerrRecordModel;
import com.macrofocus.util.ole.biff.record.BoundsheetRecordModel;
import com.macrofocus.util.ole.biff.record.ContinueRecordModel;
import com.macrofocus.util.ole.biff.record.DbcellRecordModel;
import com.macrofocus.util.ole.biff.record.EofRecordModel;
import com.macrofocus.util.ole.biff.record.ExtsstRecordModel;
import com.macrofocus.util.ole.biff.record.FormatRecordModel;
import com.macrofocus.util.ole.biff.record.FormulaRecordModel;
import com.macrofocus.util.ole.biff.record.IndexRecordModel;
import com.macrofocus.util.ole.biff.record.LabelRecordModel;
import com.macrofocus.util.ole.biff.record.LabelsstRecordModel;
import com.macrofocus.util.ole.biff.record.MulblankRecordModel;
import com.macrofocus.util.ole.biff.record.MulrkRecordModel;
import com.macrofocus.util.ole.biff.record.NumberRecordModel;
import com.macrofocus.util.ole.biff.record.PaletteRecordModel;
import com.macrofocus.util.ole.biff.record.RecordModel;
import com.macrofocus.util.ole.biff.record.RkRecordModel;
import com.macrofocus.util.ole.biff.record.RowRecordModel;
import com.macrofocus.util.ole.biff.record.RstringRecordModel;
import com.macrofocus.util.ole.biff.record.ShrfmlaRecordModel;
import com.macrofocus.util.ole.biff.record.SimpleRecordModel;
import com.macrofocus.util.ole.biff.record.SstRecordModel;
import com.macrofocus.util.ole.biff.record.StringRecordModel;
import com.macrofocus.util.ole.biff.record.StyleRecordModel;
import com.macrofocus.util.ole.biff.record.TxoRecordModel;
import com.macrofocus.util.ole.biff.record.XfRecordModel;

public class RecordFactory {
    private static final int ARRAY = 545;
    private static final int BLANK = 513;
    private static final int BOF = 2057;
    private static final int BOOKPOOL = 218;
    private static final int BOOLERR = 517;
    private static final int BOUNDSHEET = 133;
    private static final int CONTINUE = 60;
    private static final int DBCELL = 215;
    private static final int EOF = 10;
    private static final int EXTSST = 255;
    private static final int FORMAT = 1054;
    private static final int FORMULA = 1030;
    private static final int INDEX = 523;
    private static final int LABEL = 516;
    private static final int LABELSST = 253;
    private static final int MULBLANK = 190;
    private static final int MULRK = 189;
    private static final int NUMBER = 515;
    private static final int PALETTE = 146;
    private static final int RK = 126;
    private static final int ROW = 520;
    private static final int RSTRING = 214;
    private static final int SST = 252;
    private static final int SHRFMLA = 188;
    private static final int STRING = 519;
    private static final int STYLE = 659;
    private static final int TXO = 438;
    private static final int XF = 224;

    public static RecordModel createRecordModel(int type, int dataLength, OleInputStream streamModel) {
        AbstractRecordModel recordModel;
        switch (type) {
            case 545: {
                recordModel = new ArrayRecordModel(type, dataLength, streamModel);
                break;
            }
            case 513: {
                recordModel = new BlankRecordModel(type, dataLength, streamModel);
                break;
            }
            case 2057: {
                recordModel = new BofRecordModel(type, dataLength, streamModel);
                break;
            }
            case 218: {
                recordModel = new BookpoolRecordModel(type, dataLength, streamModel);
                break;
            }
            case 517: {
                recordModel = new BoolerrRecordModel(type, dataLength, streamModel);
                break;
            }
            case 133: {
                recordModel = new BoundsheetRecordModel(type, dataLength, streamModel);
                break;
            }
            case 60: {
                recordModel = new ContinueRecordModel(type, dataLength, streamModel);
                break;
            }
            case 215: {
                recordModel = new DbcellRecordModel(type, dataLength, streamModel);
                break;
            }
            case 10: {
                recordModel = new EofRecordModel(type, dataLength, streamModel);
                break;
            }
            case 255: {
                recordModel = new ExtsstRecordModel(type, dataLength, streamModel);
                break;
            }
            case 1054: {
                recordModel = new FormatRecordModel(type, dataLength, streamModel);
                break;
            }
            case 1030: {
                recordModel = new FormulaRecordModel(type, dataLength, streamModel);
                break;
            }
            case 523: {
                recordModel = new IndexRecordModel(type, dataLength, streamModel);
                break;
            }
            case 516: {
                recordModel = new LabelRecordModel(type, dataLength, streamModel);
                break;
            }
            case 253: {
                recordModel = new LabelsstRecordModel(type, dataLength, streamModel);
                break;
            }
            case 190: {
                recordModel = new MulblankRecordModel(type, dataLength, streamModel);
                break;
            }
            case 189: {
                recordModel = new MulrkRecordModel(type, dataLength, streamModel);
                break;
            }
            case 515: {
                recordModel = new NumberRecordModel(type, dataLength, streamModel);
                break;
            }
            case 146: {
                recordModel = new PaletteRecordModel(type, dataLength, streamModel);
                break;
            }
            case 126: {
                recordModel = new RkRecordModel(type, dataLength, streamModel);
                break;
            }
            case 520: {
                recordModel = new RowRecordModel(type, dataLength, streamModel);
                break;
            }
            case 214: {
                recordModel = new RstringRecordModel(type, dataLength, streamModel);
                break;
            }
            case 252: {
                recordModel = new SstRecordModel(type, dataLength, streamModel);
                break;
            }
            case 188: {
                recordModel = new ShrfmlaRecordModel(type, dataLength, streamModel);
                break;
            }
            case 519: {
                recordModel = new StringRecordModel(type, dataLength, streamModel);
                break;
            }
            case 659: {
                recordModel = new StyleRecordModel(type, dataLength, streamModel);
                break;
            }
            case 438: {
                recordModel = new TxoRecordModel(type, dataLength, streamModel);
                break;
            }
            case 224: {
                recordModel = new XfRecordModel(type, dataLength, streamModel);
                break;
            }
            default: {
                recordModel = new SimpleRecordModel(type, dataLength, streamModel);
            }
        }
        return recordModel;
    }
}

