/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ButtonPainter";
    protected static WeakHashMap<AbstractButton, Object> buttons = new WeakHashMap();

    protected ButtonPainter() {
    }

    public static ButtonPainter getInstance() {
        return ButtonPainter.getInstance(null);
    }

    public static ButtonPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ButtonPainter.getPainterClassName(sc, ButtonPainter.class, UI_KEY));
        if (instance == null) {
            instance = ButtonPainter.getInstance(sc, ButtonPainter.class, UI_KEY);
        }
        return (ButtonPainter)instance;
    }

    public void paintButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        AbstractButton button = (AbstractButton)sc.getComponent();
        if (!button.isContentAreaFilled()) {
            this.paintButtonBackground(sc, g, x, y, w, h);
        }
    }

    public void paintButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCheck(sc)) {
            return;
        }
        JComponent button = sc.getComponent();
        String segPos = (String)button.getClientProperty("JButton.segmentPosition");
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        this.paintButtonBackground(button, state, segPos, g, x, y, w, h);
    }

    public void paintButtonBackground(JComponent c, SyntheticaState state, String segmentPosition, Graphics g, int x, int y, int w, int h) {
        this.paintButtonBackground(c, state, segmentPosition, 0, g, x, y, w, h);
    }

    public void paintButtonBackground(JComponent c, SyntheticaState state, String segmentPosition, int angle, Graphics g, int x, int y, int w, int h) {
        UIKey k;
        Insets sInsets;
        if (!this.paintCheck(c, state)) {
            return;
        }
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            state = new SyntheticaState(state.getState());
            state.resetState(SyntheticaState.State.SELECTED);
            state.setState(SyntheticaState.State.PRESSED);
        }
        String suffix = this.createSuffix(segmentPosition);
        UIKey key = new UIKey("button.border" + suffix, state);
        int threshold = SyntheticaLookAndFeel.getInt("Synthetica.button.smallSizeThreshold", c, 12, true);
        if (w <= threshold || h <= threshold) {
            key = new UIKey("button.12x12.border", state);
            suffix = ".12x12";
        }
        Insets dInsets = sInsets = (Insets)UIKey.findProperty(c, key.get(), "insets", 2);
        if (this.isToolBarButton(c) && !SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", c)) {
            key = new UIKey("toolBar.button.border" + suffix, state);
            if (SyntheticaLookAndFeel.get(key.get(), c) == null) {
                key = new UIKey("toolBar.button.border", state);
            }
        } else if (this.isToolBarButtonBarButton(c) && SyntheticaLookAndFeel.get((k = new UIKey("toolBar.buttonBar.button.border" + suffix, state)).get(), c) != null) {
            key = k;
        }
        String imagePath = this.resolveImagePath(key.get(), c);
        if (c.hasFocus() && this.resolveImagePath(String.valueOf(key.get()) + ".focused", c) != null) {
            imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused", c);
        }
        key = new UIKey("button", state);
        if (imagePath != null && SyntheticaLookAndFeel.isOpaque(c)) {
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 2);
            if (state.isSet(SyntheticaState.State.DEFAULT)) {
                cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, -1);
                delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 70);
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 0);
            } else if (state.isSet(SyntheticaState.State.HOVER)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 1);
            }
            ImagePainter imagePainter = new ImagePainter(c, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.setAngle(angle);
            this.drawButton(imagePainter, c, state);
        }
        if ((c.hasFocus() || state.isSet(SyntheticaState.State.FOCUSED)) && ((AbstractButton)c).isFocusPainted()) {
            this.paintFocus(c, state, segmentPosition, angle, g, x, y, w, h);
        }
    }

    protected void drawButton(ImagePainter painter, JComponent c, SyntheticaState state) {
        painter.draw();
    }

    protected void paintFocus(JComponent c, SyntheticaState state, String segmentPosition, int angle, Graphics g, int x, int y, int w, int h) {
        String suffix = this.createSuffix(segmentPosition);
        int threshold = SyntheticaLookAndFeel.getInt("Synthetica.button.smallSizeThreshold", c, 12, true);
        if (w <= threshold || h <= threshold) {
            suffix = ".12x12";
        }
        String key = "focus.button" + suffix;
        if (this.isToolBarButton(c)) {
            key = String.valueOf(key) + ".toolBar";
        } else if (this.isToolBarButtonBarButton(c)) {
            key = String.valueOf(key) + ".buttonBar.toolBar";
        } else if (state.isSet(SyntheticaState.State.DEFAULT)) {
            key = String.valueOf(key) + ".default";
        }
        FocusPainter.paintFocus(key, c, state.getState(), null, angle, g, x, y, w, h);
    }

    private String createSuffix(String segmentPosition) {
        return segmentPosition == null || segmentPosition.length() == 0 ? "" : (segmentPosition.startsWith(".") ? segmentPosition : "." + segmentPosition);
    }

    protected boolean paintCheck(SynthContext sc) {
        return this.paintCheck(sc.getComponent(), new SyntheticaPainterState(sc));
    }

    protected boolean paintCheck(JComponent c, SyntheticaState state) {
        if (!(c instanceof AbstractButton)) {
            return false;
        }
        AbstractButton button = (AbstractButton)c;
        Container parent = button.getParent();
        if (parent != null) {
            if (parent instanceof BasicInternalFrameTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.buttons.paintBorder", button)) {
                return false;
            }
            if (parent instanceof SyntheticaTitlePane && !SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.titlePane.buttons.paintBorder", button)) {
                return false;
            }
            if (this.isToolBarButton(c)) {
                Insets bMargin;
                SynthStyle ss = SynthLookAndFeel.getStyle(c, Region.BUTTON);
                SynthContext sc = new SynthContext(c, Region.BUTTON, ss, 0);
                Insets defaultMargin = (Insets)sc.getStyle().get(sc, "Button.margin");
                Insets insets = bMargin = button.getMargin() == null ? new Insets(0, 0, 0, 0) : button.getMargin();
                if ((bMargin.equals(defaultMargin) || !buttons.containsKey(button) && (button.getText() == null || "".equals(button.getText().trim()))) && SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.button.marginCorrection.enabled", c, true) && bMargin.equals(defaultMargin)) {
                    button.setMargin(new Insets(bMargin.bottom - defaultMargin.bottom, bMargin.left - defaultMargin.left, bMargin.top - defaultMargin.top, bMargin.right - defaultMargin.right));
                }
                buttons.put(button, null);
                boolean paintBorder = SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.buttons.paintBorder", button);
                if (!(paintBorder || state.isSet(SyntheticaState.State.HOVER) || SyntheticaLookAndFeel.get("Synthetica.toolBar.button.border", button) != null || state.isSet(SyntheticaState.State.PRESSED) && SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.button.pressed.paintBorder", button))) {
                    return false;
                }
            }
        }
        return this.paintCheckContentBorder(button, state);
    }

    protected boolean paintCheckContentBorder(AbstractButton button, SyntheticaState state) {
        if (button.isBorderPainted() || button.getText() == null || button.getText().length() == 0) {
            if (!button.isBorderPainted() && !state.isSet(SyntheticaState.State.HOVER)) {
                return false;
            }
            return button.isContentAreaFilled();
        }
        return false;
    }

    private boolean isToolBarButton(JComponent button) {
        Boolean useToolBarStyle = (Boolean)button.getClientProperty("Synthetica.useToolBarStyle");
        return useToolBarStyle == null || useToolBarStyle != false ? button.getParent() instanceof JToolBar : false;
    }

    private boolean isToolBarButtonBarButton(JComponent button) {
        Container parent = button.getParent();
        return parent != null && parent.getParent() instanceof JToolBar && "ButtonBar".equals(SyntheticaLookAndFeel.getStyleName(parent));
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        AbstractButton b = (AbstractButton)sc.getComponent();
        if (b.getParent() instanceof JToolBar) {
            return -1;
        }
        String segPos = (String)b.getClientProperty("JButton.segmentPosition");
        Border border = b.getBorder();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        int n = hash = segPos == null ? hash : 31 * hash + segPos.hashCode();
        hash = border == null ? hash : 31 * hash + (b.isBorderPainted() ? 0 : 1);
        hash = 31 * hash + (b.isContentAreaFilled() ? 0 : 1);
        return hash;
    }
}

