/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.text.View;

public class RadioButtonPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.RadioButtonPainter";

    protected RadioButtonPainter() {
    }

    public static RadioButtonPainter getInstance() {
        return RadioButtonPainter.getInstance(null);
    }

    public static RadioButtonPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(RadioButtonPainter.getPainterClassName(sc, RadioButtonPainter.class, UI_KEY));
        if (instance == null) {
            instance = RadioButtonPainter.getInstance(sc, RadioButtonPainter.class, UI_KEY);
        }
        return (RadioButtonPainter)instance;
    }

    public void paintRadioButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        AbstractButton b = (AbstractButton)sc.getComponent();
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        if (SyntheticaLookAndFeel.get("Synthetica.radioButton.image", b) != null && b.getIcon() == null) {
            Insets sInsets;
            UIKey key = new UIKey("radioButton", state);
            Insets dInsets = sInsets = new Insets(0, 0, 0, 0);
            Insets insets = b.getInsets();
            String imagePath = this.resolveImagePath(key.get("image"), b);
            if (b.hasFocus() && this.resolveImagePath(String.valueOf(key.get()) + ".focused.image", b) != null) {
                imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused.image", b);
            }
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)b, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)b, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)b, 2);
            if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)b, 1);
            }
            Rectangle viewRect = new Rectangle(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            Rectangle textRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            Icon icon = sc.getStyle().getIcon(sc, "RadioButton.icon");
            sc.getStyle().getGraphicsUtils(sc).layoutText(sc, g.getFontMetrics(), b.getText(), icon, b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
            ImagePainter imagePainter = new ImagePainter((JComponent)b, cycles, delay, type, state.getState(), g, iconRect.x, iconRect.y, iconRect.width, iconRect.height, imagePath, sInsets, dInsets, 0, 0);
            if (!state.isSet(SyntheticaState.State.PRESSED) || b.getPressedIcon() == null) {
                imagePainter.drawCenter();
            }
            if (state.isSet(SyntheticaState.State.FOCUSED) && b.isFocusPainted() && SyntheticaLookAndFeel.get("Synthetica.radioButton.focus", b) != null) {
                String propertyKey = "focus.radioButton";
                String name = SyntheticaLookAndFeel.getStyleName(b);
                cycles = SyntheticaLookAndFeel.getInt(propertyKey, "animation.cycles", name, true, -1);
                delay = SyntheticaLookAndFeel.getInt(propertyKey, "animation.delay", name, true, 60);
                type = SyntheticaLookAndFeel.getInt(propertyKey, "animation.type", name, true, 3);
                imagePath = this.resolveImagePath("Synthetica.radioButton.focus", b);
                imagePainter = new ImagePainter(b, "", cycles, delay, type, state.getState(), g, iconRect.x, iconRect.y, iconRect.width, iconRect.height, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
            }
        }
        if (state.isSet(SyntheticaState.State.FOCUSED) && b.isFocusPainted()) {
            boolean isHtml;
            Icon icon = b.getIcon() == null ? sc.getStyle().getIcon(sc, "RadioButton.icon") : b.getIcon();
            String text = b.getText();
            int textGap = text == null || text.length() == 0 ? 0 : b.getIconTextGap();
            int w_ = b.getInsets().left + b.getInsets().right + textGap + (icon == null ? 0 : icon.getIconWidth());
            boolean bl = isHtml = b.getClientProperty("html") != null;
            if (!isHtml) {
                FontMetrics fm = b.getFontMetrics(sc.getStyle().getFont(sc));
                if (text != null) {
                    w_ += fm.stringWidth(text);
                }
            } else {
                w_ = (int)((float)w_ + ((View)b.getClientProperty("html")).getPreferredSpan(0));
            }
            FocusPainter.paintFocus("focus.radioButton", sc, g, x, y, w_, h);
        }
    }

    public void paintRadioButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JRadioButton rb = (JRadioButton)sc.getComponent();
        if (rb.isBorderPainted()) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.radioButton.border.insets", rb);
            String imagePath = this.resolveImagePath("Synthetica.radioButton.border", rb);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.drawBorder();
        }
    }
}

