/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaIconPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaSoftCache;
import de.javasoft.plaf.synthetica.util.OS;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaBasicIconPainter
extends SyntheticaIconPainter
implements Cacheable {
    private SynthContext sc;
    private int width;
    private int height;
    private static final boolean OS_X_QUARTZ_ENABLED = SyntheticaLookAndFeel.isSystemPropertySet("apple.awt.graphics.UseQuartz");

    public SyntheticaBasicIconPainter() {
        this(null, 16, 16);
    }

    public SyntheticaBasicIconPainter(SynthContext sc, int width, int height) {
        this.sc = sc;
        this.width = width;
        this.height = height;
    }

    protected float getScale() {
        return SyntheticaLookAndFeel.getInstance().getScaleFactor();
    }

    protected BasicStroke createStroke(SynthContext sc) {
        return new BasicStroke(1.0f);
    }

    @Override
    public int getIconHeight() {
        return (int)((float)this.height * this.getScale());
    }

    @Override
    public int getIconWidth() {
        return (int)((float)this.width * this.getScale());
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        SynthContext sc_ = this.sc;
        if (sc_ == null && c instanceof AbstractButton && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            AbstractButton b = (AbstractButton)c;
            SynthStyle ss = SyntheticaLookAndFeel.getStyle(b, Region.BUTTON);
            int state = 0;
            state |= b.getModel().isPressed() ? 4 : 0;
            state |= b.getModel().isSelected() ? 512 : 0;
            state |= !b.getModel().isEnabled() ? 8 : 0;
            sc_ = new SynthContext(b, Region.BUTTON, ss, state |= b.getModel().isRollover() ? 2 : 0);
        }
        this.paintIcon(sc_, g, x, y, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public void paintIcon(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h)) {
            this.paintIcon_(sc, g, x, y, w, h);
        }
    }

    private void paintIcon_(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        Object antialiasing_old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object strokeControl_old = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        AffineTransform at_old = g2.getTransform();
        Paint paint_old = g2.getPaint();
        Stroke stroke_old = g2.getStroke();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        BasicStroke stroke = this.createStroke(sc);
        g2.setStroke(stroke);
        AffineTransform at = new AffineTransform();
        if (OS.getCurrentOS() == OS.Mac && OS_X_QUARTZ_ENABLED) {
            at.translate((long)x + Math.round((double)(this.getScale() / 2.0f) - 0.5), (long)y + Math.round((double)(this.getScale() / 2.0f) - 0.5));
        } else {
            at.translate((float)x + this.getScale() / 2.0f, (float)y + this.getScale() / 2.0f);
        }
        at.scale(this.getScale(), this.getScale());
        g2.transform(at);
        this.paint2D(sc, (Graphics2D)g, x, y, this.width - 1, this.height - 1);
        g2.setStroke(stroke_old);
        g2.setPaint(paint_old);
        g2.setTransform(at_old);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing_old);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, strokeControl_old);
    }

    private boolean paintCachedImage(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        int hash = 0;
        if (sc == null || !UIManager.getBoolean("Synthetica.cache.enabled") || (hash = this.getCacheHash(sc, w, h, 0, "")) == -1 || !SyntheticaSoftCache.getInstance().isCacheable(w, h)) {
            return false;
        }
        VolatileImage buffer = this.getCachedImage(hash, sc, g, w, h);
        boolean cached = buffer == null ? false : g.drawImage(buffer, x, y, null);
        return cached;
    }

    private VolatileImage getCachedImage(int hash, SynthContext sc, Graphics g, int w, int h) {
        GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
        SyntheticaSoftCache imageCache = SyntheticaSoftCache.getInstance();
        VolatileImage image = (VolatileImage)imageCache.getImage(hash);
        do {
            int bufferStatus;
            int n = bufferStatus = image == null ? 2 : image.validate(gc);
            if (bufferStatus != 2 && bufferStatus != 1) continue;
            if (bufferStatus == 2 || image.getWidth() != w || image.getHeight() != h) {
                if (image != null) {
                    image.flush();
                    image = null;
                }
                image = gc.createCompatibleVolatileImage(w, h, 3);
                imageCache.setImage(image, hash);
            }
            Graphics2D g2 = image.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, w, h);
            g2.setComposite(AlphaComposite.SrcOver);
            this.paintIcon_(sc, g2, 0, 0, w, h);
            g2.dispose();
        } while (image.contentsLost());
        return image;
    }

    public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
    }

    protected Rectangle2D.Float calc2DBounds(Graphics2D g2, float w, float h) {
        float strokeWidth = ((BasicStroke)g2.getStroke()).getLineWidth();
        float xy = strokeWidth / 2.0f - 0.5f;
        return new Rectangle2D.Float(xy, xy, w - strokeWidth + 1.0f, h - strokeWidth + 1.0f);
    }

    protected static Shape subtractStroke(Graphics2D g2, Shape s) {
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.2D.subtractStrokeEnabled", null)) {
            return s;
        }
        Area strokeArea = new Area(((BasicStroke)g2.getStroke()).createStrokedShape(s));
        Area shapeArea = new Area(s);
        shapeArea.subtract(strokeArea);
        return shapeArea;
    }

    protected Color getSyntheticaBackgroundColor(JComponent c) {
        return SyntheticaComponentPainter.getSyntheticaBackgroundColor(c);
    }

    protected Synthetica2DUtils.BlendMode getSyntheticaBackgroundBlendMode(JComponent c) throws IllegalArgumentException {
        return SyntheticaComponentPainter.getSyntheticaBackgroundBlendMode(c);
    }

    protected Paint createLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        return SyntheticaLookAndFeel.createLinearGradientPaint(startX, startY, endX, endY, fractions, colors);
    }

    protected Color blend(Color col1, Color col2, Synthetica2DUtils.BlendMode blendMode) {
        return SyntheticaComponentPainter.blend(col1, col2, blendMode);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        int hash = id.hashCode();
        hash = 31 * hash + w;
        hash = 31 * hash + h;
        hash = 31 * hash + meta;
        hash = 31 * hash + (int)this.getScale() * 100;
        hash = 31 * hash + this.getClass().hashCode();
        if (sc != null) {
            JComponent c = sc.getComponent();
            String name = SyntheticaLookAndFeel.getStyleName(c);
            Color background = c.getBackground();
            Color sBackground = (Color)c.getClientProperty("Synthetica.background");
            Float alpha = (Float)c.getClientProperty("Synthetica.background.alpha");
            Window win = SwingUtilities.getWindowAncestor(c);
            hash = 31 * hash + c.getClass().hashCode();
            hash = 31 * hash + sc.getComponentState();
            hash = name == null ? hash : 31 * hash + name.hashCode();
            hash = background == null ? hash : hash * 31 + background.getRGB();
            hash = sBackground == null ? hash : hash * 31 + sBackground.getRGB();
            hash = alpha == null ? hash : hash * 31 + (int)(alpha.floatValue() * 100.0f);
            hash = 31 * hash + (win == null || win.isActive() ? 0 : 1);
        }
        return hash;
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NONE;
    }

    @Override
    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        int val = (int)(this.getScale() * 10.0f);
        return new Insets(val, val, val, val);
    }
}

