/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SyntheticaIconPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.ToolBarHandlePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ToolBarHandle
extends SyntheticaIconPainter {
    private SyntheticaState state = new SyntheticaState();

    @Override
    public int getIconHeight() {
        return SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", null, true);
    }

    @Override
    public int getIconWidth() {
        return SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", null, true);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int w;
        JToolBar toolBar = (JToolBar)c;
        int orientation = toolBar.getOrientation();
        boolean stateSupportEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.toolBar.handle.stateSupportEnabled", c);
        SynthContext sc = null;
        if (stateSupportEnabled) {
            SynthStyle ss = SynthLookAndFeel.getStyle(toolBar, Region.TOOL_BAR);
            sc = new SynthContext(toolBar, Region.TOOL_BAR, ss, 0);
            this.state = new SyntheticaPainterState(sc);
        }
        int h = w = SyntheticaLookAndFeel.getInt("Synthetica.toolBar.handle.size", c, true);
        if (w <= 0) {
            return;
        }
        Insets margin = null;
        if (orientation == 0) {
            margin = SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.horizontal", c, false, true);
            h = c.getHeight() - margin.top - margin.bottom;
        } else {
            x = c.getComponentOrientation().isLeftToRight() ? x : 0;
            margin = SyntheticaLookAndFeel.getInsets("Synthetica.toolBar.margin.vertical", c, false, true);
            w = c.getWidth() - margin.left - margin.right;
        }
        ToolBarHandlePainter.getInstance(sc).paintHandle(toolBar, this.state, orientation, g, x += margin.left, y += margin.top, w, h);
    }
}

