/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class UIKey {
    private StringBuilder sb;

    public UIKey(String componentKey, SyntheticaState state) {
        this(componentKey, state, -1, -1, -1);
    }

    public UIKey(String componentKey, SyntheticaState state, String prefix) {
        this(componentKey, state, -1, -1, -1, prefix);
    }

    UIKey(String componentKey, SyntheticaState state, int direction, int position, int orientation) {
        this(componentKey, state, direction, position, orientation, "Synthetica.");
    }

    UIKey(String componentKey, SyntheticaState state, int direction, int position, int orientation, String prefix) {
        this.sb = new StringBuilder(prefix);
        this.sb.append(componentKey);
        if (direction >= 0) {
            if (direction == 1) {
                this.sb.append(".up");
            } else if (direction == 5) {
                this.sb.append(".down");
            } else if (direction == 7) {
                this.sb.append(".left");
            } else if (direction == 3) {
                this.sb.append(".right");
            }
        } else if (position >= 0) {
            if (position == 1) {
                this.sb.append(".top");
            } else if (position == 2) {
                this.sb.append(".left");
            } else if (position == 3) {
                this.sb.append(".bottom");
            } else if (position == 4) {
                this.sb.append(".right");
            }
        } else if (orientation >= 0) {
            if (orientation == 0) {
                this.sb.append(".x");
            } else if (orientation == 1) {
                this.sb.append(".y");
            }
        }
        if (state.isSet(SyntheticaState.State.DEFAULT)) {
            this.sb.append(".default");
        }
        if (state.isSet(SyntheticaState.State.DISABLED) && state.isSet(SyntheticaState.State.PRESSED)) {
            this.sb.append(".disabled.pressed");
        } else if (state.isSet(SyntheticaState.State.DISABLED)) {
            this.sb.append(".disabled");
        } else if (state.isSet(SyntheticaState.State.PRESSED)) {
            this.sb.append(".pressed");
        } else if (state.isSet(SyntheticaState.State.HOVER)) {
            this.sb.append(".hover");
        }
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            this.sb.append(".selected");
        }
        if (state.isSet(SyntheticaState.State.LOCKED)) {
            this.sb.append(".locked");
        }
        if (state.isSet(SyntheticaState.State.ACTIVE)) {
            this.sb.append(".active");
        }
    }

    public String get() {
        return this.sb.toString();
    }

    public String get(String propertyName) {
        StringBuilder stringBuilder = new StringBuilder(this.sb.toString());
        stringBuilder.append(".");
        stringBuilder.append(propertyName);
        return stringBuilder.toString();
    }

    static Object findProperty(JComponent c, String keyPrefix, String propertyName, int maxFallbackDepth, boolean resolveImagePath) {
        char delimiter = '.';
        int i = keyPrefix.length();
        while (i > -1) {
            Object obj;
            keyPrefix = keyPrefix.substring(0, i);
            StringBuilder key = new StringBuilder(keyPrefix);
            if (propertyName != null) {
                key.append(delimiter);
                key.append(propertyName);
            }
            Object object = obj = resolveImagePath ? SyntheticaLookAndFeel.resolveImagePath(key.toString(), c) : SyntheticaLookAndFeel.get(key.toString(), c);
            if (obj != null || maxFallbackDepth <= 0) {
                return obj;
            }
            i = keyPrefix.lastIndexOf(delimiter);
            --maxFallbackDepth;
        }
        return null;
    }

    public static Object findProperty(JComponent c, String keyPrefix, String propertyName, int maxFallbackDepth) {
        return UIKey.findProperty(c, keyPrefix, propertyName, maxFallbackDepth, false);
    }

    static Object findProperty(SynthContext sc, String keyPrefix, String propertyName, int maxFallbackDepth) {
        return UIKey.findProperty(sc.getComponent(), keyPrefix, propertyName, maxFallbackDepth, false);
    }

    Object findProperty(SynthContext sc, String propertyName, int maxFallbackDepth) {
        return UIKey.findProperty(sc, this.get(), propertyName, maxFallbackDepth);
    }

    public static String resolveImagePath(JComponent c, String keyPrefix, String propertyName, int maxFallbackDepth) {
        return (String)UIKey.findProperty(c, keyPrefix, propertyName, maxFallbackDepth, true);
    }

    static String resolveImagePath(SynthContext sc, String keyPrefix, String propertyName, int maxFallbackDepth) {
        return UIKey.resolveImagePath(sc.getComponent(), keyPrefix, propertyName, maxFallbackDepth);
    }

    String resolveImagePath(SynthContext sc, int maxFallbackDepth) {
        return UIKey.resolveImagePath(sc, this.get(), null, maxFallbackDepth);
    }
}

