/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.igraphics.AbstractCPImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class SwingImage
extends AbstractCPImage<BufferedImage> {
    private BufferedImage image;
    private WritableRaster raster;

    public SwingImage(int width, int height) {
        this.image = new BufferedImage(width, height, 2);
        this.raster = this.image.getRaster();
    }

    private SwingImage(BufferedImage image) {
        this.image = image;
        this.raster = image.getRaster();
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray) {
        this.raster.setPixels(x, y, w, h, iArray);
    }

    public boolean isOneSamplePerArrayElement() {
        return true;
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.raster = null;
    }

    public BufferedImage getNativeImage() {
        return this.image;
    }

    public int[] getDirectIntBuffer() {
        DataBufferInt dataBuffer = (DataBufferInt)this.raster.getDataBuffer();
        return dataBuffer.getData();
    }
}

