/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import org.openexi.proc.common.EXIOptions;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.EventType;
import org.openexi.proc.common.GrammarOptions;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.StringTable;
import org.openexi.proc.events.EXIEventNS;
import org.openexi.proc.events.EXIEventSchemaNil;
import org.openexi.proc.events.EXIEventSchemaType;
import org.openexi.proc.grammars.Apparatus;
import org.openexi.proc.grammars.Grammar;
import org.openexi.proc.grammars.GrammarCache;
import org.openexi.proc.grammars.GrammarState;
import org.openexi.proc.grammars.ValueApparatus;
import org.openexi.proc.io.Base64BinaryValueScanner;
import org.openexi.proc.io.BuiltinRCS;
import org.openexi.proc.io.CharacterBuffer;
import org.openexi.proc.io.DateTimeValueScannerBase;
import org.openexi.proc.io.HexBinaryValueScanner;
import org.openexi.proc.io.OctetBuffer;
import org.openexi.proc.io.PrefixUriBindings;
import org.openexi.proc.io.StringValueScanner;
import org.openexi.proc.io.ValueScanner;
import org.openexi.proc.io.ValueScannerBase;
import org.openexi.proc.io.ValueScannerLexical;
import org.openexi.schema.Characters;
import org.openexi.schema.EXISchema;

public abstract class Scanner
extends Apparatus {
    private short m_grammarOptions = 0;
    protected boolean m_preserveNS = false;
    protected final QName qname;
    protected final int[] m_nameLocusStack;
    protected int m_nameLocusLastDepth;
    protected final PrefixUriBindings[] m_prefixUriBindingsLocusStack;
    protected int m_prefixUriBindingsLocusLastDepth;
    private PrefixUriBindings m_prefixUriBindingsDefault;
    protected PrefixUriBindings m_prefixUriBindings;
    private final ValueApparatus[] m_valueScanners;
    protected final ValueScanner[] m_valueScannerTable;
    protected final StringValueScanner m_stringValueScannerInherent;
    protected final ValueScanner m_booleanValueScannerInherent;
    protected final ValueScanner m_enumerationValueScannerInherent;
    protected final ValueScanner m_listValueScannerInherent;
    protected final ValueScanner m_decimalValueScannerInherent;
    private final ValueScanner m_dateTimeValueScannerInherent;
    private final ValueScanner m_timeValueScannerInherent;
    private final ValueScanner m_dateValueScannerInherent;
    private final ValueScanner m_gYearMonthValueScannerInherent;
    private final ValueScanner m_gYearValueScannerInherent;
    private final ValueScanner m_gMonthDayValueScannerInherent;
    private final ValueScanner m_gDayValueScannerInherent;
    private final ValueScanner m_gMonthValueScannerInherent;
    protected final ValueScanner m_floatValueScannerInherent;
    private final IntegerValueScanner m_integerValueScannerInherent;
    protected final ValueScanner m_base64BinaryValueScannerInherent;
    protected final ValueScanner m_hexBinaryValueScannerInherent;
    protected final ValueScanner m_stringValueScannerLexical;
    protected final ValueScanner m_booleanValueScannerLexical;
    protected final ValueScanner m_enumerationValueScannerLexical;
    protected final ValueScanner m_listValueScannerLexical;
    protected final ValueScanner m_decimalValueScannerLexical;
    private final ValueScanner m_dateTimeValueScannerLexical;
    private final ValueScanner m_timeValueScannerLexical;
    private final ValueScanner m_dateValueScannerLexical;
    private final ValueScanner m_gYearMonthValueScannerLexical;
    private final ValueScanner m_gYearValueScannerLexical;
    private final ValueScanner m_gMonthDayValueScannerLexical;
    private final ValueScanner m_gDayValueScannerLexical;
    private final ValueScanner m_gMonthValueScannerLexical;
    protected final ValueScanner m_floatValueScannerLexical;
    protected final ValueScanner m_integerValueScannerLexical;
    protected final ValueScanner m_base64BinaryValueScannerLexical;
    protected final ValueScanner m_hexBinaryValueScannerLexical;
    private EXIOptions m_exiHeaderOptions;
    protected boolean m_binaryDataEnabled;
    protected int m_binaryChunkSize;
    protected InputStream m_inputStream;
    private static final Characters TRUE = new Characters("true".toCharArray(), 0, "true".length(), false);
    private static final Characters FALSE = new Characters("false".toCharArray(), 0, "false".length(), false);
    private static final Characters ZERO = new Characters("0".toCharArray(), 0, "0".length(), false);
    private static final Characters ONE = new Characters("1".toCharArray(), 0, "1".length(), false);
    protected final CharacterBuffer m_characterBuffer;
    protected final OctetBuffer octetBuffer;

    public static StringTable createStringTable(GrammarCache grammarCache) {
        return new StringTable(grammarCache, StringTable.Usage.decoding);
    }

    protected Scanner(boolean bl) {
        this.m_preserveLexicalValues = false;
        this.qname = new QName();
        this.m_nameLocusStack = new int[128];
        this.m_nameLocusLastDepth = -2;
        this.m_prefixUriBindingsLocusStack = new PrefixUriBindings[64];
        this.m_prefixUriBindingsLocusLastDepth = -1;
        this.m_prefixUriBindingsDefault = bl ? null : new PrefixUriBindings();
        this.m_prefixUriBindings = null;
        this.m_characterBuffer = new CharacterBuffer(true);
        this.m_binaryDataEnabled = false;
        this.m_binaryChunkSize = -1;
        ArrayList<ValueScannerBase> arrayList = new ArrayList<ValueScannerBase>();
        this.m_stringValueScannerInherent = new StringValueScanner(this);
        arrayList.add(this.m_stringValueScannerInherent);
        this.m_booleanValueScannerInherent = new BooleanValueScanner();
        arrayList.add((ValueScannerBase)this.m_booleanValueScannerInherent);
        this.m_integerValueScannerInherent = new IntegerValueScanner();
        arrayList.add(this.m_integerValueScannerInherent);
        if (!bl) {
            this.octetBuffer = new OctetBuffer();
            this.m_stringValueScannerLexical = new ValueScannerLexical(this.m_stringValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_booleanValueScannerLexical = new ValueScannerLexical(this.m_booleanValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_integerValueScannerLexical = new ValueScannerLexical(this.m_integerValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_dateTimeValueScannerInherent = new DateTimeValueScanner();
            arrayList.add((ValueScannerBase)this.m_dateTimeValueScannerInherent);
            this.m_dateTimeValueScannerLexical = new ValueScannerLexical(this.m_dateTimeValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_timeValueScannerInherent = new TimeValueScanner();
            arrayList.add((ValueScannerBase)this.m_timeValueScannerInherent);
            this.m_timeValueScannerLexical = new ValueScannerLexical(this.m_timeValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_dateValueScannerInherent = new DateValueScanner();
            arrayList.add((ValueScannerBase)this.m_dateValueScannerInherent);
            this.m_dateValueScannerLexical = new ValueScannerLexical(this.m_dateValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_gYearMonthValueScannerInherent = new GYearMonthValueScanner();
            arrayList.add((ValueScannerBase)this.m_gYearMonthValueScannerInherent);
            this.m_gYearMonthValueScannerLexical = new ValueScannerLexical(this.m_gYearMonthValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_gYearValueScannerInherent = new GYearValueScanner();
            arrayList.add((ValueScannerBase)this.m_gYearValueScannerInherent);
            this.m_gYearValueScannerLexical = new ValueScannerLexical(this.m_gYearValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_gMonthDayValueScannerInherent = new GMonthDayValueScanner();
            arrayList.add((ValueScannerBase)this.m_gMonthDayValueScannerInherent);
            this.m_gMonthDayValueScannerLexical = new ValueScannerLexical(this.m_gMonthDayValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_gDayValueScannerInherent = new GDayValueScanner();
            arrayList.add((ValueScannerBase)this.m_gDayValueScannerInherent);
            this.m_gDayValueScannerLexical = new ValueScannerLexical(this.m_gDayValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_gMonthValueScannerInherent = new GMonthValueScanner();
            arrayList.add((ValueScannerBase)this.m_gMonthValueScannerInherent);
            this.m_gMonthValueScannerLexical = new ValueScannerLexical(this.m_gMonthValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_base64BinaryValueScannerInherent = new Base64BinaryValueScanner(this);
            arrayList.add((ValueScannerBase)this.m_base64BinaryValueScannerInherent);
            this.m_base64BinaryValueScannerLexical = new ValueScannerLexical(this.m_base64BinaryValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_hexBinaryValueScannerInherent = new HexBinaryValueScanner(this);
            arrayList.add((ValueScannerBase)this.m_hexBinaryValueScannerInherent);
            this.m_hexBinaryValueScannerLexical = new ValueScannerLexical(this.m_hexBinaryValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_floatValueScannerInherent = new FloatValueScanner();
            arrayList.add((ValueScannerBase)this.m_floatValueScannerInherent);
            this.m_floatValueScannerLexical = new ValueScannerLexical(this.m_floatValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_listValueScannerInherent = new ListValueScanner();
            arrayList.add((ValueScannerBase)this.m_listValueScannerInherent);
            this.m_listValueScannerLexical = new ValueScannerLexical(this.m_listValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_decimalValueScannerInherent = new DecimalValueScanner();
            arrayList.add((ValueScannerBase)this.m_decimalValueScannerInherent);
            this.m_decimalValueScannerLexical = new ValueScannerLexical(this.m_decimalValueScannerInherent, this.m_stringValueScannerInherent);
            this.m_enumerationValueScannerInherent = new EnumerationValueScanner();
            arrayList.add((ValueScannerBase)this.m_enumerationValueScannerInherent);
            this.m_enumerationValueScannerLexical = new ValueScannerLexical(this.m_enumerationValueScannerInherent, this.m_stringValueScannerInherent);
        } else {
            this.octetBuffer = null;
            this.m_stringValueScannerLexical = null;
            this.m_booleanValueScannerLexical = null;
            this.m_integerValueScannerLexical = null;
            this.m_dateTimeValueScannerLexical = null;
            this.m_dateTimeValueScannerInherent = null;
            this.m_timeValueScannerLexical = null;
            this.m_timeValueScannerInherent = null;
            this.m_dateValueScannerLexical = null;
            this.m_dateValueScannerInherent = null;
            this.m_gYearMonthValueScannerLexical = null;
            this.m_gYearMonthValueScannerInherent = null;
            this.m_gYearValueScannerLexical = null;
            this.m_gYearValueScannerInherent = null;
            this.m_gMonthDayValueScannerLexical = null;
            this.m_gMonthDayValueScannerInherent = null;
            this.m_gDayValueScannerLexical = null;
            this.m_gDayValueScannerInherent = null;
            this.m_gMonthValueScannerLexical = null;
            this.m_gMonthValueScannerInherent = null;
            this.m_base64BinaryValueScannerLexical = null;
            this.m_base64BinaryValueScannerInherent = null;
            this.m_hexBinaryValueScannerLexical = null;
            this.m_hexBinaryValueScannerInherent = null;
            this.m_floatValueScannerLexical = null;
            this.m_floatValueScannerInherent = null;
            this.m_listValueScannerLexical = null;
            this.m_listValueScannerInherent = null;
            this.m_decimalValueScannerLexical = null;
            this.m_decimalValueScannerInherent = null;
            this.m_enumerationValueScannerLexical = null;
            this.m_enumerationValueScannerInherent = null;
        }
        this.m_valueScanners = new ValueScanner[arrayList.size()];
        for (int i = 0; i < this.m_valueScanners.length; ++i) {
            this.m_valueScanners[i] = (ValueApparatus)arrayList.get(i);
        }
        this.m_valueScannerTable = new ValueScanner[18];
        this.m_valueScannerTable[1] = this.m_base64BinaryValueScannerInherent;
        this.m_valueScannerTable[2] = this.m_hexBinaryValueScannerInherent;
        this.m_valueScannerTable[3] = this.m_booleanValueScannerInherent;
        this.m_valueScannerTable[4] = this.m_dateTimeValueScannerInherent;
        this.m_valueScannerTable[5] = this.m_timeValueScannerInherent;
        this.m_valueScannerTable[6] = this.m_dateValueScannerInherent;
        this.m_valueScannerTable[7] = this.m_gYearMonthValueScannerInherent;
        this.m_valueScannerTable[8] = this.m_gYearValueScannerInherent;
        this.m_valueScannerTable[9] = this.m_gMonthDayValueScannerInherent;
        this.m_valueScannerTable[10] = this.m_gDayValueScannerInherent;
        this.m_valueScannerTable[11] = this.m_gMonthValueScannerInherent;
        this.m_valueScannerTable[12] = this.m_decimalValueScannerInherent;
        this.m_valueScannerTable[13] = this.m_floatValueScannerInherent;
        this.m_valueScannerTable[14] = this.m_integerValueScannerInherent;
        this.m_valueScannerTable[15] = this.m_stringValueScannerInherent;
        this.m_valueScannerTable[16] = this.m_listValueScannerInherent;
        this.m_valueScannerTable[17] = this.m_enumerationValueScannerInherent;
    }

    protected void init(int n) {
    }

    private void initValueScanners(InputStream inputStream) {
        for (int i = 0; i < 18; ++i) {
            ValueScanner valueScanner = this.m_valueScannerTable[i];
            if (valueScanner == null) continue;
            valueScanner.setInputStream(inputStream);
        }
    }

    public void reset() {
        super.reset();
        this.m_nameLocusLastDepth = -2;
        this.m_prefixUriBindingsLocusLastDepth = -1;
        this.m_prefixUriBindings = null;
    }

    public void setSchema(EXISchema eXISchema, QName[] qNameArray, int n) {
        super.setSchema(eXISchema, qNameArray, n);
        this.m_integerValueScannerInherent.setSchema(eXISchema);
    }

    public abstract EventDescription nextEvent() throws IOException;

    protected ValueApparatus[] getValueApparatuses() {
        return this.m_valueScanners;
    }

    public void prepare() throws IOException {
        if (this.m_preserveNS) {
            this.m_prefixUriBindings = this.m_prefixUriBindingsDefault;
        }
    }

    public void setInputStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
        this.initValueScanners(inputStream);
    }

    public void closeInputStream() throws IOException {
        this.m_inputStream.close();
    }

    public final void setGrammar(Grammar grammar, short s) {
        grammar.init(this.currentState);
        this.m_grammarOptions = s;
        this.m_preserveNS = GrammarOptions.hasNS(this.m_grammarOptions);
    }

    public final void setStringTable(StringTable stringTable) {
        super.setStringTable(stringTable);
        this.m_stringValueScannerInherent.setStringTable(stringTable);
    }

    public final void setPreserveLexicalValues(boolean bl) {
        boolean bl2 = this.m_preserveLexicalValues;
        super.setPreserveLexicalValues(bl);
        if (bl2 != bl) {
            if (bl) {
                this.m_valueScannerTable[1] = this.m_base64BinaryValueScannerLexical;
                this.m_valueScannerTable[2] = this.m_hexBinaryValueScannerLexical;
                this.m_valueScannerTable[3] = this.m_booleanValueScannerLexical;
                this.m_valueScannerTable[4] = this.m_dateTimeValueScannerLexical;
                this.m_valueScannerTable[5] = this.m_timeValueScannerLexical;
                this.m_valueScannerTable[6] = this.m_dateValueScannerLexical;
                this.m_valueScannerTable[7] = this.m_gYearMonthValueScannerLexical;
                this.m_valueScannerTable[8] = this.m_gYearValueScannerLexical;
                this.m_valueScannerTable[9] = this.m_gMonthDayValueScannerLexical;
                this.m_valueScannerTable[10] = this.m_gDayValueScannerLexical;
                this.m_valueScannerTable[11] = this.m_gMonthValueScannerLexical;
                this.m_valueScannerTable[12] = this.m_decimalValueScannerLexical;
                this.m_valueScannerTable[13] = this.m_floatValueScannerLexical;
                this.m_valueScannerTable[14] = this.m_integerValueScannerLexical;
                this.m_valueScannerTable[15] = this.m_stringValueScannerLexical;
                this.m_valueScannerTable[16] = this.m_listValueScannerLexical;
                this.m_valueScannerTable[17] = this.m_enumerationValueScannerLexical;
            } else {
                this.m_valueScannerTable[1] = this.m_base64BinaryValueScannerInherent;
                this.m_valueScannerTable[2] = this.m_hexBinaryValueScannerInherent;
                this.m_valueScannerTable[3] = this.m_booleanValueScannerInherent;
                this.m_valueScannerTable[4] = this.m_dateTimeValueScannerInherent;
                this.m_valueScannerTable[5] = this.m_timeValueScannerInherent;
                this.m_valueScannerTable[6] = this.m_dateValueScannerInherent;
                this.m_valueScannerTable[7] = this.m_gYearMonthValueScannerInherent;
                this.m_valueScannerTable[8] = this.m_gYearValueScannerInherent;
                this.m_valueScannerTable[9] = this.m_gMonthDayValueScannerInherent;
                this.m_valueScannerTable[10] = this.m_gDayValueScannerInherent;
                this.m_valueScannerTable[11] = this.m_gMonthValueScannerInherent;
                this.m_valueScannerTable[12] = this.m_decimalValueScannerInherent;
                this.m_valueScannerTable[13] = this.m_floatValueScannerInherent;
                this.m_valueScannerTable[14] = this.m_integerValueScannerInherent;
                this.m_valueScannerTable[15] = this.m_stringValueScannerInherent;
                this.m_valueScannerTable[16] = this.m_listValueScannerInherent;
                this.m_valueScannerTable[17] = this.m_enumerationValueScannerInherent;
            }
        }
    }

    public abstract void setBlockSize(int var1);

    public final void setValueMaxLength(int n) {
        this.m_stringValueScannerInherent.setValueMaxLength(n != -1 ? n : Integer.MAX_VALUE);
    }

    public final void setHeaderOptions(EXIOptions eXIOptions) {
        this.m_exiHeaderOptions = eXIOptions;
    }

    public final EXIOptions getHeaderOptions() {
        return this.m_exiHeaderOptions;
    }

    public final GrammarState getGrammarState() {
        switch (this.getAlignmentType()) {
            case bitPacked: 
            case byteAligned: {
                return this.currentState;
            }
        }
        assert (false);
        return null;
    }

    public final boolean getPreserveNS() {
        return this.m_preserveNS;
    }

    public final void setEnableBinaryData(boolean bl, int n) {
        this.m_binaryDataEnabled = bl;
        if (this.m_binaryDataEnabled) {
            this.octetBuffer.init(n);
        }
    }

    public abstract void setBinaryChunkSize(int var1);

    public final ValueScanner getValueScanner(int n) {
        if (n != -1) {
            int n2 = this.m_types[n + 2];
            return this.m_valueScannerTable[this.m_codecTable[n2]];
        }
        return this.m_valueScannerTable[15];
    }

    protected final EXIEventNS readNS(EventType eventType) throws IOException {
        int n = this.readURI();
        String string = this.stringTable.getURI(n);
        String string2 = this.readPrefixOfNS(n);
        boolean bl = this.readBoolean(this.m_inputStream);
        if (this.m_preserveNS) {
            this.m_prefixUriBindings = string2.length() != 0 ? this.m_prefixUriBindings.bind(string2, string) : this.m_prefixUriBindings.bindDefault(string);
            this.m_prefixUriBindingsLocusStack[this.m_prefixUriBindingsLocusLastDepth] = this.m_prefixUriBindings;
        }
        return new EXIEventNS(string2, string, bl, eventType);
    }

    protected final Characters readText() throws IOException {
        int n = this.readUnsignedInteger(this.m_inputStream);
        return this.readLiteralString(n, -1, this.m_inputStream);
    }

    protected final EXIEventSchemaNil readXsiNilValue(String string, EventType eventType) throws IOException {
        if (this.m_preserveLexicalValues) {
            boolean bl;
            int n;
            int n2;
            Characters characters = this.m_valueScannerTable[15].scan(0, 2, -1);
            int n3 = characters.length;
            int n4 = characters.startIndex;
            int n5 = n4 + n3 - 1;
            char[] cArray = characters.characters;
            block11: for (n2 = n5; n2 > 0; --n2) {
                switch (cArray[n2]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block11;
                    }
                }
            }
            ++n2;
            block12: for (n = n4; n < n3; ++n) {
                switch (cArray[n]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block12;
                    }
                }
            }
            if (n != n4 || n2 != n5) {
                n3 = n2 - n;
            }
            switch (n3) {
                case 4: {
                    assert (cArray[n] == 't' && cArray[n + 1] == 'r' && cArray[n + 2] == 'u' && cArray[n + 3] == 'e');
                    bl = true;
                    break;
                }
                case 5: {
                    assert (cArray[n] == 'f' && cArray[n + 1] == 'a' && cArray[n + 2] == 'l' && cArray[n + 3] == 's' && cArray[n + 4] == 'e');
                    bl = false;
                    break;
                }
                case 1: {
                    assert (cArray[n] == '0' || cArray[n] == '1');
                    bl = cArray[n] == '1';
                    break;
                }
                default: {
                    assert (false);
                    bl = false;
                }
            }
            return new EXIEventSchemaNil(bl, characters, string, eventType);
        }
        boolean bl = this.readBoolean(this.m_inputStream);
        return new EXIEventSchemaNil(bl, null, string, eventType);
    }

    protected final EXIEventSchemaType readXsiTypeValue(String string, EventType eventType) throws IOException {
        String string2;
        String string3;
        String string4;
        int n;
        Characters characters;
        if (this.m_preserveLexicalValues) {
            characters = this.m_valueScannerTable[15].scan(1, 2, -1);
            n = characters.indexOf(':');
            if (n != -1) {
                int n2;
                int n3 = characters.startIndex;
                char[] cArray = characters.characters;
                block6: for (n2 = n3 + characters.length - 1; n2 > 0; --n2) {
                    switch (cArray[n2]) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block6;
                        }
                    }
                }
                string4 = characters.substring(n + 1, n2 + 1);
                block7: for (n2 = n3; n2 < n; ++n2) {
                    switch (cArray[n2]) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block7;
                        }
                    }
                }
                string3 = characters.substring(n2, n);
                string2 = this.m_preserveNS ? this.m_prefixUriBindings.getUri(string3) : null;
            } else {
                string4 = characters.makeString();
                string3 = "";
                string2 = this.m_preserveNS ? this.m_prefixUriBindings.getDefaultUri() : null;
            }
        } else {
            n = this.readURI();
            string2 = this.stringTable.getURI(n);
            StringTable.LocalNamePartition localNamePartition = this.stringTable.getLocalNamePartition(n);
            int n4 = this.readLocalName(localNamePartition);
            string4 = localNamePartition.localNameEntries[n4].localName;
            string3 = this.m_preserveNS ? this.readPrefixOfQName(n) : null;
            characters = null;
        }
        n = -1;
        if (string2 != null && this.schema != null && (n = this.schema.getTypeOfSchema(string2, string4)) != -1) {
            this.xsitp(n);
        }
        return new EXIEventSchemaType(n, string2, string4, string3, characters, string, eventType);
    }

    protected final String readPrefixOfNS(int n) throws IOException {
        String string;
        StringTable.PrefixPartition prefixPartition = this.stringTable.getPrefixPartition(n);
        int n2 = prefixPartition.forwardedWidth;
        int n3 = this.readNBitUnsigned(n2, this.m_inputStream);
        if (n3 != 0) {
            string = prefixPartition.prefixEntries[n3 - 1].value;
        } else {
            int n4 = this.readUnsignedInteger(this.m_inputStream);
            string = this.readLiteralString(n4, -1, this.m_inputStream).makeString();
            prefixPartition.addPrefix(string);
        }
        return string;
    }

    protected final int readURI() throws IOException {
        int n;
        int n2 = this.stringTable.uriWidth;
        int n3 = this.readNBitUnsigned(n2, this.m_inputStream);
        if (n3 != 0) {
            n = n3 - 1;
        } else {
            int n4 = this.readUnsignedInteger(this.m_inputStream);
            String string = this.readLiteralString(n4, -1, this.m_inputStream).makeString();
            n = this.stringTable.addURI(string, null, null);
        }
        return n;
    }

    protected final int readLocalName(StringTable.LocalNamePartition localNamePartition) throws IOException {
        int n = this.readUnsignedInteger(this.m_inputStream);
        if (n != 0) {
            String string = this.readLiteralString(n - 1, -1, this.m_inputStream).makeString();
            return localNamePartition.addName(string, null);
        }
        return this.readNBitUnsigned(localNamePartition.width, this.m_inputStream);
    }

    protected final String readPrefixOfQName(int n) throws IOException {
        StringTable.PrefixPartition prefixPartition = this.stringTable.getPrefixPartition(n);
        int n2 = prefixPartition.width;
        int n3 = this.readNBitUnsigned(n2, this.m_inputStream);
        return n3 < prefixPartition.n_strings ? prefixPartition.prefixEntries[n3].value : null;
    }

    protected abstract boolean readBoolean(InputStream var1) throws IOException;

    protected final int readUnsignedInteger(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (((n = this.readEightBitsUnsigned(inputStream)) & 0x80) != 0) {
            n3 |= (n & 0x7F) << n2;
            n2 += 7;
        }
        return n3 | n << n2;
    }

    protected final long readUnsignedIntegerAsLong(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        long l = 0L;
        while (((n = this.readEightBitsUnsigned(inputStream)) & 0x80) != 0) {
            l |= ((long)n & 0x7FL) << n2;
            n2 += 7;
        }
        return l | (long)n << n2;
    }

    protected final int readUnsignedIntegerChars(InputStream inputStream, boolean bl, char[] cArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = bl ? 1 : 0;
        int n4 = 0;
        boolean bl2 = true;
        do {
            if (((n = this.readEightBitsUnsigned(inputStream)) & 0x80) != 0) {
                n &= 0x7F;
            } else {
                bl2 = false;
            }
            n3 += n << n2;
            if (bl2) continue;
            do {
                cArray[n4++] = (char)(48 + n3 % 10);
            } while ((n3 /= 10) != 0);
            return n4;
        } while ((n2 += 7) != 28);
        n = bl ? 56 : 63;
        long l = n3;
        do {
            long l2;
            if (((l2 = (long)this.readEightBitsUnsigned(inputStream)) & 0x80L) != 0L) {
                l2 &= 0x7FL;
            } else {
                bl2 = false;
            }
            l += l2 << n2;
            if (bl2) continue;
            while (l != 0L) {
                cArray[n4++] = (char)(48 + (int)(l % 10L));
                l /= 10L;
            }
            return n4;
        } while ((n2 += 7) != n);
        BigInteger bigInteger = BigInteger.valueOf(l);
        do {
            int n5;
            if (((n5 = this.readEightBitsUnsigned(inputStream)) & 0x80) != 0) {
                n5 &= 0x7F;
            } else {
                bl2 = false;
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(n5).shiftLeft(n2));
            n2 += 7;
        } while (bl2);
        String string = bigInteger.toString();
        int n6 = string.length();
        int n7 = n6;
        for (int i = 0; i < n6; ++i) {
            cArray[n4++] = string.charAt(--n7);
        }
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    protected final Characters readLiteralString(int var1_1, int var2_2, InputStream var3_3) throws IOException {
        if (var2_2 >= 0) {
            var8_4 = this.m_types[var2_2 + 2];
            v0 = var4_6 = this.schema.ancestryIds[var8_4] == 2 ? this.m_restrictedCharacterCountTable[var8_4] : 0;
            if (var4_6 != 0) {
                var7_7 = this.m_types;
                var5_8 = this.schema.getRestrictedCharacterOfSimpleType(var2_2);
                var6_9 = BuiltinRCS.WIDTHS[var4_6];
            } else {
                var6_9 = -1;
                var5_8 = -1;
                var7_7 = null;
            }
        } else if (var2_2 != -1) {
            var5_8 = 0;
            switch (var2_2) {
                case -2: {
                    var7_7 = BuiltinRCS.RCS_BASE64BINARY;
                    var6_9 = BuiltinRCS.RCS_BASE64BINARY_WIDTH;
                    break;
                }
                case -3: {
                    var7_7 = BuiltinRCS.RCS_HEXBINARY;
                    var6_9 = BuiltinRCS.RCS_HEXBINARY_WIDTH;
                    break;
                }
                case -4: {
                    var7_7 = BuiltinRCS.RCS_BOOLEAN;
                    var6_9 = BuiltinRCS.RCS_BOOLEAN_WIDTH;
                    break;
                }
                case -5: {
                    var7_7 = BuiltinRCS.RCS_DATETIME;
                    var6_9 = BuiltinRCS.RCS_DATETIME_WIDTH;
                    break;
                }
                case -6: {
                    var7_7 = BuiltinRCS.RCS_DECIMAL;
                    var6_9 = BuiltinRCS.RCS_DECIMAL_WIDTH;
                    break;
                }
                case -7: {
                    var7_7 = BuiltinRCS.RCS_DOUBLE;
                    var6_9 = BuiltinRCS.RCS_DOUBLE_WIDTH;
                    break;
                }
                case -8: {
                    var7_7 = BuiltinRCS.RCS_INTEGER;
                    var6_9 = BuiltinRCS.RCS_INTEGER_WIDTH;
                    break;
                }
                default: {
                    if (!Scanner.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    var6_9 = -1;
                    var7_7 = null;
                }
            }
            var4_6 = var7_7.length;
        } else {
            var6_9 = -1;
            var5_8 = -1;
            var4_6 = -1;
            var7_7 = null;
        }
        this.m_characterBuffer.ensureCharacters(var1_1);
        var8_5 = this.m_characterBuffer.characters;
        var9_10 = this.m_characterBuffer.allocCharacters(var1_1);
        var10_11 = var1_1;
        if (!Scanner.$assertionsDisabled && var9_10 == -1) {
            throw new AssertionError();
        }
        var11_12 = 0;
        var12_13 = false;
        while (var1_1 != 0) {
            block22: {
                if (var6_9 <= 0 || (var14_15 = this.readNBitUnsigned(var6_9, var3_3)) >= var4_6) break block22;
                var13_14 = var7_7[var5_8 + var14_15];
                ** GOTO lbl-1000
            }
            var13_14 = this.readUnsignedInteger(var3_3);
            if ((var13_14 & -65536) != 0) {
                if (!var12_13) {
                    var15_16 = new char[2 * var10_11];
                    for (var16_17 = 0; var16_17 < var11_12; ++var16_17) {
                        var15_16[var16_17] = var8_5[var9_10 + var16_17];
                    }
                    var9_10 = 0;
                    var8_5 = var15_16;
                    this.m_characterBuffer.redeemCharacters(var10_11);
                    var12_13 = true;
                }
                var8_5[var11_12++] = (char)(var13_14 - 65536 >> 10 | 55296);
                var8_5[var11_12++] = (char)(var13_14 - 65536 & 1023 | 56320);
            } else lbl-1000:
            // 2 sources

            {
                var8_5[var9_10 + var11_12++] = (char)var13_14;
            }
            --var1_1;
        }
        return new Characters(var8_5, var9_10, var11_12, this.m_characterBuffer.isVolatile);
    }

    protected abstract int readNBitUnsigned(int var1, InputStream var2) throws IOException;

    protected abstract int readEightBitsUnsigned(InputStream var1) throws IOException;

    private final class FloatValueScanner
    extends ValueScannerBase {
        FloatValueScanner() {
            super(new QName("exi:double", "http://www.w3.org/2009/exi"));
        }

        public short getCodecID() {
            return 13;
        }

        public int getBuiltinRCS(int n) {
            return -7;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            boolean bl = Scanner.this.readBoolean(this.m_istream);
            long l = this.readUnsignedInteger63(this.m_istream);
            if (bl) {
                l = -l - 1L;
            }
            String string = Long.toString(l);
            boolean bl2 = Scanner.this.readBoolean(this.m_istream);
            int n4 = Scanner.this.readUnsignedInteger(this.m_istream);
            if (bl2) {
                ++n4;
            }
            String string2 = 16384 != n4 ? string + 'E' + (bl2 ? "-" : "") + Integer.toString(n4) : (l == 1L ? "INF" : (l == -1L ? "-INF" : "NaN"));
            int n5 = string2.length();
            Scanner.this.m_characterBuffer.ensureCharacters(n5);
            return Scanner.this.m_characterBuffer.addString(string2, n5);
        }

        private final long readUnsignedInteger63(InputStream inputStream) throws IOException {
            int n = 0;
            boolean bl = true;
            long l = 0L;
            do {
                long l2;
                if (((l2 = (long)Scanner.this.readEightBitsUnsigned(inputStream)) & 0x80L) != 0L) {
                    l2 &= 0x7FL;
                } else {
                    bl = false;
                }
                l += l2 << n;
                if (bl) continue;
                return l;
            } while ((n += 7) != 63);
            assert (!bl);
            return l;
        }
    }

    private final class GMonthValueScanner
    extends DateTimeValueScannerBase {
        GMonthValueScanner() {
            super(new QName("exi:gMonth", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 11;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readGMonth(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class GDayValueScanner
    extends DateTimeValueScannerBase {
        GDayValueScanner() {
            super(new QName("exi:gDay", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 10;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readGDay(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class GMonthDayValueScanner
    extends DateTimeValueScannerBase {
        GMonthDayValueScanner() {
            super(new QName("exi:gMonthDay", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 9;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readGMonthDay(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class GYearValueScanner
    extends DateTimeValueScannerBase {
        GYearValueScanner() {
            super(new QName("exi:gYear", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 8;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readYear(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class GYearMonthValueScanner
    extends DateTimeValueScannerBase {
        GYearMonthValueScanner() {
            super(new QName("exi:gYearMonth", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 7;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readGYearMonth(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class DateValueScanner
    extends DateTimeValueScannerBase {
        DateValueScanner() {
            super(new QName("exi:date", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 6;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readYear(this.m_istream);
            this.readMonthDay(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class TimeValueScanner
    extends DateTimeValueScannerBase {
        TimeValueScanner() {
            super(new QName("exi:time", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 5;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readTime(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class DateTimeValueScanner
    extends DateTimeValueScannerBase {
        DateTimeValueScanner() {
            super(new QName("exi:dateTime", "http://www.w3.org/2009/exi"), Scanner.this);
        }

        public short getCodecID() {
            return 4;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            this.m_n_dateTimeCharacters = 0;
            this.readYear(this.m_istream);
            this.readMonthDay(this.m_istream);
            this.m_dateTimeCharacters[this.m_n_dateTimeCharacters++] = 84;
            this.readTime(this.m_istream);
            this.readTimeZone(this.m_istream);
            Scanner.this.m_characterBuffer.ensureCharacters(this.m_n_dateTimeCharacters);
            return Scanner.this.m_characterBuffer.addChars(this.m_dateTimeCharacters, this.m_n_dateTimeCharacters);
        }
    }

    private final class DecimalValueScanner
    extends ValueScannerBase {
        private final char[] m_integralDigitsChars;
        private final char[] m_fractionDigitsChars;

        DecimalValueScanner() {
            super(new QName("exi:decimal", "http://www.w3.org/2009/exi"));
            this.m_integralDigitsChars = new char[128];
            this.m_fractionDigitsChars = new char[128];
        }

        public short getCodecID() {
            return 12;
        }

        public int getBuiltinRCS(int n) {
            return -6;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            boolean bl = Scanner.this.readBoolean(this.m_istream);
            int n4 = Scanner.this.readUnsignedIntegerChars(this.m_istream, false, this.m_integralDigitsChars);
            if (bl) {
                this.m_integralDigitsChars[n4++] = 45;
            }
            int n5 = Scanner.this.readUnsignedIntegerChars(this.m_istream, false, this.m_fractionDigitsChars);
            int n6 = n4 + 1 + n5;
            Scanner.this.m_characterBuffer.ensureCharacters(n6);
            return Scanner.this.m_characterBuffer.addDecimalChars(this.m_integralDigitsChars, n4, this.m_fractionDigitsChars, n5, n6);
        }
    }

    private final class ListValueScanner
    extends ValueScannerBase {
        private char[] m_listChars;

        public ListValueScanner() {
            super(null);
            this.m_listChars = new char[512];
        }

        public short getCodecID() {
            return 16;
        }

        public int getBuiltinRCS(int n) {
            assert (Scanner.this.schema.getVarietyOfSimpleType(n) == 2);
            int n2 = Scanner.this.schema.getItemTypeOfListSimpleType(n);
            short s = Scanner.this.m_codecTable[Scanner.this.schema.getSerialOfType(n2)];
            ValueScanner valueScanner = Scanner.this.m_valueScannerTable[s];
            return valueScanner.getBuiltinRCS(n2);
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            assert (Scanner.this.schema.getVarietyOfSimpleType(n3) == 2);
            int n4 = Scanner.this.schema.getItemTypeOfListSimpleType(n3);
            short s = Scanner.this.m_codecTable[Scanner.this.schema.getSerialOfType(n4)];
            ValueScanner valueScanner = Scanner.this.m_valueScannerTable[s];
            int n5 = Scanner.this.readUnsignedInteger(this.m_istream);
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                if (i != 0) {
                    if (n6 == this.m_listChars.length) {
                        this.expandCharArray();
                    }
                    this.m_listChars[n6++] = 32;
                }
                Characters characters = valueScanner.scan(n, n2, n4);
                int n7 = characters.length;
                if (n6 + n7 > this.m_listChars.length) {
                    this.expandCharArray();
                }
                System.arraycopy(characters.characters, characters.startIndex, this.m_listChars, n6, n7);
                n6 += n7;
            }
            Scanner.this.m_characterBuffer.ensureCharacters(n6);
            return Scanner.this.m_characterBuffer.addChars(this.m_listChars, n6);
        }

        private void expandCharArray() {
            int n = this.m_listChars.length;
            int n2 = n + (n >> 1);
            char[] cArray = new char[n2];
            System.arraycopy(this.m_listChars, 0, cArray, 0, n);
            this.m_listChars = cArray;
        }
    }

    private final class EnumerationValueScanner
    extends ValueScannerBase {
        EnumerationValueScanner() {
            super(null);
        }

        public short getCodecID() {
            return 17;
        }

        public int getBuiltinRCS(int n) {
            int n2 = Scanner.this.schema.getBaseTypeOfSimpleType(n);
            return Scanner.this.getValueScanner(n2).getBuiltinRCS(n2);
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            int n4 = Scanner.this.schema.getEnumerationFacetCountOfAtomicSimpleType(n3);
            assert (n4 > 0);
            int n5 = 0;
            int n6 = n4 - 1;
            while (n6 != 0) {
                n6 >>= 1;
                ++n5;
            }
            int n7 = Scanner.this.readNBitUnsigned(n5, this.m_istream);
            assert (n7 >= 0);
            int n8 = Scanner.this.schema.getEnumerationFacetOfAtomicSimpleType(n3, n7);
            return Scanner.this.schema.getVariantCharacters(n8);
        }
    }

    private final class IntegerValueScanner
    extends ValueScannerBase {
        private int[] m_ints;
        private int[] m_variants;
        private long[] m_longs;
        private final char[] m_digitsBuffer;

        IntegerValueScanner() {
            super(new QName("exi:integer", "http://www.w3.org/2009/exi"));
            this.m_variants = null;
            this.m_ints = null;
            this.m_longs = null;
            this.m_digitsBuffer = new char[128];
        }

        public void setSchema(EXISchema eXISchema) {
            if (eXISchema != null) {
                this.m_ints = eXISchema.getInts();
                this.m_variants = eXISchema.getVariants();
                this.m_longs = eXISchema.getLongs();
            } else {
                this.m_variants = null;
                this.m_ints = null;
                this.m_longs = null;
            }
        }

        public short getCodecID() {
            return 14;
        }

        public int getBuiltinRCS(int n) {
            return -8;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            boolean bl = false;
            if (Scanner.this.schema.ancestryIds[Scanner.this.m_types[n3 + 2]] == 21) {
                int n4 = EXISchema._getWidthOfIntegralSimpleType(n3, Scanner.this.m_types);
                switch (n4) {
                    case 255: {
                        bl = Scanner.this.readBoolean(this.m_istream);
                    }
                    case 254: {
                        int n5 = Scanner.this.readUnsignedIntegerChars(this.m_istream, bl, this.m_digitsBuffer);
                        if (bl) {
                            this.m_digitsBuffer[n5++] = 45;
                        }
                        Scanner.this.m_characterBuffer.ensureCharacters(n5);
                        return Scanner.this.m_characterBuffer.addCharsReverse(this.m_digitsBuffer, n5);
                    }
                }
                int n6 = 0;
                int n7 = Scanner.this.readNBitUnsigned(n4, this.m_istream);
                int n8 = Scanner.this.schema.getMinInclusiveFacetOfIntegerSimpleType(n3);
                int n9 = Scanner.this.schema.getTypeOfVariant(n8);
                switch (n9) {
                    case 4: {
                        int n10 = this.m_ints[this.m_variants[n8]];
                        bl = (n7 += n10) < 0;
                        if (bl) {
                            n7 = -n7;
                        }
                        do {
                            this.m_digitsBuffer[n6++] = (char)(48 + n7 % 10);
                        } while ((n7 /= 10) != 0);
                        if (bl) {
                            this.m_digitsBuffer[n6++] = 45;
                        }
                        Scanner.this.m_characterBuffer.ensureCharacters(n6);
                        return Scanner.this.m_characterBuffer.addCharsReverse(this.m_digitsBuffer, n6);
                    }
                    case 5: {
                        long l = this.m_longs[this.m_variants[n8]];
                        long l2 = l + (long)n7;
                        bl = l2 < 0L;
                        if (bl) {
                            l2 = -l2;
                        }
                        do {
                            this.m_digitsBuffer[n6++] = (char)(48L + l2 % 10L);
                        } while ((l2 /= 10L) != 0L);
                        if (bl) {
                            this.m_digitsBuffer[n6++] = 45;
                        }
                        Scanner.this.m_characterBuffer.ensureCharacters(n6);
                        return Scanner.this.m_characterBuffer.addCharsReverse(this.m_digitsBuffer, n6);
                    }
                }
                assert (n9 == 3);
                BigInteger bigInteger = Scanner.this.schema.getIntegerValueOfVariant(n8);
                String string = bigInteger.add(BigInteger.valueOf(n7)).toString();
                int n11 = string.length();
                Scanner.this.m_characterBuffer.ensureCharacters(n11);
                return Scanner.this.m_characterBuffer.addString(string, n11);
            }
            bl = Scanner.this.readBoolean(this.m_istream);
            int n12 = Scanner.this.readUnsignedIntegerChars(this.m_istream, bl, this.m_digitsBuffer);
            if (bl) {
                this.m_digitsBuffer[n12++] = 45;
            }
            Scanner.this.m_characterBuffer.ensureCharacters(n12);
            return Scanner.this.m_characterBuffer.addCharsReverse(this.m_digitsBuffer, n12);
        }
    }

    private final class BooleanValueScanner
    extends ValueScannerBase {
        BooleanValueScanner() {
            super(new QName("exi:boolean", "http://www.w3.org/2009/exi"));
        }

        public short getCodecID() {
            return 3;
        }

        public int getBuiltinRCS(int n) {
            return -4;
        }

        public Characters scan(int n, int n2, int n3) throws IOException {
            if (Scanner.this.schema.isPatternedBooleanSimpleType(n3)) {
                switch (Scanner.this.readNBitUnsigned(2, this.m_istream)) {
                    case 0: {
                        return FALSE;
                    }
                    case 1: {
                        return ZERO;
                    }
                    case 2: {
                        return TRUE;
                    }
                    case 3: {
                        return ONE;
                    }
                }
                assert (false);
                return null;
            }
            boolean bl = Scanner.this.readBoolean(this.m_istream);
            return bl ? TRUE : FALSE;
        }
    }
}

