/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.lbzip2.BitStream;
import org.lbzip2.Decoder;
import org.lbzip2.Retriever;
import org.lbzip2.Status;
import org.lbzip2.StreamFormatException;

public class MBC {
    private final InputStream in;
    private final OutputStream out;
    private final BitStream bs = new BitStream();
    private final Decoder ds = new Decoder();

    public MBC(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.bs.ptr = new byte[1];
        this.bs.off = 1;
        this.bs.len = 1;
    }

    private static void err(String msg) throws StreamFormatException {
        throw new StreamFormatException(msg);
    }

    private int read() throws IOException {
        return this.in.read();
    }

    private static void bad() throws StreamFormatException {
        MBC.err("Data error");
    }

    private int get(int n) throws IOException {
        Status s;
        while ((s = this.bs.need(n)) == Status.MORE) {
            if (this.in.read(this.bs.ptr) < 0) {
                this.bs.eof = true;
                continue;
            }
            this.bs.off = 0;
        }
        if (s == Status.FINISH) {
            MBC.bad();
        }
        int x = this.bs.peek(n);
        this.bs.dump(n);
        return x;
    }

    private void decode_and_emit() throws StreamFormatException, IOException {
        Status status;
        if (this.ds.bwt_idx >= this.ds.block_size) {
            MBC.bad();
        }
        this.ds.decode();
        byte[] buf = new byte[4096];
        int[] len = new int[]{buf.length};
        do {
            status = this.ds.emit(buf, 0, len);
            this.out.write(buf, 0, buf.length - len[0]);
        } while (status == Status.MORE);
        assert (status == Status.OK);
    }

    public void expand() throws StreamFormatException, IOException {
        int t;
        if (this.get(24) != 4348520) {
            MBC.bad();
        }
        if ((t = this.get(8) - 49 & 0xFF) >= 9) {
            MBC.bad();
        }
        do {
            Retriever r = new Retriever();
            r.setMbs(100000 * (t + 1));
            int c = 0;
            while ((t = this.get(16)) == 12609) {
                Status s;
                if (this.get(32) != 1495683929) {
                    MBC.bad();
                }
                t = this.get(32);
                while ((s = r.retr(this.ds, this.bs)) == Status.MORE) {
                    if (this.in.read(this.bs.ptr) < 0) {
                        this.bs.eof = true;
                        continue;
                    }
                    this.bs.off = 0;
                }
                if (s == Status.FINISH) {
                    MBC.bad();
                }
                this.decode_and_emit();
                if (this.ds.crc != t) {
                    MBC.bad();
                }
                c = c << 1 ^ c >>> 31 ^ t;
            }
            if (t != 6002) {
                MBC.bad();
            }
            if (this.get(32) != 1161318544) {
                MBC.bad();
            }
            if (this.get(32) != c) {
                MBC.bad();
            }
            this.bs.align();
        } while (this.read() == 66 && this.read() == 90 && this.read() == 104 && (t = this.get(8) - 49) < 9);
    }
}

