/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.BWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManberMyersBWT
implements BWT {
    private final Logger logger = LoggerFactory.getLogger(ManberMyersBWT.class);

    ManberMyersBWT() {
    }

    public int transform(byte[] D, int[] P, int n) {
        int j;
        int i;
        this.logger.debug("Manber-Myers BWT, block size {}", (Object)n);
        boolean[] A = new boolean[n];
        boolean[] B = new boolean[n + 1];
        int[] C = new int[Math.max(n, 256)];
        int[] R = new int[n];
        this.logger.trace("  Bucket sorting...");
        for (i = 0; i < 256; ++i) {
            C[i] = 0;
        }
        for (i = 0; i < n; ++i) {
            int n2 = D[i] + 128;
            C[n2] = C[n2] + 1;
        }
        for (i = 1; i < 256; ++i) {
            int n3 = i;
            C[n3] = C[n3] + C[i - 1];
        }
        i = 0;
        while (i < n) {
            int n4 = D[i] + 128;
            int n5 = C[n4] - 1;
            C[n4] = n5;
            P[n5] = i++;
        }
        for (i = 0; i < n; ++i) {
            B[i] = false;
        }
        for (i = 0; i < 256; ++i) {
            B[C[i]] = true;
        }
        B[n] = true;
        for (int h = 1; h < n; h *= 2) {
            this.logger.trace("  Suffix sorting at depth {}...", (Object)h);
            i = 0;
            while (i < n) {
                C[i] = i;
                for (j = i; j == i || !B[j]; ++j) {
                    R[P[j]] = i;
                    A[j] = false;
                }
                i = j;
            }
            i = 0;
            while (i < n) {
                int e;
                int d;
                for (j = i; j == i || !B[j]; ++j) {
                    d = (P[j] - h + n) % n;
                    int n6 = e = R[d];
                    C[n6] = C[n6] + 1;
                    A[R[d]] = true;
                }
                for (j = i; j == i || !B[j]; ++j) {
                    d = (P[j] - h + n) % n;
                    e = R[d];
                    if (!A[e]) continue;
                    ++e;
                    while (!B[e] && A[e]) {
                        A[e] = false;
                        ++e;
                    }
                }
                i = j;
            }
            for (i = 0; i < n; ++i) {
                P[R[i]] = i;
                int n7 = i;
                B[n7] = B[n7] | A[i];
            }
        }
        this.logger.trace("  Constructing BWT...");
        j = R[0];
        P[j] = n;
        for (i = 0; i < n; ++i) {
            P[i] = D[P[i] - 1] + 128;
        }
        return j;
    }
}

