/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

class MtfDecoder {
    static final int ROW_WIDTH = 16;
    static final int SLIDE_LENGTH = 8192;
    static final int NUM_ROWS = 16;
    static final int CMAP_BASE = 7936;
    int[] imtf_row = new int[16];
    byte[] imtf_slide = new byte[8192];

    void initialize() {
        for (int i = 0; i < 16; ++i) {
            this.imtf_row[i] = 7936 + i * 16;
        }
    }

    int mtf_one(int nn) {
        byte c;
        int pp;
        if (nn < 16) {
            pp = this.imtf_row[0];
            c = this.imtf_slide[pp + nn];
            while (nn > 0) {
                this.imtf_slide[pp + nn] = this.imtf_slide[pp + nn - 1];
                --nn;
            }
        } else {
            if (this.imtf_row[0] == 0) {
                int kk = 8192;
                int rr = 16;
                while (rr > 0) {
                    int bg = this.imtf_row[--rr];
                    int bb = bg + 16;
                    assert (bg >= 0 && bb <= 8192);
                    while (bb > bg) {
                        this.imtf_slide[--kk] = this.imtf_slide[--bb];
                    }
                    this.imtf_row[rr] = kk;
                }
            }
            int lno = nn >> 4 & 0xF;
            int bb = this.imtf_row[lno];
            pp = bb + (nn & 0xF);
            c = this.imtf_slide[pp];
            while (pp > bb) {
                int tt = pp--;
                this.imtf_slide[tt] = this.imtf_slide[pp];
            }
            while (lno > 0) {
                int lno1 = lno--;
                int n = lno;
                int n2 = this.imtf_row[n] - 1;
                this.imtf_row[n] = n2;
                pp = n2;
                this.imtf_slide[this.imtf_row[lno1]] = this.imtf_slide[pp + 16];
            }
        }
        this.imtf_slide[pp] = c;
        return c & 0xFF;
    }
}

