/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.Unsigned;
import org.lbzip2.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TandemRepeatSort {
    private final Logger logger = LoggerFactory.getLogger(TandemRepeatSort.class);
    private static final int TR_INSERTIONSORT_THRESHOLD = 8;
    int chance;
    int remain;
    int incval;
    int count;

    TandemRepeatSort() {
    }

    private final int STACK_PUSH5(int[] stack, int ssize, int a, int b, int c, int d, int e) {
        stack[ssize] = a;
        stack[ssize + 1] = b;
        stack[ssize + 2] = c;
        stack[ssize + 3] = d;
        stack[ssize + 4] = e;
        return ssize + 5;
    }

    private final int TR_GETC(int[] SA, int depth, int num_bstar, int p) {
        int index = p + depth;
        return SA[Unsigned.umin(index, index - num_bstar) + num_bstar];
    }

    private final void tr_insertionsort(int[] SA, int depth, int num_bstar, int first, int last) {
        for (int a = first + 1; a < last; ++a) {
            int r;
            int t = SA[a];
            int b = a - 1;
            while (0 > (r = this.TR_GETC(SA, depth, num_bstar, t) - this.TR_GETC(SA, depth, num_bstar, SA[b]))) {
                do {
                    SA[b + 1] = SA[b];
                } while (first <= --b && SA[b] < 0);
                if (b >= first) continue;
            }
            if (r == 0) {
                SA[b] = ~SA[b];
            }
            SA[b + 1] = t;
        }
    }

    private final void tr_fixdown(int[] SA, int depth, int num_bstar, int root, int i, int size) {
        int j;
        int v = SA[root + i];
        int c = this.TR_GETC(SA, depth, num_bstar, v);
        while ((j = 2 * i + 1) < size) {
            int e;
            int k;
            int d;
            if ((d = this.TR_GETC(SA, depth, num_bstar, SA[root + (k = j++)])) < (e = this.TR_GETC(SA, depth, num_bstar, SA[root + j]))) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[root + i] = SA[root + k];
            i = k;
        }
        SA[root + i] = v;
    }

    private final void tr_heapsort(int[] SA, int depth, int num_bstar, int root, int size) {
        int i;
        int t;
        int m = size;
        if (size % 2 == 0 && this.TR_GETC(SA, depth, num_bstar, SA[root + --m / 2]) < this.TR_GETC(SA, depth, num_bstar, SA[root + m])) {
            t = SA[root + m];
            SA[root + m] = SA[root + m / 2];
            SA[root + m / 2] = t;
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.tr_fixdown(SA, depth, num_bstar, root, i, m);
        }
        if (size % 2 == 0) {
            t = SA[root];
            SA[root] = SA[root + m];
            SA[root + m] = t;
            this.tr_fixdown(SA, depth, num_bstar, root, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            t = SA[root];
            SA[root] = SA[root + i];
            this.tr_fixdown(SA, depth, num_bstar, root, 0, i);
            SA[root + i] = t;
        }
    }

    private final long tr_pivot_key(int[] SA, int depth, int num_bstar, int p) {
        return ((long)this.TR_GETC(SA, depth, num_bstar, SA[p]) << 32) + (long)p;
    }

    private final int tr_pivot(int[] SA, int depth, int num_bstar, int first, int last) {
        int t = last - first >> 1;
        int middle = first + t;
        long v1 = this.tr_pivot_key(SA, depth, num_bstar, first);
        long v5 = this.tr_pivot_key(SA, depth, num_bstar, middle);
        long v9 = this.tr_pivot_key(SA, depth, num_bstar, last - 1);
        if (t <= 16) {
            return (int)Utils.med3(v1, v5, v9);
        }
        long v3 = this.tr_pivot_key(SA, depth, num_bstar, first + (t >>= 1));
        long v7 = this.tr_pivot_key(SA, depth, num_bstar, last - t);
        if (t <= 128) {
            return (int)Utils.med5(v1, v3, v5, v7, v9);
        }
        long v2 = this.tr_pivot_key(SA, depth, num_bstar, first + (t >>= 1));
        long v4 = this.tr_pivot_key(SA, depth, num_bstar, middle - t);
        long v6 = this.tr_pivot_key(SA, depth, num_bstar, middle + t);
        long v8 = this.tr_pivot_key(SA, depth, num_bstar, last - t);
        return (int)Utils.med3(Utils.med3(v1, v2, v3), Utils.med3(v4, v5, v6), Utils.med3(v7, v8, v9));
    }

    private final void trbudget_init(int chance, int incval) {
        this.chance = chance;
        this.remain = this.incval = incval;
    }

    private final boolean trbudget_check(int size) {
        if (size <= this.remain) {
            this.remain -= size;
            return true;
        }
        if (this.chance == 0) {
            this.count += size;
            return false;
        }
        this.remain += this.incval - size;
        --this.chance;
        return true;
    }

    private final long tr_partition(int[] SA, int depth, int num_bstar, int first, int middle, int last, int v) {
        int t;
        int x = 0;
        int b = middle - 1;
        while (++b < last && (x = this.TR_GETC(SA, depth, num_bstar, SA[b])) == v) {
        }
        int a = b;
        if (a < last && x < v) {
            while (++b < last && (x = this.TR_GETC(SA, depth, num_bstar, SA[b])) <= v) {
                if (x != v) continue;
                t = SA[b];
                SA[b] = SA[a];
                SA[a] = t;
                ++a;
            }
        }
        int c = last;
        while (b < --c && (x = this.TR_GETC(SA, depth, num_bstar, SA[c])) == v) {
        }
        int d = c;
        if (b < d && x > v) {
            while (b < --c && (x = this.TR_GETC(SA, depth, num_bstar, SA[c])) >= v) {
                if (x != v) continue;
                t = SA[c];
                SA[c] = SA[d];
                SA[d] = t;
                --d;
            }
        }
        while (b < c) {
            t = SA[b];
            SA[b] = SA[c];
            SA[c] = t;
            while (++b < c && (x = this.TR_GETC(SA, depth, num_bstar, SA[b])) <= v) {
                if (x != v) continue;
                t = SA[b];
                SA[b] = SA[a];
                SA[a] = t;
                ++a;
            }
            while (b < --c && (x = this.TR_GETC(SA, depth, num_bstar, SA[c])) >= v) {
                if (x != v) continue;
                t = SA[c];
                SA[c] = SA[d];
                SA[d] = t;
                --d;
            }
        }
        if (a <= d) {
            c = b - 1;
            int s = a - first;
            t = b - a;
            if (s > t) {
                s = t;
            }
            int e = first;
            int f = b - s;
            while (0 < s) {
                t = SA[e];
                SA[e] = SA[f];
                SA[f] = t;
                --s;
                ++e;
                ++f;
            }
            s = d - c;
            t = last - d - 1;
            if (s > t) {
                s = t;
            }
            e = b;
            f = last - s;
            while (0 < s) {
                t = SA[e];
                SA[e] = SA[f];
                SA[f] = t;
                --s;
                ++e;
                ++f;
            }
            first += b - a;
            last -= d - c;
        }
        return ((long)first << 32) + (long)last;
    }

    private final void tr_copy(int[] SA, int num_bstar, int first, int a, int b, int last, int depth) {
        int s;
        int c;
        int v = b - 1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            s = SA[c] - depth;
            if (s < 0) {
                s += num_bstar;
            }
            if (SA[num_bstar + s] != v) continue;
            SA[++d] = s;
            SA[num_bstar + s] = d;
        }
        c = last - 1;
        int e = d + 1;
        d = b;
        while (e < d) {
            s = SA[c] - depth;
            if (s < 0) {
                s += num_bstar;
            }
            if (SA[num_bstar + s] == v) {
                SA[--d] = s;
                SA[num_bstar + s] = d;
            }
            --c;
        }
    }

    private final void tr_partialcopy(int[] SA, int num_bstar, int first, int a, int b, int last, int depth) {
        int e;
        int rank;
        int s;
        int t;
        int c;
        int newrank = -1;
        int v = b - 1;
        int lastrank = -1;
        int d = a - 1;
        for (c = first; c <= d; ++c) {
            t = SA[c];
            s = t - depth;
            if (s < 0) {
                s += num_bstar;
            }
            if (SA[num_bstar + s] != v) continue;
            SA[++d] = s;
            rank = SA[num_bstar + t];
            if (lastrank != rank) {
                lastrank = rank;
                newrank = d;
            }
            SA[num_bstar + s] = newrank;
        }
        lastrank = -1;
        for (e = d; first <= e; --e) {
            rank = SA[num_bstar + SA[e]];
            if (lastrank != rank) {
                lastrank = rank;
                newrank = e;
            }
            if (newrank == rank) continue;
            SA[num_bstar + SA[e]] = newrank;
        }
        lastrank = -1;
        c = last - 1;
        e = d + 1;
        d = b;
        while (e < d) {
            t = SA[c];
            s = t - depth;
            if (s < 0) {
                s += num_bstar;
            }
            if (SA[num_bstar + s] == v) {
                SA[--d] = s;
                rank = SA[num_bstar + t];
                if (lastrank != rank) {
                    lastrank = rank;
                    newrank = d;
                }
                SA[num_bstar + s] = newrank;
            }
            --c;
        }
    }

    private final void tr_introsort(int[] SA, int depth, int num_bstar, int first, int last) {
        int TR_STACKSIZE = 64;
        int[] stack = new int[320];
        int x = 0;
        int incr = depth;
        int trlink = -1;
        int ssize = 0;
        int limit = Utils.ilog2(last - first);
        while (true) {
            int next;
            int c;
            int v;
            int b;
            int a;
            long range;
            assert (depth < num_bstar || limit == -3);
            if (limit < 0) {
                if (limit == -1) {
                    range = this.tr_partition(SA, depth - incr, num_bstar, first, first, last, last - 1);
                    a = (int)(range >> 32);
                    b = (int)range;
                    if (a < last) {
                        v = a - 1;
                        for (c = first; c < a; ++c) {
                            SA[num_bstar + SA[c]] = v;
                        }
                    }
                    if (b < last) {
                        v = b - 1;
                        for (c = a; c < b; ++c) {
                            SA[num_bstar + SA[c]] = v;
                        }
                    }
                    if (1 < b - a) {
                        ssize = this.STACK_PUSH5(stack, ssize, Integer.MIN_VALUE, a, b, 0, 0);
                        ssize = this.STACK_PUSH5(stack, ssize, depth - incr, first, last, -2, trlink);
                        trlink = ssize - 10;
                    }
                    if (a - first <= last - b) {
                        if (1 < a - first) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, Utils.ilog2(last - b), trlink);
                            last = a;
                            limit = Utils.ilog2(a - first);
                            continue;
                        }
                        if (1 < last - b) {
                            first = b;
                            limit = Utils.ilog2(last - b);
                            continue;
                        }
                        if (ssize == 0) {
                            return;
                        }
                        depth = stack[ssize - 5];
                        first = stack[ssize - 4];
                        last = stack[ssize - 3];
                        limit = stack[ssize - 2];
                        trlink = stack[ssize - 1];
                        ssize -= 5;
                        continue;
                    }
                    if (1 < last - b) {
                        ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, Utils.ilog2(a - first), trlink);
                        first = b;
                        limit = Utils.ilog2(last - b);
                        continue;
                    }
                    if (1 < a - first) {
                        last = a;
                        limit = Utils.ilog2(a - first);
                        continue;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    depth = stack[ssize - 5];
                    first = stack[ssize - 4];
                    last = stack[ssize - 3];
                    limit = stack[ssize - 2];
                    trlink = stack[ssize - 1];
                    ssize -= 5;
                    continue;
                }
                if (limit == -2) {
                    if (ssize == 0) {
                        return;
                    }
                    a = stack[ssize - 4];
                    b = stack[ssize - 3];
                    limit = stack[ssize - 2];
                    ssize -= 5;
                    if (limit == 0) {
                        this.tr_copy(SA, num_bstar, first, a, b, last, depth);
                    } else {
                        if (0 <= trlink) {
                            stack[trlink + 3] = -1;
                        }
                        this.tr_partialcopy(SA, num_bstar, first, a, b, last, depth);
                    }
                    if (ssize == 0) {
                        return;
                    }
                    depth = stack[ssize - 5];
                    first = stack[ssize - 4];
                    last = stack[ssize - 3];
                    limit = stack[ssize - 2];
                    trlink = stack[ssize - 1];
                    ssize -= 5;
                    continue;
                }
                if (0 <= SA[first]) {
                    a = first;
                    do {
                        SA[num_bstar + SA[a]] = a;
                    } while (++a < last && 0 <= SA[a]);
                    first = a;
                }
                if (first < last) {
                    a = first;
                    do {
                        SA[a] = ~SA[a];
                    } while (SA[++a] < 0);
                    int n = incr < num_bstar - depth ? (SA[num_bstar + SA[a]] != this.TR_GETC(SA, depth, num_bstar, SA[a]) ? Utils.ilog2(a - first + 1) : -1) : (next = -3);
                    if (++a < last) {
                        v = a - 1;
                        for (b = first; b < a; ++b) {
                            SA[num_bstar + SA[b]] = v;
                        }
                    }
                    if (this.trbudget_check(a - first)) {
                        if (a - first <= last - a) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth, a, last, -3, trlink);
                            depth += incr;
                            last = a;
                            limit = next;
                            continue;
                        }
                        if (1 < last - a) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth + incr, first, a, next, trlink);
                            first = a;
                            limit = -3;
                            continue;
                        }
                        depth += incr;
                        last = a;
                        limit = next;
                        continue;
                    }
                    if (0 <= trlink) {
                        stack[trlink + 3] = -1;
                    }
                    if (1 < last - a) {
                        first = a;
                        limit = -3;
                        continue;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    depth = stack[ssize - 5];
                    first = stack[ssize - 4];
                    last = stack[ssize - 3];
                    limit = stack[ssize - 2];
                    trlink = stack[ssize - 1];
                    ssize -= 5;
                    continue;
                }
                if (ssize == 0) {
                    return;
                }
                depth = stack[ssize - 5];
                first = stack[ssize - 4];
                last = stack[ssize - 3];
                limit = stack[ssize - 2];
                trlink = stack[ssize - 1];
                ssize -= 5;
                continue;
            }
            if (last - first <= 8) {
                this.tr_insertionsort(SA, depth, num_bstar, first, last);
                limit = -3;
                continue;
            }
            if (limit-- == 0) {
                this.tr_heapsort(SA, depth, num_bstar, first, last - first);
                a = last - 1;
                while (first < a) {
                    x = this.TR_GETC(SA, depth, num_bstar, SA[a]);
                    for (b = a - 1; first <= b && this.TR_GETC(SA, depth, num_bstar, SA[b]) == x; --b) {
                        SA[b] = ~SA[b];
                    }
                    a = b;
                }
                limit = -3;
                continue;
            }
            a = this.tr_pivot(SA, depth, num_bstar, first, last);
            int t = SA[first];
            SA[first] = SA[a];
            SA[a] = t;
            v = this.TR_GETC(SA, depth, num_bstar, SA[first]);
            range = this.tr_partition(SA, depth, num_bstar, first, first + 1, last, v);
            b = (int)range;
            if (last - first != b - (a = (int)(range >> 32))) {
                next = incr < num_bstar - depth ? (SA[num_bstar + SA[a]] != v ? Utils.ilog2(b - a) : -1) : -3;
                v = a - 1;
                for (c = first; c < a; ++c) {
                    SA[num_bstar + SA[c]] = v;
                }
                if (b < last) {
                    v = b - 1;
                    for (c = a; c < b; ++c) {
                        SA[num_bstar + SA[c]] = v;
                    }
                }
                if (1 < b - a && this.trbudget_check(b - a)) {
                    if (a - first <= last - b) {
                        if (last - b <= b - a) {
                            if (1 < a - first) {
                                ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                                ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                                last = a;
                                continue;
                            }
                            if (1 < last - b) {
                                ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                                first = b;
                                continue;
                            }
                            depth += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        if (a - first <= b - a) {
                            if (1 < a - first) {
                                ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                                ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                                last = a;
                                continue;
                            }
                            ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                            depth += incr;
                            first = a;
                            last = b;
                            limit = next;
                            continue;
                        }
                        ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                        ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                        depth += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (a - first <= b - a) {
                        if (1 < last - b) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                            ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                            first = b;
                            continue;
                        }
                        if (1 < a - first) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                            last = a;
                            continue;
                        }
                        depth += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    if (last - b <= b - a) {
                        if (1 < last - b) {
                            ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                            ssize = this.STACK_PUSH5(stack, ssize, depth + incr, a, b, next, trlink);
                            first = b;
                            continue;
                        }
                        ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                        depth += incr;
                        first = a;
                        last = b;
                        limit = next;
                        continue;
                    }
                    ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                    ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                    depth += incr;
                    first = a;
                    last = b;
                    limit = next;
                    continue;
                }
                if (1 < b - a && 0 <= trlink) {
                    stack[trlink + 3] = -1;
                }
                if (a - first <= last - b) {
                    if (1 < a - first) {
                        ssize = this.STACK_PUSH5(stack, ssize, depth, b, last, limit, trlink);
                        last = a;
                        continue;
                    }
                    if (1 < last - b) {
                        first = b;
                        continue;
                    }
                    if (ssize == 0) {
                        return;
                    }
                    depth = stack[ssize - 5];
                    first = stack[ssize - 4];
                    last = stack[ssize - 3];
                    limit = stack[ssize - 2];
                    trlink = stack[ssize - 1];
                    ssize -= 5;
                    continue;
                }
                if (1 < last - b) {
                    ssize = this.STACK_PUSH5(stack, ssize, depth, first, a, limit, trlink);
                    first = b;
                    continue;
                }
                if (1 < a - first) {
                    last = a;
                    continue;
                }
                if (ssize == 0) {
                    return;
                }
                depth = stack[ssize - 5];
                first = stack[ssize - 4];
                last = stack[ssize - 3];
                limit = stack[ssize - 2];
                trlink = stack[ssize - 1];
                ssize -= 5;
                continue;
            }
            if (this.trbudget_check(last - first)) {
                limit = incr < num_bstar - depth ? (SA[num_bstar + SA[first]] != this.TR_GETC(SA, depth, num_bstar, SA[first]) ? limit + 1 : -1) : -3;
                depth += incr;
                continue;
            }
            if (0 <= trlink) {
                stack[trlink + 3] = -1;
            }
            if (ssize == 0) {
                return;
            }
            depth = stack[ssize - 5];
            first = stack[ssize - 4];
            last = stack[ssize - 3];
            limit = stack[ssize - 2];
            trlink = stack[ssize - 1];
            ssize -= 5;
        }
    }

    final void trsort(int[] SA, int n) {
        int depth = 1;
        if (-n >= SA[0]) {
            return;
        }
        this.trbudget_init(Utils.ilog2(n) * 2 / 3, n);
        while (true) {
            int last;
            int t;
            this.logger.trace("    Tandem repeat sort at depth {}", (Object)depth);
            assert (n > depth);
            int first = 0;
            int skip = 0;
            int unsorted = 0;
            do {
                if ((t = SA[first]) < 0) {
                    first -= t;
                    skip += t;
                    continue;
                }
                if (skip != 0) {
                    SA[first + skip] = skip;
                    skip = 0;
                }
                if (1 < (last = SA[n + t] + 1) - first) {
                    this.count = 0;
                    this.tr_introsort(SA, depth, n, first, last);
                    if (this.count != 0) {
                        unsorted += this.count;
                    } else {
                        skip = first - last;
                    }
                } else if (last - first == 1) {
                    skip = -1;
                }
                first = last;
            } while (first < n);
            if (skip != 0) {
                SA[first + skip] = skip;
            }
            if (unsorted == 0 || -n >= SA[0]) break;
            this.logger.trace("      {} tandem repeats still remain unsorted", (Object)unsorted);
            if (n <= depth * 2) {
                do {
                    if ((t = SA[first]) < 0) {
                        first -= t;
                        continue;
                    }
                    last = SA[n + t] + 1;
                    for (int a = first; a < last; ++a) {
                        SA[n + SA[a]] = a;
                    }
                    first = last;
                } while (first < n);
                break;
            }
            depth += depth;
        }
        this.logger.trace("    Tandem repeat sort done");
    }
}

