/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.util.Arrays;
import org.lbzip2.AbstractDataSink;
import org.lbzip2.CompressedBlock;
import org.lbzip2.Constants;
import org.lbzip2.Encoder;

public class UncompressedBlock
extends AbstractDataSink {
    int size;
    final byte[] block;
    private final int maxSize;
    int crc = -1;
    private int rleState;
    private int rleCharacter;
    final boolean[] inuse = new boolean[256];

    public UncompressedBlock() {
        this(900000);
    }

    public UncompressedBlock(int maxSize) {
        if (maxSize < 1 || maxSize > 900000) {
            throw new IllegalStateException("Invalid maximal block size");
        }
        this.maxSize = maxSize;
        this.block = new byte[maxSize + 1];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.rleState < 0;
    }

    /*
     * Unable to fully structure code
     */
    public int write(byte[] buf, int off, int len) {
        block23: {
            if (len == 0) {
                return 0;
            }
            maxOff = off + len;
            size = this.size;
            crc = this.crc;
            if (!(UncompressedBlock.$assertionsDisabled || this.rleState >= 0 && this.rleState < 259)) {
                throw new AssertionError();
            }
            if (this.rleState != 0) {
                ch = this.rleCharacter;
                block0: while (true) {
                    if (size >= this.maxSize - 1 && (size >= this.maxSize || this.rleState == 3 && off < maxOff && (buf[off] & 255) == ch)) {
                        this.rleState = -1;
                        break block23;
                    }
                    if (off == maxOff) break block23;
                    if (this.rleState >= 4) {
                        if (!UncompressedBlock.$assertionsDisabled && this.rleState < 4) {
                            throw new AssertionError();
                        }
                        if (!UncompressedBlock.$assertionsDisabled && size >= this.maxSize) {
                            throw new AssertionError();
                        }
                        while (off < maxOff) {
                            if ((buf[off] & 255) != ch) {
                                this.block[size++] = (byte)(this.rleState - 4 + 128);
                                this.inuse[this.rleState - 4] = true;
                                break block0;
                            }
                            ++off;
                            crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                            ++this.rleState;
                            if (this.rleState != 259) continue;
                            this.block[size++] = 127;
                            this.inuse[255] = true;
                            break block0;
                        }
                        break block23;
                    }
                    if ((buf[off] & 255) != ch) break;
                    ++off;
                    crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                    ++this.rleState;
                    this.block[size++] = (byte)(ch + 128);
                }
            }
            block2: while (true) {
                if (size >= this.maxSize) {
                    this.rleState = -1;
                    break;
                }
                if (off == maxOff) {
                    this.rleState = 0;
                    break;
                }
                ch = buf[off++] & 255;
                crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                block3: while (true) {
                    this.inuse[ch] = true;
                    this.block[size++] = (byte)(ch + 128);
                    if (size >= this.maxSize) {
                        this.rleState = -1;
                        break block2;
                    }
                    if (off == maxOff) {
                        this.rleState = 1;
                        this.rleCharacter = ch;
                        break block2;
                    }
                    last = ch;
                    ch = buf[off++] & 255;
                    crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                    if (ch != last) continue;
                    this.block[size++] = (byte)(ch + 128);
                    if (size >= this.maxSize) {
                        this.rleState = -1;
                        break block2;
                    }
                    if (off == maxOff) {
                        this.rleState = 2;
                        this.rleCharacter = ch;
                        break block2;
                    }
                    ch = buf[off++] & 255;
                    crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                    if (ch != last) continue;
                    this.block[size++] = (byte)(ch + 128);
                    if (size >= this.maxSize - 1 && (size >= this.maxSize || off < maxOff && (buf[off] & 255) == last)) {
                        this.rleState = -1;
                        break block2;
                    }
                    if (off == maxOff) {
                        this.rleState = 3;
                        this.rleCharacter = ch;
                        break block2;
                    }
                    ch = buf[off++] & 255;
                    crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                    if (ch != last) continue;
                    if (!UncompressedBlock.$assertionsDisabled && size >= this.maxSize - 1) {
                        throw new AssertionError();
                    }
                    this.block[size++] = (byte)(ch + 128);
                    for (run = 4; run < 259; ++run) {
                        if (off == maxOff) {
                            this.rleState = run;
                            this.rleCharacter = ch;
                            break block2;
                        }
                        ch = buf[off++] & 255;
                        savedCrc = crc;
                        crc = crc << 8 ^ Constants.crc_table[crc >>> 24 ^ ch];
                        if (ch == last) continue;
                        this.block[size++] = (byte)(run - 4 + 128);
                        this.inuse[run - 4] = true;
                        if (size >= this.maxSize) ** break;
                        continue block3;
                        --off;
                        crc = savedCrc;
                        this.rleState = -1;
                        break block2;
                    }
                    break;
                }
                this.block[size++] = 127;
                this.inuse[255] = true;
            }
        }
        this.size = size;
        this.crc = crc;
        return len - (maxOff - off);
    }

    public CompressedBlock compress() {
        if (this.size < 1) {
            throw new IllegalStateException("Cannot compress empty block");
        }
        if (this.rleState >= 4) {
            assert (this.size < this.maxSize);
            this.block[this.size++] = (byte)(this.rleState - 4 + 128);
            this.inuse[this.rleState - 4] = true;
        }
        CompressedBlock compressedBlock = Encoder.encode(this);
        Arrays.fill(this.inuse, false);
        this.rleState = 0;
        this.crc = -1;
        this.size = 0;
        return compressedBlock;
    }
}

