/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.launcher.MacLauncher;
import com.install4j.runtime.launcher.integration.UpdateLog;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class Application {
    public static void main(String[] args) {
        if (!HelperCommunication.executeAsHelper(args)) {
            InstallerUtil.setInProcess(false);
            if (args.length == 0) {
                System.err.println("Please provide the application id as first argument");
                System.exit(1);
            }
            String applicationId = args[0];
            String[] rest = new String[args.length - 1];
            System.arraycopy(args, 1, rest, 0, args.length - 1);
            InstallerConfig.setCurrentApplicationId(applicationId);
            CustomApplication customApplication = Application.getCustomApplication();
            if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
                File exeFileName = System.getProperty("exe4j.moduleName") != null ? new File(System.getProperty("exe4j.moduleName")) : Application.getExeFile(customApplication);
                SingleInstance.checkForCurrentLauncher(exeFileName, false, null);
            }
            InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(rest);
            ProgressCommunication.init();
            Application.runApplication(commandLineOptions, false, null);
        }
    }

    public static synchronized void runApplicationInProcess(String applicationId, String[] arguments, boolean dialog, Window parentWindow) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(applicationId);
        if (arguments == null) {
            arguments = new String[]{};
        }
        ArrayList<String> allArguments = new ArrayList<String>();
        StringUtil.splitupCommandLine(allArguments, InstallerConfig.getCurrentApplication().getArguments());
        allArguments.addAll(Arrays.asList(arguments));
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(allArguments.toArray(new String[0]));
        Runnable runnable = () -> {
            try {
                Application.runApplication(commandLineOptions, dialog, parentWindow);
            }
            finally {
                UpdateLog.setUpdaterApplication(false);
            }
        };
        CustomApplication customApplication = Application.getCustomApplication();
        if (customApplication != null && customApplication.isSingleInstance() && customApplication.isCreateExecutable()) {
            if (!SingleInstance.checkInProcessAndRun(Application.getExeFile(customApplication), runnable)) {
                InstallerUtil.exit(0);
            }
        } else {
            runnable.run();
        }
    }

    private static void runApplication(InstallerUtil.CommandLineOptions commandLineOptions, boolean dialog, Window parentWindow) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(commandLineOptions, dialog, parentWindow);
            Application.initInstallationDirectory();
            new Controller(screenExecutor, commandLineOptions).start();
        }
        catch (Throwable t) {
            Util.fatalError(t);
        }
    }

    static void initInstallationDirectory() {
        File bundleDirectory;
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File runtimeDir = ResourceHelper.getRuntimeDir();
        File installationDirectory = new File(runtimeDir, "..");
        if (Util.isMacOS() && config.getMacSpecificConfig().isSingleBundle() && (bundleDirectory = MacLauncher.getSingleBundleDirectory()) != null) {
            installationDirectory = bundleDirectory.getParentFile();
        }
        config.setInstallationDirectory(FileUtil.getCanonicalFile(installationDirectory));
    }

    @Nullable
    public static File getExeFile(ApplicationWithPath application) {
        File executableDir;
        if (application instanceof CustomApplication && !((CustomApplication)application).isCreateExecutable()) {
            return null;
        }
        File execDir = Application.getExecutableDir(application);
        File execFile = new File(execDir, application.getExecutableName() + (Util.isWindows() ? ".exe" : ""));
        if (!execFile.exists() && Util.isMacOS() && (executableDir = new File(execFile.getAbsolutePath() + ".app")).isDirectory()) {
            execFile = executableDir;
        }
        try {
            return execFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return execFile;
        }
    }

    @Nullable
    private static File getExecutableDir(ApplicationWithPath application) {
        File execDir = application.getExecutableDirectory();
        if (execDir == null || execDir.getPath().trim().isEmpty()) {
            return ResourceHelper.getRuntimeDir();
        }
        return new File(ResourceHelper.getRuntimeDir(), "../" + execDir.getPath());
    }

    private static CustomApplication getCustomApplication() {
        com.install4j.runtime.beans.applications.Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof CustomApplication) {
            return (CustomApplication)application;
        }
        return null;
    }
}

