/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class MachoHelper {
    public static final int FAT_MAGIC = -889275714;
    public static final int FAT_CIGAM = -1095041334;
    public static int MH_MAGIC = -17958194;
    public static int MH_CIGAM = -822415874;
    public static int MH_MAGIC_64 = -17958193;
    public static int MH_CIGAM_64 = -805638658;

    public static boolean isThinMagic(int magic) {
        return magic == MH_MAGIC || magic == MH_CIGAM || magic == MH_MAGIC_64 || magic == MH_CIGAM_64;
    }

    public static boolean isFatMagic(int magic) {
        return magic == -889275714 || magic == -1095041334;
    }

    public static boolean isAnyMacho(InputStream inputStream) {
        try {
            DataInputStream in = new DataInputStream(inputStream);
            int magic = in.readInt();
            return MachoHelper.isFatMagic(magic) || MachoHelper.isThinMagic(magic);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isAnyMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = MachoHelper.isFatMagic(magic) || MachoHelper.isThinMagic(magic);
                return bl;
            }
        }
        return false;
    }

    public static boolean isFatMacho(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) > 4L) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
                int magic = in.readInt();
                boolean bl = MachoHelper.isFatMagic(magic);
                return bl;
            }
        }
        return false;
    }
}

