/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.searchfield.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.searchfield.JYFormattedSearchField;
import de.javasoft.searchfield.JYSearchField;
import de.javasoft.searchfield.ui.controls.ButtonFactory;
import de.javasoft.searchfield.ui.controls.IButtonFactory;
import de.javasoft.searchfield.ui.controls.SearchActionEvent;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.textfield.ui.BasicJYTextFieldUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicJYSearchFieldUI
extends BasicJYTextFieldUI {
    private IButtonFactory buttonFactory;
    private SearchDelayThread searchDelayThread;
    private KeyListener returnKeyListener;

    @Override
    protected String getPropertyPrefix() {
        return this.getComponent() instanceof JYFormattedSearchField ? "FormattedTextField" : "TextField";
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYSearchFieldUI();
    }

    @Override
    protected void installDefaults(JComponent c) {
        super.installDefaults(c);
        this.installButtonFactory();
        JYSearchField searchField = (JYSearchField)c;
        if (searchField.searchPopupButtonEnabledIsUIResource()) {
            Boolean enabled = SyntheticaLookAndFeel.getBoolean((String)"JYSearchField.searchPopupButton.enabled", (Component)c);
            searchField.setSearchPopupButtonEnabled(enabled, true);
        }
        this.installSearchButton(searchField, searchField.getSearchAction(), false);
        this.installDeleteButton(searchField);
        if (searchField.showSearchButtonIsUIResource()) {
            Boolean visible = SyntheticaLookAndFeel.getBoolean((String)"JYSearchField.showSearchButton", (Component)c, (boolean)true);
            searchField.setShowSearchButton(visible, true);
        }
        if (searchField.searchControlsPositionIsUIResource()) {
            String position = SyntheticaLookAndFeel.getString((String)"JYSearchField.searchControlsPosition", (Component)c);
            if (position == null) {
                position = JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING.name();
            }
            searchField.setSearchControlsPosition(JYSearchField.SearchControlsPosition.valueOf(position), true);
        }
        if (searchField.searchModeIsUIResource()) {
            String mode = SyntheticaLookAndFeel.getString((String)"JYSearchField.searchMode", (Component)c);
            if (mode == null) {
                mode = JYSearchField.SearchMode.MANUAL.name();
            }
            searchField.setSearchMode(JYSearchField.SearchMode.valueOf(mode), true);
        }
        if (searchField.searchDelayIsUIResource()) {
            int delay = SyntheticaLookAndFeel.getInt((String)"JYSearchField.searchDelay", (Component)c, (int)400);
            searchField.setSearchDelay(delay, true);
        }
        if (searchField.promptTextIsUIResource()) {
            String prompt = SyntheticaLookAndFeel.getString((String)"JYSearchField.promptText", (Component)c);
            if (prompt == null) {
                prompt = "";
            }
            searchField.setPromptText(prompt, true);
        }
        searchField.getInputMap().put(KeyStroke.getKeyStroke(40, 512), "openPopup");
        searchField.getActionMap().put("openPopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JYSearchField searchField = (JYSearchField)evt.getSource();
                AbstractButton button = BasicJYSearchFieldUI.this.getSearchButton(searchField);
                if (button instanceof SimpleDropDownButton) {
                    button.getActionMap().get("openPopup").actionPerformed(new ActionEvent(searchField, 1001, evt.getActionCommand(), evt.getWhen(), evt.getModifiers()));
                }
            }
        });
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        JYSearchField searchField = (JYSearchField)this.getComponent();
        JPanel p = this.getDeleteButtonPanel(searchField);
        p.remove(this.getDeleteButton(searchField));
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.returnKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\n') {
                    JYSearchField sf = (JYSearchField)evt.getSource();
                    if (BasicJYSearchFieldUI.this.searchDelayThread != null) {
                        BasicJYSearchFieldUI.this.searchDelayThread.interrupt();
                        BasicJYSearchFieldUI.this.searchDelayThread = null;
                    }
                    BasicJYSearchFieldUI.this.fireSearchAction(sf);
                }
            }
        };
        this.getComponent().addKeyListener(this.returnKeyListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeKeyListener(this.returnKeyListener);
    }

    private void installButtonFactory() {
        String className = SyntheticaLookAndFeel.getString((String)"JYSearchField.buttonFactory.className", (Component)this.getComponent());
        if (className == null) {
            this.buttonFactory = new ButtonFactory();
        } else {
            try {
                this.buttonFactory = (IButtonFactory)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void installSearchButton(JYSearchField searchField, Action searchAction, boolean forceInstall) {
        AbstractButton button = this.getSearchButton(searchField);
        boolean isPopupButton = button instanceof SimpleDropDownButton;
        boolean shouldBePopupButton = searchField.getSearchPopupButtonEnabled();
        if (button == null || !isPopupButton && shouldBePopupButton || isPopupButton && !shouldBePopupButton || button.getAction() != searchAction || forceInstall) {
            if (button != null) {
                button.getParent().remove(button);
            }
            JPanel p = this.getSearchButtonPanel(searchField);
            if (shouldBePopupButton) {
                p.add(this.buttonFactory.createSearchPopupButton(searchField, searchAction));
            } else {
                p.add(this.buttonFactory.createSearchButton(searchField, searchAction), null, p.getComponentCount());
            }
        }
    }

    private AbstractButton getSearchButton(JYSearchField searchField) {
        ArrayList list = new ArrayList();
        SyntheticaLookAndFeel.findComponents(AbstractButton.class, (Container)searchField, list);
        for (AbstractButton b : list) {
            if (b.getName() == null || !b.getName().contains("JYSearchField.SearchButton")) continue;
            return b;
        }
        return null;
    }

    private AbstractButton getDeleteButton(JYSearchField searchField) {
        return (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"JYSearchField.DeleteButton", (Container)searchField);
    }

    private JPanel getSearchButtonPanel(JYSearchField searchField) {
        return searchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING ? searchField.getLeadingPanel() : searchField.getTrailingPanel();
    }

    private JPanel getDeleteButtonPanel(JYSearchField searchField) {
        return searchField.getSearchControlsPosition() == JYSearchField.SearchControlsPosition.SEARCH_LEADING_CLEAR_TRAILING ? searchField.getTrailingPanel() : searchField.getLeadingPanel();
    }

    private void installDeleteButton(final JYSearchField searchField) {
        AbstractButton button = this.getDeleteButton(searchField);
        if (button != null) {
            button.getParent().remove(button);
        }
        this.getDeleteButtonPanel(searchField).add(this.buttonFactory.createDeleteButton(searchField, new AbstractAction(){
            private static final long serialVersionUID = 3382162676275722429L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                searchField.setText("");
                if (BasicJYSearchFieldUI.this.searchDelayThread != null) {
                    BasicJYSearchFieldUI.this.searchDelayThread.interrupt();
                    BasicJYSearchFieldUI.this.searchDelayThread = null;
                }
                BasicJYSearchFieldUI.this.fireSearchAction(evt.getSource());
            }
        }), null, 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        JYSearchField c = (JYSearchField)evt.getSource();
        String name = evt.getPropertyName();
        if ("documentLength".equals(name)) {
            this.getDeleteButton(c).setVisible((Integer)evt.getNewValue() != 0);
            if (c.getSearchMode() == JYSearchField.SearchMode.AUTO && c.getSearchDelay() > 0) {
                if (this.searchDelayThread != null && !this.searchDelayThread.isInterrupted()) {
                    this.searchDelayThread.interrupt();
                }
                this.searchDelayThread = new SearchDelayThread(c.getSearchDelay(), c.getSearchAction());
                this.searchDelayThread.start();
            }
        } else if ("searchPopupButtonEnabled".equals(name) || "searchAction".equals(name)) {
            this.installSearchButton(c, "searchAction".equals(name) ? (Action)evt.getNewValue() : c.getSearchAction(), false);
        } else if ("showSearchButton".equals(name)) {
            this.getSearchButton(c).setVisible((Boolean)evt.getNewValue());
        } else if ("searchPopup".equals(name)) {
            AbstractButton searchButton = this.getSearchButton(c);
            if (searchButton instanceof SimpleDropDownButton) {
                ((SimpleDropDownButton)searchButton).setPopupMenu((JPopupMenu)evt.getNewValue());
            }
        } else if ("searchControlsPosition".equals(name)) {
            AbstractButton searchButton = this.getSearchButton(c);
            this.installSearchButton(c, searchButton.getAction(), true);
            this.installDeleteButton(c);
        }
    }

    private void fireSearchAction(Object initiator) {
        JYSearchField searchField = (JYSearchField)this.getComponent();
        Action a = searchField.getSearchAction();
        if (a != null) {
            SearchActionEvent.Initiator intr = SearchActionEvent.Initiator.SEARCH_FIELD;
            if (initiator instanceof Runnable) {
                intr = SearchActionEvent.Initiator.AUTO_SEARCH;
            } else if (initiator instanceof AbstractButton) {
                intr = SearchActionEvent.Initiator.CLEAR_BUTTON;
            }
            a.actionPerformed(new SearchActionEvent(searchField, 1001, null, System.currentTimeMillis(), 0, intr));
        }
    }

    private class SearchDelayThread
    extends Thread {
        private int delay;
        private Action action;

        public SearchDelayThread(int delay, Action a) {
            this.delay = delay;
            this.action = a;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                SearchDelayThread.sleep(this.delay);
                if (this.action != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!SearchDelayThread.this.isInterrupted()) {
                                if (BasicJYSearchFieldUI.this.getComponent() != null) {
                                    BasicJYSearchFieldUI.this.fireSearchAction(this);
                                }
                                BasicJYSearchFieldUI.this.searchDelayThread = null;
                            }
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

