/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.controls;

import de.javasoft.button.JYButton;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import de.javasoft.tabpane.ui.controls.IButtonFactory;
import de.javasoft.tabpane.ui.controls.ICloseButtonStrategy;
import de.javasoft.tabpane.ui.controls.Tab;
import de.javasoft.tabpane.ui.controls.TabOverviewPreviewPanel;
import de.javasoft.widgets.JYButtonIcon;
import de.javasoft.widgets.JYPopupMenu;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.synth.SynthContext;

public class ButtonFactory
implements IButtonFactory,
SwingConstants {
    private Icon scrollIconLeft;
    private Icon scrollIconRight;
    private Icon scrollIconUp;
    private Icon scrollIconDown;
    private Icon plusIcon;

    @Override
    public JButton createCloseTabButton(final JYTabbedPane tabPane, final Tab tab, Action a) {
        JYButton b = new JYButton(a){
            private static final long serialVersionUID = 8203468458830011176L;

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public boolean isEnabled() {
                return tab.isEnabled();
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setCloseTabButtonDefaults(this, tabPane, tab);
            }
        };
        b.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = 8214819089269580673L;

            @Override
            public boolean isEnabled() {
                return tab.isEnabled();
            }

            @Override
            public boolean isSelected() {
                return tab.isSelected();
            }
        });
        b.setRotation(((BasicJYTabbedPaneUI)tabPane.getUI()).placementToRotation(tabPane.getTabPlacement()));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        b.setVisible(false);
        b.setFocusable(false);
        b.setName("JYTabbedPane.CloseButton");
        String style = (String)tabPane.getClientProperty("Synthetica.style");
        b.putClientProperty("Synthetica.style", style == null ? tabPane.getName() : style);
        this.setCloseTabButtonDefaults(b, tabPane, tab);
        return b;
    }

    protected void setCloseTabButtonDefaults(AbstractButton b, JYTabbedPane tabPane, Tab tab) {
        b.setToolTipText(UIManager.getString("JYTabbedPane.closeButton.toolTip"));
        b.setIcon(this.createCloseIcon(b, tabPane, tab));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tab.closeButton.insets", (Component)b, (boolean)false);
        b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    private Icon createCloseIcon(AbstractButton b, final JYTabbedPane tabPane, final Tab tab) {
        return new JYButtonIcon(b, "JYTabbedPane.tab.closeButton.icon", 10, 10){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getClosePaintColor(state));
                GeneralPath path = new GeneralPath();
                path.moveTo(3.0f, 2.0f);
                path.lineTo(8.0f, 7.0f);
                path.moveTo(8.0f, 2.0f);
                path.lineTo(3.0f, 7.0f);
                g2.draw(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (tabPane.isEnabledAt(tab.getTabIndex()) ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public SimpleDropDownButton createPopupButton(final JYTabbedPane tabPane) {
        SimpleDropDownButton b = new SimpleDropDownButton(){
            private static final long serialVersionUID = 1437991807270111435L;

            public float getAlignmentX() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(true);
            }

            public float getAlignmentY() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(false);
            }

            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            protected JPopupMenu createPopupMenu() {
                JYPopupMenu popup = new JYPopupMenu();
                popup.setName("JYTabbedPane.PopupMenu");
                return popup;
            }

            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setPopupButtonDefaults((AbstractButton)((Object)this), tabPane);
            }
        };
        b.setArrowVisible(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        b.setName("JYTabbedPane.PopupButton");
        this.setPopupButtonDefaults((AbstractButton)b, tabPane);
        return b;
    }

    protected void setPopupButtonDefaults(AbstractButton b, JYTabbedPane tabPane) {
        b.setToolTipText(UIManager.getString("JYTabbedPane.popupButton.toolTip"));
        b.setIcon(this.createPopupIcon(b, tabPane));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.popupButton.insets", (Component)b, (Insets)new Insets(4, 4, 4, 4));
        b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    private Icon createPopupIcon(AbstractButton b, final JYTabbedPane tabPane) {
        return new JYButtonIcon(b, "JYTabbedPane.popupButton.icon", 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getPopupPaintColor(state));
                boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
                GeneralPath path = new GeneralPath();
                if (ltr) {
                    path.moveTo(0.0f, 1.0f);
                    path.lineTo(3.0f, 3.0f);
                    path.lineTo(0.0f, 5.0f);
                    path.moveTo(4.0f, 1.0f);
                    path.lineTo(7.0f, 3.0f);
                    path.lineTo(4.0f, 5.0f);
                } else {
                    path.moveTo(11.0f, 1.0f);
                    path.lineTo(8.0f, 3.0f);
                    path.lineTo(11.0f, 5.0f);
                    path.moveTo(7.0f, 1.0f);
                    path.lineTo(4.0f, 3.0f);
                    path.lineTo(7.0f, 5.0f);
                }
                g2.draw(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (tabPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public JButton createScrollForwardButton(JYTabbedPane tabPane, Action a) {
        return this.createScrollButton(tabPane, a, true);
    }

    @Override
    public JButton createScrollBackwardButton(JYTabbedPane tabPane, Action a) {
        return this.createScrollButton(tabPane, a, false);
    }

    private JButton createScrollButton(final JYTabbedPane tabPane, Action a, final boolean forward) {
        JButton b = new JButton(a){
            private static final long serialVersionUID = 6140418110240325555L;

            @Override
            public float getAlignmentX() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(true);
            }

            @Override
            public float getAlignmentY() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(false);
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public Icon getIcon() {
                boolean ltr = tabPane.getComponentOrientation().isLeftToRight();
                int placement = tabPane.getTabPlacement();
                if (placement == 1 || placement == 3) {
                    if (ltr && forward || !ltr && !forward) {
                        return ButtonFactory.this.scrollIconRight;
                    }
                    return ButtonFactory.this.scrollIconLeft;
                }
                return forward ? ButtonFactory.this.scrollIconDown : ButtonFactory.this.scrollIconUp;
            }

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setScrollButtonDefaults(this, tabPane, forward);
            }
        };
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        if (forward) {
            b.setName("JYTabbedPane.ScrollForwardButton");
        } else {
            b.setName("JYTabbedPane.ScrollBackwardButton");
        }
        this.setScrollButtonDefaults(b, tabPane, forward);
        return b;
    }

    protected void setScrollButtonDefaults(AbstractButton b, JYTabbedPane tabPane, boolean forward) {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.scrollButton.insets", (Component)b, (Insets)new Insets(4, 4, 4, 4));
        b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        if (forward) {
            b.setToolTipText(UIManager.getString("JYTabbedPane.scrollButton.forward.toolTip"));
            this.scrollIconRight = this.getScrollIcon(b, tabPane, "right");
            this.scrollIconDown = this.getScrollIcon(b, tabPane, "down");
        } else {
            b.setToolTipText(UIManager.getString("JYTabbedPane.scrollButton.backward.toolTip"));
            this.scrollIconLeft = this.getScrollIcon(b, tabPane, "left");
            this.scrollIconUp = this.getScrollIcon(b, tabPane, "up");
        }
    }

    protected Icon getScrollIcon(AbstractButton b, final JYTabbedPane tabPane, String direction) {
        String key = "JYTabbedPane.scrollButton.icon." + direction;
        return new JYButtonIcon(b, key, 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getScrollPaintColor(state));
                GeneralPath path = new GeneralPath();
                String direction = this.getUIKey().split("\\.")[3];
                if (direction.equals("left")) {
                    path.moveTo(9.0f, 2.0f);
                    path.lineTo(2.0f, 5.5f);
                    path.lineTo(9.0f, 9.0f);
                } else if (direction.equals("right")) {
                    path.moveTo(2.0f, 2.0f);
                    path.lineTo(9.0f, 5.5f);
                    path.lineTo(2.0f, 9.0f);
                } else if (direction.equals("up")) {
                    path.moveTo(2.0f, 9.0f);
                    path.lineTo(5.5f, 2.0f);
                    path.lineTo(9.0f, 9.0f);
                } else if (direction.equals("down")) {
                    path.moveTo(2.0f, 2.0f);
                    path.lineTo(5.5f, 9.0f);
                    path.lineTo(9.0f, 2.0f);
                }
                g2.fill(path);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + tabPane.getTabPlacement();
                hash = 31 * hash + (tabPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public JButton createPlusButton(final JYTabbedPane tabPane, Action a) {
        JYButton b = new JYButton(a){
            private static final long serialVersionUID = -8491794353997273950L;

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public Icon getIcon() {
                return ButtonFactory.this.plusIcon;
            }

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setPlusButtonDefaults(this, tabPane);
            }
        };
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setFocusable(false);
        b.setName("JYTabbedPane.PlusButton");
        this.setPlusButtonDefaults(b, tabPane);
        return b;
    }

    protected void setPlusButtonDefaults(AbstractButton b, JYTabbedPane tabPane) {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.plusButton.insets", (Component)b, (Insets)new Insets(4, 4, 4, 4));
        b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
        this.plusIcon = this.createPlusIcon(b, tabPane);
    }

    private Icon createPlusIcon(AbstractButton b, final JYTabbedPane tabPane) {
        String key = "JYTabbedPane.plusButton.icon";
        return new JYButtonIcon(b, key, 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                state.resetState(SyntheticaState.State.HOVER);
                g2.setPaint(ButtonFactory.this.getPlusPaintColor(state));
                GeneralPath path = new GeneralPath();
                path.moveTo(5.5, 2.0);
                path.lineTo(5.5, 9.0);
                path.moveTo(2.0, 5.5);
                path.lineTo(9.0, 5.5);
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.2f);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + tabPane.getTabPlacement();
                hash = 31 * hash + (tabPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public JButton createTabOverviewButton(final JYTabbedPane tabPane, Action a) {
        JYButton b = new JYButton(a){
            private static final long serialVersionUID = 8868341008465347207L;

            @Override
            public float getAlignmentX() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(true);
            }

            @Override
            public float getAlignmentY() {
                return ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabControlsAlignment(false);
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setOverviewButtonDefaults(this, tabPane);
            }
        };
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setFocusable(false);
        b.setName("JYTabbedPane.TabOverviewButton");
        this.setOverviewButtonDefaults(b, tabPane);
        return b;
    }

    protected void setOverviewButtonDefaults(AbstractButton b, JYTabbedPane tabPane) {
        b.setToolTipText(UIManager.getString("JYTabbedPane.tabOverviewButton.toolTip"));
        b.setIcon(this.createOverviewIcon(b, tabPane));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverviewButton.insets", (Component)b, (Insets)new Insets(4, 4, 4, 4));
        b.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    private Icon createOverviewIcon(AbstractButton b, final JYTabbedPane tabPane) {
        String key = "JYTabbedPane.tabOverviewButton.icon";
        return new JYButtonIcon(b, key, 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getOverviewPaintColor(state));
                float yOffset = 0.5f;
                g2.fill(new GeneralPath(new Ellipse2D.Float(3.25f, 3.25f + yOffset, 4.5f, 4.5f)));
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, 2.0f + yOffset);
                path.curveTo(0.0, (double)(2.0f + yOffset), 5.5, (double)(-2.0f + yOffset), 11.0, (double)(2.0f + yOffset));
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.2f);
            }

            public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
                int hash = super.getCacheHash(sc, w, h, meta, id);
                hash = 31 * hash + (tabPane.getComponentOrientation().isLeftToRight() ? 0 : 1);
                return hash;
            }
        };
    }

    @Override
    public AbstractButton createTabOverviewPreviewCloseButton(final JYTabbedPane tabPane, final int tabIndex, Action a) {
        final JButton b = new JButton(a){
            private static final long serialVersionUID = 2356730929509185601L;

            @Override
            public Icon getDisabledIcon() {
                return this.getIcon();
            }

            @Override
            public String getToolTipText(MouseEvent evt) {
                return (String)this.getAction().getValue("ShortDescription");
            }

            @Override
            public void updateUI() {
                super.updateUI();
                ButtonFactory.this.setTabOverviewPreviewCloseButtonDefaults(this);
            }
        };
        b.setModel(new DefaultButtonModel(){
            private static final long serialVersionUID = -5425424017921655032L;

            @Override
            public boolean isEnabled() {
                return tabIndex < tabPane.getTabCount() ? tabPane.isEnabledAt(tabIndex) : true;
            }

            @Override
            public boolean isSelected() {
                TabOverviewPreviewPanel pp = (TabOverviewPreviewPanel)SwingUtilities.getAncestorOfClass(TabOverviewPreviewPanel.class, b);
                return pp == null ? false : pp.getState().isSet(SyntheticaState.State.HOVER);
            }
        });
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setContentAreaFilled(false);
        Boolean visible = (Boolean)SyntheticaLookAndFeel.get((String)"JYTabbedPane.tabOverview.previewCloseButton.visible", (Component)tabPane);
        if (visible == null) {
            ICloseButtonStrategy strategy = tabPane.getCloseButtonStrategy();
            Tab tab = ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabsPanel().getTab(tabIndex);
            visible = strategy.isButtonVisible(tabPane, tab, true);
        }
        b.setVisible(visible);
        b.setFocusable(false);
        b.setName("JYTabbedPane.TabOverviewPreviewCloseButton");
        MouseAdapter redispatcher = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                this.dispatchMouseEvent(evt);
            }

            private void dispatchMouseEvent(MouseEvent evt) {
                Container parent = evt.getComponent().getParent().getParent();
                parent.dispatchEvent(SwingUtilities.convertMouseEvent(evt.getComponent(), evt, parent));
            }
        };
        b.addMouseListener(redispatcher);
        b.addMouseMotionListener(redispatcher);
        this.setTabOverviewPreviewCloseButtonDefaults(b);
        return b;
    }

    private void setTabOverviewPreviewCloseButtonDefaults(AbstractButton b) {
        b.setIcon(this.createTabOverviewPreviewCloseIcon(b));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverview.previewCloseButton.insets", (Component)b, (Insets)new Insets(0, 2, 0, 0), (boolean)true);
        b.setBorder(new WidgetUtils.OrientationAwareEmptyBorderUIResource(insets));
    }

    private Icon createTabOverviewPreviewCloseIcon(AbstractButton b) {
        return new JYButtonIcon(b, "JYTabbedPane.tabOverview.previewCloseButton.icon", 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(ButtonFactory.this.getClosePaintColor(state));
                GeneralPath path = new GeneralPath();
                path.moveTo(2.0f, 2.0f);
                path.lineTo(9.0f, 9.0f);
                path.moveTo(9.0f, 2.0f);
                path.lineTo(2.0f, 9.0f);
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.5f);
            }
        };
    }

    protected Color getPopupPaintColor(SyntheticaState state) {
        return this.getPaintColor(state);
    }

    protected Color getScrollPaintColor(SyntheticaState state) {
        return this.getPaintColor(state);
    }

    protected Color getPlusPaintColor(SyntheticaState state) {
        return this.getPaintColor(state);
    }

    protected Color getOverviewPaintColor(SyntheticaState state) {
        return this.getPaintColor(state);
    }

    protected Color getClosePaintColor(SyntheticaState state) {
        Color color = UIManager.getColor("Label.foreground");
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xA0A0A0);
        } else if (state.isSet(SyntheticaState.State.PRESSED)) {
            color = new Color(0x606060);
        } else if (state.isSet(SyntheticaState.State.HOVER)) {
            color = new Color(0xE70000);
        }
        return color;
    }

    private Color getPaintColor(SyntheticaState state) {
        Color color = Color.BLACK;
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!state.isSet(SyntheticaState.State.PRESSED) && state.isSet(SyntheticaState.State.HOVER)) {
            color = new Color(0x606060);
        }
        return color;
    }
}

