/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.textfield;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.textfield.IFormattedField;
import de.javasoft.textfield.ui.JYTextFieldUI;
import de.javasoft.textfield.ui.addons.JYTextFieldAddon;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.text.Document;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JYTextField
extends JFormattedTextField
implements IUIPropertySupport {
    private static final long serialVersionUID = -5577666471656177619L;
    public static final String uiClassID = "JYTextFieldUI";
    private boolean emptyFieldCommittedAsNullValue;
    private JPanel leadingPanel;
    private JPanel trailingPanel;
    private UIValue<String> promptText;
    private UIValue<Color> promptForeground;
    private UIValue<Integer> promptAlignment;
    private UIValue<PromptStrategy> promptStrategy;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTextFieldAddon());
        if (UIManager.get("TextField.actionMap") == null) {
            // empty if block
        }
        new JTextField();
    }

    public JYTextField() {
        this((String)null);
    }

    public JYTextField(String text) {
        this(text, 0);
    }

    public JYTextField(int columns) {
        this((String)null, columns);
    }

    public JYTextField(String text, int columns) {
        this.setText(text);
        this.setColumns(columns);
    }

    @Override
    public Font getFont() {
        Font f = super.getFont();
        return f != null ? f : WidgetUtils.getDefaultFont();
    }

    @Override
    protected void processFocusEvent(FocusEvent evt) {
        ArrayList<PropertyChangeListener> list = new ArrayList<PropertyChangeListener>();
        if (!this.isFormattedTextField()) {
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            int n = propertyChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener l = propertyChangeListenerArray[n2];
                this.removePropertyChangeListener(l);
                list.add(l);
                ++n2;
            }
        }
        super.processFocusEvent(evt);
        if (!this.isFormattedTextField()) {
            for (PropertyChangeListener l : list) {
                this.addPropertyChangeListener(l);
            }
        }
    }

    private boolean isFormattedTextField() {
        boolean formatSupport = this instanceof IFormattedField || this.getFormatter() != null;
        return formatSupport;
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.update(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.update(evt);
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.update(evt);
            }

            private void update(DocumentEvent evt) {
                JYTextField.this.firePropertyChange("documentLength", -1, evt.getDocument().getLength());
            }
        });
    }

    @Override
    public void setMargin(Insets m) {
        super.setMargin(m);
        Border border = this.getBorder();
        if (border instanceof MarginBorder) {
            if (m == null) {
                this.setBorder(((MarginBorder)border).getOutsideBorder());
            } else {
                ((MarginBorder)border).setInsideBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(m, false));
            }
        } else if (m != null && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            this.setBorder(new MarginBorder(border, SyntheticaLookAndFeel.getInstance().createEmptyBorder(m, false)));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, JYTextFieldUI.class));
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
        Insets i = this.getInsets();
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        i.left = i.left + (ltr ? this.leadingPanel.getPreferredSize().width : this.trailingPanel.getPreferredSize().width);
        i.right = i.right + (ltr ? this.trailingPanel.getPreferredSize().width : this.leadingPanel.getPreferredSize().width);
        BoundedRangeModel visibility = this.getHorizontalVisibility();
        int x0 = r.x + visibility.getValue() - i.left;
        int x1 = x0 + r.width;
        if (x0 < visibility.getValue()) {
            visibility.setValue(x0);
        } else if (x1 > visibility.getValue() + visibility.getExtent()) {
            visibility.setValue(x1 - visibility.getExtent());
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr instanceof BorderLayout) {
            super.setLayout(mgr);
        }
    }

    public JPanel getLeadingPanel() {
        if (this.leadingPanel == null) {
            this.leadingPanel = new JPanel();
            this.leadingPanel.setOpaque(false);
            this.leadingPanel.setLayout(new BoxLayout(this.leadingPanel, 2));
        }
        return this.leadingPanel;
    }

    public JPanel getTrailingPanel() {
        if (this.trailingPanel == null) {
            this.trailingPanel = new JPanel();
            this.trailingPanel.setOpaque(false);
            this.trailingPanel.setLayout(new BoxLayout(this.trailingPanel, 2));
        }
        return this.trailingPanel;
    }

    public void addLeadingComponent(JComponent c) {
        this.getLeadingPanel().add(c);
        this.initComponent(c);
        this.revalidate();
    }

    public void addTrailingComponent(JComponent c) {
        this.getTrailingPanel().add(c, null, 0);
        this.initComponent(c);
        this.revalidate();
    }

    protected void initComponent(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
    }

    public void setEmptyFieldCommittedAsNullValue(boolean b) {
        this.emptyFieldCommittedAsNullValue = b;
    }

    public boolean isEmptyFieldCommittedAsNullValue() {
        return this.emptyFieldCommittedAsNullValue;
    }

    @Override
    public void commitEdit() throws ParseException {
        String text = this.getText();
        if (this.isEmptyFieldCommittedAsNullValue() && text != null && text.length() == 0) {
            this.setValue(null);
        } else {
            super.commitEdit();
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setPromptText(String prompt) {
        this.setPromptText(prompt, false);
    }

    public void setPromptText(String prompt, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "promptText", this.promptText, this.getPromptText(), prompt, isUIResource, false, false);
    }

    public boolean promptTextIsUIResource() {
        return this.getPromptTextUIValue().isUIResource();
    }

    public String getPromptText() {
        return this.getPromptTextUIValue().get();
    }

    private UIValue<String> getPromptTextUIValue() {
        if (this.promptText == null) {
            this.promptText = new UIValue();
        }
        return this.promptText;
    }

    public void setPromptForeground(Color color) {
        this.setPromptForeground(color, false);
    }

    public void setPromptForeground(Color color, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "promptForeground", this.promptForeground, this.getPromptForeground(), color, isUIResource, false, false);
    }

    public boolean promptForegroundIsUIResource() {
        return this.getPromptForegroundUIValue().isUIResource();
    }

    public Color getPromptForeground() {
        return this.getPromptForegroundUIValue().get();
    }

    private UIValue<Color> getPromptForegroundUIValue() {
        if (this.promptForeground == null) {
            this.promptForeground = new UIValue();
        }
        return this.promptForeground;
    }

    public void setPromptAlignment(Integer alignment) {
        this.setPromptAlignment(alignment, false);
    }

    public void setPromptAlignment(Integer alignment, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "promptAlignment", this.promptAlignment, this.getPromptAlignment(), alignment, isUIResource, false, false);
    }

    public boolean promptAlignmentIsUIResource() {
        return this.getPromptAlignmentUIValue().isUIResource();
    }

    public Integer getPromptAlignment() {
        return this.getPromptAlignmentUIValue().get();
    }

    private UIValue<Integer> getPromptAlignmentUIValue() {
        if (this.promptAlignment == null) {
            this.promptAlignment = new UIValue();
        }
        return this.promptAlignment;
    }

    public void setPromptStrategy(PromptStrategy strategy) {
        this.setPromptStrategy(strategy, false);
    }

    public void setPromptStrategy(PromptStrategy strategy, boolean isUIResource) {
        WidgetUtils.setUIProperty(this, "promptStrategy", this.promptStrategy, this.getPromptStrategy(), strategy, isUIResource, true, true);
    }

    public boolean promptStrategyIsUIResource() {
        return this.getPromptStrategyUIValue().isUIResource();
    }

    public PromptStrategy getPromptStrategy() {
        return this.getPromptStrategyUIValue().get();
    }

    private UIValue<PromptStrategy> getPromptStrategyUIValue() {
        if (this.promptStrategy == null) {
            this.promptStrategy = new UIValue();
        }
        return this.promptStrategy;
    }

    private static class MarginBorder
    extends CompoundBorder {
        private static final long serialVersionUID = -5681276157290014600L;

        public MarginBorder(Border outside, Border inside) {
            super(outside, inside);
        }

        public void setInsideBorder(Border border) {
            this.insideBorder = border;
        }
    }

    public static enum PromptStrategy {
        NO_TEXT_AND_NO_FOCUS,
        NO_TEXT;

    }
}

