/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.textfield.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.textfield.JYFormattedTextField;
import de.javasoft.textfield.JYPasswordField;
import de.javasoft.textfield.JYTextField;
import de.javasoft.textfield.ui.JYTextFieldUI;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BasicJYTextFieldUI
extends JYTextFieldUI {
    private JLabel promptLabel;
    private FocusListener focusListener;
    static char[] ONE = new char[1];

    @Override
    protected String getPropertyPrefix() {
        return this.getComponent() instanceof JYFormattedTextField ? "FormattedTextField" : "TextField";
    }

    @Override
    public View create(Element elem) {
        return this.getComponent() instanceof JYPasswordField ? new JYPasswordView(elem) : super.create(elem);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installComponents(c);
        this.installDefaults(c);
    }

    protected void installComponents(JComponent c) {
    }

    protected void installDefaults(JComponent c) {
        c.setLayout(new BorderLayout());
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                JYTextField c = (JYTextField)BasicJYTextFieldUI.this.getComponent();
                if (c != null && c.getPromptStrategy() == JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS && c.getDocument().getLength() == 0) {
                    BasicJYTextFieldUI.this.promptLabel.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JYTextField c = (JYTextField)BasicJYTextFieldUI.this.getComponent();
                if (c != null && c.getPromptStrategy() == JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS && c.getDocument().getLength() == 0) {
                    BasicJYTextFieldUI.this.promptLabel.setText(c.getPromptText());
                }
            }
        };
        c.addFocusListener(this.focusListener);
        JPanel leadingPanel = ((JYTextField)c).getLeadingPanel();
        c.add((Component)leadingPanel, "Before");
        JPanel trailingPanel = ((JYTextField)c).getTrailingPanel();
        c.add((Component)trailingPanel, "After");
        JYTextField textField = (JYTextField)c;
        this.promptLabel = new JLabel();
        this.promptLabel.setFocusable(false);
        textField.add(this.promptLabel);
        if (textField.promptTextIsUIResource()) {
            String prompt = SyntheticaLookAndFeel.getString((String)"JYTextField.promptText", (Component)c);
            if (prompt == null) {
                prompt = "";
            }
            textField.setPromptText(prompt, true);
        }
        this.promptLabel.setText(textField.getDocument().getLength() == 0 ? textField.getPromptText() : "");
        if (textField.promptForegroundIsUIResource()) {
            Color color = SyntheticaLookAndFeel.getColor((String)"JYTextField.promptForeground", (Component)c, (Color)new Color(0xA0A0A0));
            textField.setPromptForeground(color, true);
        } else {
            this.promptLabel.setForeground(textField.getPromptForeground());
        }
        if (textField.promptAlignmentIsUIResource()) {
            textField.setPromptAlignment(SyntheticaLookAndFeel.getInt((String)"JYTextField.promptAlignment", (Component)c, (int)2), true);
        }
        this.promptLabel.setHorizontalAlignment(textField.getPromptAlignment());
        if (textField.promptStrategyIsUIResource()) {
            String strategy = SyntheticaLookAndFeel.getString((String)"JYTextField.promptStrategy", (Component)c);
            if (strategy == null) {
                strategy = JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS.name();
            }
            textField.setPromptStrategy(JYTextField.PromptStrategy.valueOf(strategy), true);
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().removeFocusListener(this.focusListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        JYTextField c = (JYTextField)evt.getSource();
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(evt)) {
            this.installDefaults();
            this.installDefaults(c);
        }
        if ("documentLength".equals(name)) {
            if ((Integer)evt.getNewValue() == 0) {
                this.promptLabel.setText(c.getPromptText());
            } else {
                this.promptLabel.setText("");
            }
        } else if ("promptText".equals(name) && c.getDocument().getLength() == 0) {
            if (c.getPromptStrategy() != JYTextField.PromptStrategy.NO_TEXT_AND_NO_FOCUS || !c.hasFocus()) {
                this.promptLabel.setText((String)evt.getNewValue());
            }
        } else if ("promptForeground".equals(name) && evt.getNewValue() != null) {
            this.promptLabel.setForeground(new Color(((Color)evt.getNewValue()).getRGB()));
        } else if ("promptAlignment".equals(name)) {
            this.promptLabel.setHorizontalAlignment((Integer)evt.getNewValue());
        } else if ("font".equals(name)) {
            this.promptLabel.setFont((Font)evt.getNewValue());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.paint(g, (JYTextField)c);
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent editor = this.getComponent();
        Rectangle alloc = editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            Dimension leading = ((JYTextField)editor).getLeadingPanel().getPreferredSize();
            Dimension trailing = ((JYTextField)editor).getTrailingPanel().getPreferredSize();
            alloc.x = alloc.x + (editor.getComponentOrientation().isLeftToRight() ? leading.width : trailing.width);
            alloc.width -= leading.width + trailing.width;
            return alloc;
        }
        return null;
    }

    protected void paint(Graphics g, JYTextField textField) {
        super.paint(g, textField);
    }

    private class JYPasswordView
    extends PasswordView {
        public JYPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            JYPasswordField pf = (JYPasswordField)this.getContainer();
            g.setColor(pf.isEnabled() ? pf.getForeground() : pf.getDisabledTextColor());
            char echoChar = this.getEchoChar(pf);
            int n = p1 - p0;
            int i = 0;
            while (i < n) {
                x = (int)this.drawEchoCharacter((Graphics2D)g, (float)x, (float)y, echoChar);
                ++i;
            }
            return x;
        }

        @Override
        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            super.drawSelectedText((Graphics2D)g, (float)x, (float)y, p0, p1);
            JYPasswordField pf = (JYPasswordField)this.getContainer();
            char echoChar = this.getEchoChar(pf);
            int n = p1 - p0;
            int i = 0;
            while (i < n) {
                x = (int)this.drawEchoCharacter((Graphics2D)g, (float)x, (float)y, echoChar);
                ++i;
            }
            return x;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            JYPasswordField pf = (JYPasswordField)this.getContainer();
            Rectangle alloc = this.adjustAllocation(a).getBounds();
            int dx = (pos - this.getStartOffset()) * this.getFontMetrics(pf).charWidth(this.getEchoChar(pf));
            alloc.x += dx;
            alloc.width = 1;
            return alloc;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            JYPasswordField pf = (JYPasswordField)this.getContainer();
            Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
            n = ((int)fx - alloc.x) / this.getFontMetrics(pf).charWidth(this.getEchoChar(pf));
            if (n < 0) {
                n = 0;
            } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                n = this.getDocument().getLength() - this.getStartOffset();
            }
            return this.getStartOffset() + n;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JYPasswordField pf = (JYPasswordField)this.getContainer();
                    return this.getFontMetrics(pf).charWidth(this.getEchoChar(pf)) * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }

        private FontMetrics getFontMetrics(JComponent c) {
            return c.getFontMetrics(c.getFont());
        }

        private char getEchoChar(JYPasswordField pf) {
            return pf.getEchoChar();
        }
    }
}

