/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.JYCheckBox;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JYCheckBoxList
extends JList<Object> {
    private CheckBoxSelectionModel checkBoxSelectionModel;
    private boolean checkBoxSelectableByItemClick;
    private boolean mousePressed;
    private Object clickedItem;
    private boolean checkBoxClicked;

    public JYCheckBoxList() {
        this((ListModel<Object>)new AbstractListModel<Object>(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public Object getElementAt(int i) {
                return "No Data Model";
            }
        });
    }

    public JYCheckBoxList(final Object ... listData) {
        this((ListModel<Object>)new AbstractListModel<Object>(){

            @Override
            public int getSize() {
                return listData.length;
            }

            @Override
            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public JYCheckBoxList(ListModel<Object> model) {
        super(model);
        this.setCheckBoxSelectableByItemClick(false);
        this.setCheckBoxSelectionModel(new CheckBoxSelectionModel(this, false));
        CheckBoxRenderer r = this.createCheckBoxRenderer(this.getCellRenderer());
        this.setCellRenderer(r);
        this.addMouseListener(new MouseAdapter(){
            private int size = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(16));

            @Override
            public void mousePressed(MouseEvent evt) {
                JYCheckBoxList.this.mousePressed = true;
                int index = JYCheckBoxList.this.locationToIndex(evt.getPoint());
                if (index >= 0) {
                    JYCheckBoxList.this.clickedItem = JYCheckBoxList.this.getModel().getElementAt(index);
                    Rectangle pathBounds = JYCheckBoxList.this.getCellBounds(index, index);
                    if (pathBounds != null) {
                        pathBounds.x = JYCheckBoxList.this.getComponentOrientation().isLeftToRight() ? (pathBounds.x += JYCheckBoxList.this.getXOffset()) : pathBounds.x + pathBounds.width - JYCheckBoxList.this.getXOffset() - this.size;
                        pathBounds.width = this.size;
                        JYCheckBoxList.this.checkBoxClicked = pathBounds.contains(evt.getPoint());
                    }
                    ((JComponent)evt.getComponent()).repaint(pathBounds);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                int index = JYCheckBoxList.this.locationToIndex(evt.getPoint());
                Rectangle pathBounds = JYCheckBoxList.this.getCellBounds(index, index);
                if (pathBounds != null && !JYCheckBoxList.this.isCheckBoxSelectableByItemClick()) {
                    pathBounds.x = JYCheckBoxList.this.getComponentOrientation().isLeftToRight() ? (pathBounds.x += JYCheckBoxList.this.getXOffset()) : pathBounds.x + pathBounds.width - JYCheckBoxList.this.getXOffset() - this.size;
                    pathBounds.width = this.size;
                }
                if (index >= 0 && pathBounds.contains(evt.getPoint()) && JYCheckBoxList.this.clickedItem != null) {
                    JYCheckBoxList.this.doSelection(index);
                }
                JYCheckBoxList.this.mousePressed = false;
                JYCheckBoxList.this.clickedItem = null;
                evt.getComponent().repaint();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "selectCheckBox");
        this.getActionMap().put("selectCheckBox", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] nArray = JYCheckBoxList.this.getSelectedIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    JYCheckBoxList.this.doSelection(i);
                    ++n2;
                }
            }
        });
    }

    protected CheckBoxRenderer createCheckBoxRenderer(ListCellRenderer<Object> defaultListCellRenderer) {
        return new CheckBoxRenderer(defaultListCellRenderer);
    }

    private int getXOffset() {
        JComponent r = (JComponent)this.getCellRenderer().getListCellRendererComponent(this, 0, 0, false, false);
        return r == null ? 0 : (r.getComponentOrientation().isLeftToRight() ? r.getInsets().left : r.getInsets().right);
    }

    protected void doSelection(int index) {
        if (this.isEnabled()) {
            if (this.checkBoxSelectionModel.hasTriStateSupport() && this.getCheckBoxSelectionModel() instanceof OptionalCheckBoxSelectionModel) {
                this.selectCheckBoxItem(index, !this.checkBoxSelectionModel.isHalfSelected(index));
            } else {
                this.selectCheckBoxItem(index, !this.checkBoxSelectionModel.isSelected(index));
            }
        }
    }

    @Override
    public void setModel(ListModel<Object> model) {
        this.clearCheckBoxSelection();
        super.setModel(model);
    }

    public void clearCheckBoxSelection() {
        CheckBoxSelectionModel checkBoxModel = this.getCheckBoxSelectionModel();
        if (checkBoxModel != null) {
            checkBoxModel.clearSelection();
        }
    }

    public int[] getSelectedCheckBoxIndices() {
        CheckBoxSelectionModel m = this.getCheckBoxSelectionModel();
        if (m == null) {
            return new int[0];
        }
        return m.getSelectedCheckBoxIndices();
    }

    public void setSelectedCheckBoxIndices(int ... indices) {
        CheckBoxSelectionModel m = this.getCheckBoxSelectionModel();
        if (m != null) {
            m.setSelectedCheckBoxIndices(indices);
        }
    }

    public int[] getHalfSelectedCheckBoxIndices() {
        CheckBoxSelectionModel m = this.getCheckBoxSelectionModel();
        if (m == null) {
            return new int[0];
        }
        return m.getHalfSelectedCheckBoxIndices();
    }

    public void setHalfSelectedCheckBoxIndices(int ... indices) {
        CheckBoxSelectionModel m = this.getCheckBoxSelectionModel();
        if (m != null) {
            m.setHalfSelectedCheckBoxIndices(indices);
        }
    }

    protected void selectCheckBoxItem(int index, boolean select) {
        if (select) {
            this.checkBoxSelectionModel.addSelectionInterval(index, index);
        } else {
            this.checkBoxSelectionModel.removeSelectionInterval(index, index);
        }
    }

    public void setCheckBoxSelectableByItemClick(boolean b) {
        this.checkBoxSelectableByItemClick = b;
    }

    public boolean isCheckBoxSelectableByItemClick() {
        return this.checkBoxSelectableByItemClick;
    }

    public CheckBoxSelectionModel getCheckBoxSelectionModel() {
        return this.checkBoxSelectionModel;
    }

    public void setCheckBoxSelectionModel(CheckBoxSelectionModel model) {
        this.checkBoxSelectionModel = model;
        this.checkBoxSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JYCheckBoxList.this.revalidate();
                JYCheckBoxList.this.repaint();
            }
        });
    }

    public class CheckBoxRenderer
    extends JYCheckBox
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = -3982702802918918435L;
        private ListCellRenderer<Object> defaultRenderer;

        public CheckBoxRenderer(ListCellRenderer<Object> defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
            this.setName("List.cellRenderer");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
            DefaultListCellRenderer r = (DefaultListCellRenderer)this.defaultRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus);
            if (index >= 0) {
                if (JYCheckBoxList.this.checkBoxSelectionModel.isHalfSelected(index)) {
                    this.setState(JYCheckBox.State.HALF_SELECTED);
                } else if (JYCheckBoxList.this.checkBoxSelectionModel.isSelected(index)) {
                    this.setState(JYCheckBox.State.SELECTED);
                } else {
                    this.setState(JYCheckBox.State.DESELECTED);
                }
                if (JYCheckBoxList.this.checkBoxClicked) {
                    boolean pressed = JYCheckBoxList.this.clickedItem == value && JYCheckBoxList.this.mousePressed;
                    this.getModel().setArmed(pressed);
                    this.getModel().setPressed(pressed);
                }
            }
            this.setText(r.getText());
            this.setFont(r.getFont());
            this.setForeground(r.getForeground());
            this.setBackground(r.getBackground());
            this.setOpaque(r.isOpaque());
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYCheckBoxList.cell.insets", list, (boolean)true, (boolean)true);
            this.setBorder(insets == null ? r.getBorder() : SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
            if (this.getComponentOrientation() != list.getComponentOrientation()) {
                this.setComponentOrientation(list.getComponentOrientation());
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static class CheckBoxSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1228865802141272863L;
        protected JList<?> list;
        protected DefaultListSelectionModel halfSelectionModel;

        public CheckBoxSelectionModel(JList<?> list, boolean triStateSupport) {
            this.list = list;
            if (triStateSupport) {
                this.halfSelectionModel = new DefaultListSelectionModel();
                this.halfSelectionModel.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        list.revalidate();
                        list.repaint();
                    }
                });
            }
        }

        public boolean hasTriStateSupport() {
            return this.halfSelectionModel != null;
        }

        public boolean isSelected(int index) {
            return !this.hasTriStateSupport() ? this.isSelectedIndex(index) : this.isSelectedIndex(index) && !this.halfSelectionModel.isSelectedIndex(index);
        }

        public boolean isHalfSelected(int index) {
            return !this.hasTriStateSupport() ? false : this.isSelectedIndex(index) && this.halfSelectionModel.isSelectedIndex(index);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.halfSelectionModel.isSelectedIndex(i)) {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        } else {
                            this.halfSelectionModel.setSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                }
                super.setSelectionInterval(index0, index1);
            }
        }

        protected final void setSuperSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(index0, index1);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.halfSelectionModel.isSelectedIndex(i)) {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        } else {
                            this.halfSelectionModel.addSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                }
                super.addSelectionInterval(index0, index1);
            }
        }

        protected final void addSuperSelectionInterval(int index0, int index1) {
            super.addSelectionInterval(index0, index1);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.isHalfSelected(i)) {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        } else {
                            super.removeSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                    return;
                }
                super.removeSelectionInterval(index0, index1);
            }
        }

        protected final void removeSuperSelectionInterval(int index0, int index1) {
            super.removeSelectionInterval(index0, index1);
        }

        @Override
        public void clearSelection() {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    this.halfSelectionModel.clearSelection();
                }
                super.clearSelection();
            }
        }

        protected final void clearSuperSelection() {
            super.clearSelection();
        }

        public void setHalfSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null && this.hasTriStateSupport()) {
                this.halfSelectionModel.setSelectionInterval(index0, index1);
                super.setSelectionInterval(index0, index1);
            }
        }

        public void addHalfSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null && this.hasTriStateSupport()) {
                this.halfSelectionModel.addSelectionInterval(index0, index1);
                super.addSelectionInterval(index0, index1);
            }
        }

        public void removeHalfSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null && this.hasTriStateSupport()) {
                this.halfSelectionModel.removeSelectionInterval(index0, index1);
                super.removeSelectionInterval(index0, index1);
            }
        }

        public int[] getSelectedCheckBoxIndices() {
            int min = this.getMinSelectionIndex();
            int max = this.getMaxSelectionIndex();
            if (min < 0 || max < 0) {
                return new int[0];
            }
            int[] temp = new int[max - min + 1];
            int n = 0;
            int i = min;
            while (i <= max) {
                if (this.isSelected(i)) {
                    temp[n++] = i;
                }
                ++i;
            }
            int[] idx = new int[n];
            System.arraycopy(temp, 0, idx, 0, n);
            return idx;
        }

        public void setSelectedCheckBoxIndices(int ... indices) {
            int i = 0;
            while (i < indices.length) {
                int index = indices[i];
                super.addSelectionInterval(index, index);
                ++i;
            }
        }

        public int[] getHalfSelectedCheckBoxIndices() {
            if (this.halfSelectionModel == null) {
                return new int[0];
            }
            int min = this.halfSelectionModel.getMinSelectionIndex();
            int max = this.halfSelectionModel.getMaxSelectionIndex();
            if (min < 0 || max < 0) {
                return new int[0];
            }
            int[] temp = new int[max - min + 1];
            int n = 0;
            int i = min;
            while (i <= max) {
                if (this.isHalfSelected(i)) {
                    temp[n++] = i;
                }
                ++i;
            }
            int[] idx = new int[n];
            System.arraycopy(temp, 0, idx, 0, n);
            return idx;
        }

        public void setHalfSelectedCheckBoxIndices(int ... indices) {
            if (this.halfSelectionModel == null) {
                return;
            }
            int i = 0;
            while (i < indices.length) {
                int index = indices[i];
                this.addHalfSelectionInterval(index, index);
                ++i;
            }
        }
    }

    public static class OptionalCheckBoxSelectionModel
    extends CheckBoxSelectionModel {
        public OptionalCheckBoxSelectionModel(JList<?> list, boolean triStateSupport) {
            super(list, triStateSupport);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.isSelectedIndex(i)) {
                            this.halfSelectionModel.setSelectionInterval(index0, index0);
                        } else {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                }
                this.setSuperSelectionInterval(index0, index1);
            }
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.isSelected(i)) {
                            this.halfSelectionModel.addSelectionInterval(index0, index0);
                        } else {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                }
                this.addSuperSelectionInterval(index0, index1);
            }
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            if (this.list.getModel() != null) {
                if (this.hasTriStateSupport()) {
                    int i = index0;
                    while (i <= index1) {
                        if (this.isSelected(i)) {
                            this.halfSelectionModel.removeSelectionInterval(index0, index0);
                        } else {
                            this.removeSuperSelectionInterval(index0, index0);
                        }
                        ++i;
                    }
                    return;
                }
                this.removeSuperSelectionInterval(index0, index1);
            }
        }
    }
}

