/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

public class DatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger LOG = Logger.getLogger(DatePickerFormatter.class.getName());
    private DateFormat[] _formats = null;

    public DatePickerFormatter() {
        this(null, null);
    }

    public DatePickerFormatter(DateFormat[] formats) {
        this(formats, null);
    }

    public DatePickerFormatter(Locale locale) {
        this(null, locale);
    }

    public DatePickerFormatter(DateFormat[] formats, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (formats == null) {
            formats = this.createDefaultFormats(locale);
        }
        Contract.asNotNull(formats, "The array of DateFormats must not contain null formats");
        this._formats = formats;
    }

    public DateFormat[] getFormats() {
        DateFormat[] results = new DateFormat[this._formats.length];
        System.arraycopy(this._formats, 0, results, 0, results.length);
        return results;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Date result = null;
        ParseException pex = null;
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        DateFormat[] dateFormatArray = this._formats;
        int n = this._formats.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat _format = dateFormatArray[n2];
            try {
                result = _format.parse(text);
                pex = null;
                break;
            }
            catch (ParseException ex) {
                pex = ex;
                ++n2;
            }
        }
        if (pex != null) {
            throw pex;
        }
        return result;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value != null && this._formats.length > 0) {
            return this._formats[0].format(value);
        }
        return null;
    }

    protected DateFormat[] createDefaultFormats(Locale locale) {
        ArrayList<DateFormat> f = new ArrayList<DateFormat>();
        this.addFormat(f, "JXDatePicker.longFormat", locale);
        this.addFormat(f, "JXDatePicker.mediumFormat", locale);
        this.addFormat(f, "JXDatePicker.shortFormat", locale);
        if (f.size() == 0) {
            this.addSystemDefaultFormat(f, locale);
        }
        return f.toArray(new DateFormat[f.size()]);
    }

    private void addSystemDefaultFormat(List<DateFormat> f, Locale locale) {
        f.add(DateFormat.getDateInstance(3, locale));
    }

    private void addFormat(List<DateFormat> f, String key, Locale locale) {
        String pattern = UIManagerExt.getString(key, locale);
        if (pattern == null) {
            return;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            f.add(format);
        }
        catch (RuntimeException e) {
            LOG.finer("creating date format failed for key/pattern: " + key + "/" + pattern);
        }
    }

    public static class DatePickerFormatterUIResource
    extends DatePickerFormatter
    implements UIResource {
        public DatePickerFormatterUIResource(Locale locale) {
            super(locale);
        }

        public DatePickerFormatterUIResource() {
            this((Locale)null);
        }

        public DatePickerFormatterUIResource(DateFormat[] formats, Locale locale) {
            super(formats, locale);
        }
    }
}

