/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.PainterHighlighter;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.CalendarAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarCellContext;
import org.jdesktop.swingx.plaf.basic.CalendarRenderingHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jdesktop.swingx.plaf.basic.TextCrossingPainter;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.LabelProvider;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

class BasicCalendarRenderingHandler
implements CalendarRenderingHandler {
    private CalendarCellContext cellContext;
    private Map<CalendarState, ComponentProvider<?>> providers;
    private TextCrossingPainter<?> textCross;
    private Color unselectableDayForeground;
    private CalendarAdapter calendarAdapter;
    private CompoundHighlighter highlighter;

    public BasicCalendarRenderingHandler() {
        this.install();
    }

    private void install() {
        this.unselectableDayForeground = UIManagerExt.getColor("JXMonthView.unselectableDayForeground");
        this.textCross = new TextCrossingPainter();
        this.cellContext = new CalendarCellContext();
        this.installProviders();
    }

    private void installProviders() {
        this.providers = new HashMap();
        StringValue sv = this.createDayStringValue(null);
        LabelProvider provider = new LabelProvider(sv, 4);
        this.providers.put(CalendarState.IN_MONTH, provider);
        this.providers.put(CalendarState.TODAY, provider);
        this.providers.put(CalendarState.TRAILING, provider);
        this.providers.put(CalendarState.LEADING, provider);
        StringValue wsv = this.createWeekOfYearStringValue(null);
        LabelProvider weekOfYearProvider = new LabelProvider(wsv, 4);
        this.providers.put(CalendarState.WEEK_OF_YEAR, weekOfYearProvider);
        LabelProvider dayOfWeekProvider = new LabelProvider(0){

            @Override
            protected String getValueAsString(CellContext context) {
                Object value = context.getValue();
                if (value instanceof Calendar) {
                    int day = ((Calendar)value).get(7);
                    return ((JXMonthView)context.getComponent()).getDayOfTheWeek(day);
                }
                return super.getValueAsString(context);
            }
        };
        this.providers.put(CalendarState.DAY_OF_WEEK, dayOfWeekProvider);
        StringValue tsv = this.createMonthHeaderStringValue(null);
        LabelProvider titleProvider = new LabelProvider(tsv, 0);
        this.providers.put(CalendarState.TITLE, titleProvider);
    }

    protected StringValue createMonthHeaderStringValue(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        final String[] monthNames = DateFormatSymbols.getInstance(locale).getMonths();
        StringValue tsv = new StringValue(){

            @Override
            public String getString(Object value) {
                if (value instanceof Calendar) {
                    String month = monthNames[((Calendar)value).get(2)];
                    return String.valueOf(month) + " " + ((Calendar)value).get(1);
                }
                return StringValues.TO_STRING.getString(value);
            }
        };
        return tsv;
    }

    protected StringValue createWeekOfYearStringValue(Locale locale) {
        StringValue wsv = new StringValue(){

            @Override
            public String getString(Object value) {
                if (value instanceof Calendar) {
                    value = ((Calendar)value).get(3);
                }
                return StringValues.TO_STRING.getString(value);
            }
        };
        return wsv;
    }

    protected StringValue createDayStringValue(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        FormatStringValue sv = new FormatStringValue(new SimpleDateFormat("d", locale)){

            @Override
            public String getString(Object value) {
                if (value instanceof Calendar) {
                    ((DateFormat)this.getFormat()).setTimeZone(((Calendar)value).getTimeZone());
                    value = ((Calendar)value).getTime();
                }
                return super.getString(value);
            }
        };
        return sv;
    }

    @Override
    public void setLocale(Locale locale) {
        StringValue dayValue = this.createDayStringValue(locale);
        this.providers.get((Object)CalendarState.IN_MONTH).setStringValue(dayValue);
        this.providers.get((Object)CalendarState.TODAY).setStringValue(dayValue);
        this.providers.get((Object)CalendarState.TRAILING).setStringValue(dayValue);
        this.providers.get((Object)CalendarState.LEADING).setStringValue(dayValue);
        this.providers.get((Object)CalendarState.WEEK_OF_YEAR).setStringValue(this.createWeekOfYearStringValue(locale));
        this.providers.get((Object)CalendarState.TITLE).setStringValue(this.createMonthHeaderStringValue(locale));
    }

    @Override
    public JComponent prepareRenderingComponent(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        this.cellContext.installContext(monthView, calendar, this.isSelected(monthView, calendar, dayState), this.isFocused(monthView, calendar, dayState), calendar == null ? false : calendar.getTime().equals(monthView.getClientProperty("MOUSE_OVER_DATE")), dayState);
        Object comp = this.providers.get((Object)dayState).getRendererComponent(this.cellContext);
        return this.highlight((JComponent)comp, monthView, calendar, dayState);
    }

    private JComponent highlight(JComponent comp, JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        CalendarAdapter adapter = this.getCalendarAdapter(monthView, calendar, dayState);
        return (JComponent)this.getHighlighter().highlight(comp, adapter);
    }

    private Highlighter getHighlighter() {
        if (this.highlighter == null) {
            this.highlighter = new CompoundHighlighter(new Highlighter[0]);
            this.installHighlighters();
        }
        return this.highlighter;
    }

    private void installHighlighters() {
        HighlightPredicate boldPredicate = new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (!(adapter instanceof CalendarAdapter)) {
                    return false;
                }
                CalendarAdapter ca = (CalendarAdapter)adapter;
                return CalendarState.DAY_OF_WEEK == ca.getCalendarState() || CalendarState.TITLE == ca.getCalendarState();
            }
        };
        AbstractHighlighter font = new AbstractHighlighter(boldPredicate){

            @Override
            protected Component doHighlight(Component component, ComponentAdapter adapter) {
                component.setFont(BasicCalendarRenderingHandler.this.getDerivedFont(component.getFont()));
                return component;
            }
        };
        this.highlighter.addHighlighter(font);
        HighlightPredicate unselectable = new HighlightPredicate(){

            @Override
            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (!(adapter instanceof CalendarAdapter)) {
                    return false;
                }
                return ((CalendarAdapter)adapter).isUnselectable();
            }
        };
        this.textCross.setForeground(this.unselectableDayForeground);
        PainterHighlighter painterHL = new PainterHighlighter(unselectable, this.textCross);
        this.highlighter.addHighlighter(painterHL);
    }

    private CalendarAdapter getCalendarAdapter(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        if (this.calendarAdapter == null) {
            this.calendarAdapter = new CalendarAdapter(monthView);
        }
        return this.calendarAdapter.install(calendar, dayState);
    }

    private Font getDerivedFont(Font font) {
        return font.deriveFont(1);
    }

    private boolean isFocused(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        return false;
    }

    private boolean isSelected(JXMonthView monthView, Calendar calendar, CalendarState dayState) {
        if (!this.isSelectable(dayState)) {
            return false;
        }
        return monthView.isSelected(calendar.getTime());
    }

    private boolean isSelectable(CalendarState dayState) {
        return CalendarState.IN_MONTH == dayState || CalendarState.TODAY == dayState;
    }
}

