/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.awt.DrawingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ArrowButtonView
extends ButtonView {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private int minimumWidth;
    private int minimumHeight;
    private boolean buttonDepressed = false;
    private int _direction;
    private Color backgroundColor;
    private Color arrowColor = Color.white;

    public ArrowButtonView(int direction, final ButtonModel buttonModel, final PropertiesModel propertiesModel) {
        this._direction = direction;
        this.buttonModel = buttonModel;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                ArrowButtonView.this.updateProperties(propertiesModel);
                ArrowButtonView.this.repaint();
            }
        });
        this.minimumHeight = 21;
        this.minimumWidth = 21;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ArrowButtonView.this.updateScreenValues();
                ArrowButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ArrowButtonView.this.buttonDepressed = true;
                ArrowButtonView.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ArrowButtonView.this.buttonDepressed = false;
                ArrowButtonView.this.repaint();
                buttonModel.setSelected(this);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int offset_y;
        int offset_x;
        boolean raised;
        if (this.buttonDepressed) {
            raised = false;
            offset_x = 1;
            offset_y = 1;
        } else {
            raised = true;
            offset_x = 0;
            offset_y = 0;
        }
        DrawingTools.draw3DRect(0, 0, this.minimumWidth, this.minimumHeight, raised, g, this.backgroundColor);
        g.setColor(this.arrowColor);
        Polygon polygon = new Polygon();
        switch (this._direction) {
            case 1: {
                polygon.addPoint(this.minimumWidth - 5 + offset_x, 3 + offset_y);
                polygon.addPoint(4 + offset_x, this.minimumHeight / 2 + offset_y);
                polygon.addPoint(this.minimumWidth - 5 + offset_x, this.minimumHeight - 5 + offset_y);
                break;
            }
            case 2: {
                polygon.addPoint(4 + offset_x, 3 + offset_y);
                polygon.addPoint(this.minimumWidth - 5 + offset_x, this.minimumHeight / 2 + offset_y);
                polygon.addPoint(4 + offset_x, this.minimumHeight - 5 + offset_y);
            }
        }
        g.fillPolygon(polygon);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "backgroundColor")).getColor();
        this.setBackground(this.backgroundColor);
        this.arrowColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "arrowColor")).getColor();
    }
}

