/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class CenteredButtonView
extends ButtonView {
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private String label;
    private int minimumWidth;
    private int minimumHeight;
    private boolean buttonDepressed = false;
    private Color backgroundColor;
    private Color lightColor;
    private Color darkColor;
    private Color textColor = Color.white;
    private static final Font font = new Font("Helvetica", 0, 12);

    public CenteredButtonView(final ButtonModel buttonModel, String label, final PropertiesModel propertiesModel) {
        this.buttonModel = buttonModel;
        this.label = label;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                CenteredButtonView.this.updateProperties(propertiesModel);
                CenteredButtonView.this.repaint();
            }
        });
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading() + 3;
        this.minimumWidth = fontMetrics.stringWidth(label) + 6;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CenteredButtonView.this.updateScreenValues();
                CenteredButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CenteredButtonView.this.buttonDepressed = true;
                CenteredButtonView.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CenteredButtonView.this.buttonDepressed = false;
                CenteredButtonView.this.repaint();
                buttonModel.setSelected(this);
            }
        });
    }

    public void setLabel(Object source, String label) {
        this.label = label;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        if (this.buttonDepressed) {
            g.setColor(this.darkColor);
            g.drawLine(0, 0, this.screenWidth - 2, 0);
            g.drawLine(0, 0, 0, this.minimumHeight - 2);
            g.drawLine(0, this.minimumHeight - 1, this.screenWidth - 1, this.minimumHeight - 1);
            g.drawLine(this.screenWidth - 1, 0, this.screenWidth - 1, this.minimumHeight - 1);
            g.setColor(this.textColor);
            g.drawString(this.label, 3, fontMetrics.getMaxAscent() + 2);
        } else {
            g.setColor(this.lightColor);
            g.drawLine(0, 0, this.screenWidth - 2, 0);
            g.drawLine(0, 0, 0, this.minimumHeight - 2);
            g.setColor(this.darkColor);
            g.drawLine(1, this.minimumHeight - 2, this.screenWidth - 2, this.minimumHeight - 2);
            g.drawLine(this.screenWidth - 2, 1, this.screenWidth - 2, this.minimumHeight - 2);
            g.setColor(Color.black);
            g.drawLine(0, this.minimumHeight - 1, this.screenWidth - 1, this.minimumHeight - 1);
            g.drawLine(this.screenWidth - 1, 0, this.screenWidth - 1, this.minimumHeight - 1);
            g.setColor(this.textColor);
            g.drawString(this.label, 2, fontMetrics.getMaxAscent() + 1);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "backgroundColor")).getColor();
        this.lightColor = this.backgroundColor.brighter();
        this.darkColor = this.backgroundColor.darker();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "textColor")).getColor();
    }
}

