/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.util.geometry.LineModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.ShapeModel;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Vector;

public class PointModel
implements ShapeModel {
    double x;
    double y;
    LinkedList list = new LinkedList();
    Vector voronoi = new Vector();
    protected static boolean smallPoints;
    protected static float distClose;
    public static final int ONSEGMENT = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int INFRONTOFA = 3;
    public static final int BEHINDB = 4;
    public static final int ERROR = 5;

    public PointModel() {
    }

    public PointModel(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public PointModel(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public PointModel(double x, double y) {
        Float F = new Float(x);
        this.x = F.floatValue();
        F = new Float(y);
        this.y = F.floatValue();
    }

    public PointModel(PointModel p) {
        this.x = p.x;
        this.y = p.y;
    }

    public PointModel(PointModel p, Color c) {
        this(p);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void addVoronoi(SegmentModel segmentModel) {
        this.voronoi.addElement(segmentModel);
    }

    public int getVoronoiCount() {
        return this.voronoi.size();
    }

    public SegmentModel getVoronoi(int index) {
        return (SegmentModel)this.voronoi.elementAt(index);
    }

    public double distance2(PointModel p) {
        return (p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y);
    }

    public double distance2(double px, double py) {
        return (px - this.x) * (px - this.x) + (py - this.y) * (py - this.y);
    }

    public static void SetSmallPoints(boolean st) {
        smallPoints = st;
        distClose = smallPoints ? 20.0f : 57.0f;
    }

    public boolean match(int x, int y) {
        return this.distance2(x, y) <= (double)distClose;
    }

    public void move(int xx, int yy) {
        this.x = xx;
        this.y = yy;
    }

    public boolean isLess(PointModel p) {
        return this.x < p.x || this.x == p.x && this.y < p.y;
    }

    public boolean isGreater(PointModel p) {
        return this.x > p.x || this.x == p.x && this.y > p.y;
    }

    public boolean isEqual(PointModel p) {
        return this.x == p.x && this.y == p.y;
    }

    public int pointLineTest(PointModel a, PointModel b) {
        double dy = b.y - a.y;
        double dx = b.x - a.x;
        double res = dy * (this.x - a.x) - dx * (this.y - a.y);
        if (res < 0.0) {
            return 1;
        }
        if (res > 0.0) {
            return 2;
        }
        if (dx > 0.0) {
            if (this.x < a.x) {
                return 3;
            }
            if (b.x < this.x) {
                return 4;
            }
            return 0;
        }
        if (dx < 0.0) {
            if (this.x > a.x) {
                return 3;
            }
            if (b.x > this.x) {
                return 4;
            }
            return 0;
        }
        if (dy > 0.0) {
            if (this.y < a.y) {
                return 3;
            }
            if (b.y < this.y) {
                return 4;
            }
            return 0;
        }
        if (dy < 0.0) {
            if (this.y > a.y) {
                return 3;
            }
            if (b.y > this.y) {
                return 4;
            }
            return 0;
        }
        System.out.println("Error, pointLineTest with a=b");
        return 5;
    }

    public boolean areCollinear(PointModel a, PointModel b) {
        double dy = b.y - a.y;
        double dx = b.x - a.x;
        double res = dy * (this.x - a.x) - dx * (this.y - a.y);
        return res == 0.0;
    }

    public LineModel Bisector(PointModel b) {
        double sx = (this.x + b.x) / 2.0;
        double sy = (this.y + b.y) / 2.0;
        double dx = b.x - this.x;
        double dy = b.y - this.y;
        PointModel p1 = new PointModel(sx - dy, sy + dx);
        PointModel p2 = new PointModel(sx + dy, sy - dx);
        return new LineModel(p1, p2);
    }

    public PointModel circumcenter(PointModel a, PointModel b) {
        double u = ((a.x - b.x) * (a.x + b.x) + (a.y - b.y) * (a.y + b.y)) / 2.0;
        double v = ((b.x - this.x) * (b.x + this.x) + (b.y - this.y) * (b.y + this.y)) / 2.0;
        double den = (a.x - b.x) * (b.y - this.y) - (b.x - this.x) * (a.y - b.y);
        if (den == 0.0) {
            System.out.println("circumcenter, degenerate case");
        }
        return new PointModel((u * (b.y - this.y) - v * (a.y - b.y)) / den, (v * (a.x - b.x) - u * (b.x - this.x)) / den);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PointModel) {
            PointModel p = (PointModel)obj;
            return this.isEqual(p);
        }
        System.err.println("Error");
        return false;
    }

    public int hashCode() {
        return (int)this.x;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + "]";
    }

    static {
        PointModel.SetSmallPoints(false);
    }
}

