/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.logging;

import com.macrofocus.util.logging.LoggingJFrame;
import com.macrofocus.util.logging.SwingLoggingOutput;
import java.awt.Component;
import java.io.PrintStream;

public class ConsoleLoggingOutput
implements SwingLoggingOutput {
    private String indent = "\t";

    public ConsoleLoggingOutput(String title) {
        new LoggingJFrame(title, true, true);
    }

    public ConsoleLoggingOutput(String title, boolean out, boolean err) {
        new LoggingJFrame(title, out, err);
    }

    public boolean process(Throwable t) {
        this.printStackTrace(t, System.err);
        return false;
    }

    public boolean process(Component c, Throwable t) {
        return this.process(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable t, PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            if (t.getMessage() != null) {
                s.println(t.getMessage());
            } else {
                s.println("Unknown error");
            }
            s.println(this.indent + " thrown by " + t.getClass().getName());
            StackTraceElement[] trace = t.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println(this.indent + this.indent + "at " + String.valueOf(trace[i]));
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                this.printStackTraceAsCause(ourCause, s, trace);
            }
        }
    }

    private void printStackTraceAsCause(Throwable t, PrintStream s, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println(this.indent + this.indent + "caused by " + String.valueOf(t));
        for (int i = 0; i <= m; ++i) {
            s.println(this.indent + this.indent + this.indent + "at " + String.valueOf(trace[i]));
        }
        if (framesInCommon != 0) {
            s.println(this.indent + this.indent + this.indent + "... " + framesInCommon + " more");
        }
        if ((ourCause = t.getCause()) != null) {
            this.printStackTraceAsCause(ourCause, s, trace);
        }
    }
}

