/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.label;

import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JLabel;

public class MLabel
extends JLabel {
    private final RenderingHintsModel renderingHintsModel;

    public MLabel(Action action, RenderingHintsModel renderingHintsModel) {
        this(action, "", "", renderingHintsModel);
    }

    public MLabel(final Action action, final String leading, final String ending, RenderingHintsModel renderingHintsModel) {
        this.renderingHintsModel = renderingHintsModel;
        this.configurePropertiesFromAction(action, null, leading, ending);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("Name")) {
                    MLabel.this.configurePropertiesFromAction(action, null, leading, ending);
                }
            }
        });
    }

    private void configurePropertiesFromAction(Action a, String[] types, String leading, String ending) {
        if (types == null) {
            String[] alltypes = new String[]{"Name", "ShortDescription", "ActionCommandKey", "enabled"};
            types = alltypes;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (type == null) continue;
            if (type.equals("Name")) {
                this.setText(a != null ? leading + String.valueOf(a.getValue(type)) + ending : null);
                continue;
            }
            if (type.equals("ShortDescription")) {
                this.setToolTipText(a != null ? (String)a.getValue(type) : null);
                continue;
            }
            if (!type.equals("enabled")) continue;
            this.setEnabled(a == null || a.isEnabled());
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        super.paint(g2);
    }
}

