/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.logo;

import com.macrofocus.color.ColorModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.java2d.RenderingHintsListener;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.java2d.RepaintRenderingHintsListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class Java2DLogoView
extends JComponent
implements SwingConstants {
    private double worldX = -1.7976931348623157E308;
    private double worldY = -1.7976931348623157E308;
    private double currentWorldX = 0.0;
    private double currentWorldY = 0.0;
    private float currentScreenX = 0.0f;
    private float currentScreenY = 0.0f;
    private double previousX2 = 0.0;
    private double previousY2 = 0.0;
    private GeneralPath polygon;
    private Color color = Color.black;
    private boolean fill = false;
    private Color backgroundColor;
    private Color macroColor = new Color(100, 100, 100);
    private Color focusColor = new Color(225, 225, 225);
    private RenderingHintsModel renderingHintsModel;
    private final boolean mainAspectRatio = true;
    private List polygons;
    private final RenderingHintsListener renderingHintsListener = new RepaintRenderingHintsListener(this, 500L);
    private int verticalAlignment = 0;
    private int horizontalAlignment = 4;
    private Action action;
    private MouseListener mouseListener = null;

    public Java2DLogoView() {
        this(null, null);
    }

    public Java2DLogoView(Action action, RenderingHintsModel renderingHintsModel, PropertiesModel propertiesModel) {
        this(renderingHintsModel, propertiesModel);
        this.setAction(action);
    }

    public void setAction(Action newAction) {
        if (newAction == null) {
            if (this.mouseListener != null) {
                this.removeMouseListener(this.mouseListener);
                this.mouseListener = null;
            }
        } else if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Java2DLogoView.this.action != null) {
                        Java2DLogoView.this.action.actionPerformed(new ActionEvent(this, 0, ""));
                    }
                }
            };
            this.addMouseListener(this.mouseListener);
        }
        this.action = newAction;
    }

    public Java2DLogoView(RenderingHintsModel renderingHintsModel, final PropertiesModel propertiesModel) {
        this.renderingHintsModel = renderingHintsModel;
        if (renderingHintsModel != null) {
            renderingHintsModel.addWeakRenderingHintsListener(this.renderingHintsListener);
        }
        if (propertiesModel != null) {
            this.updateProperties(propertiesModel);
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    Java2DLogoView.this.updateProperties(propertiesModel);
                    Java2DLogoView.this.repaint();
                }
            });
        }
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.repaint();
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.renderingHintsModel != null) {
            g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.polygons == null) {
            this.updateLogo();
        }
        this.paintLogo(g2);
    }

    private void paintLogo(Graphics2D g) {
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        double src_w = this.worldX;
        double src_h = this.worldY;
        double scale_x = (double)w / src_w;
        double scale_y = (double)h / src_h;
        double scale = Math.min(scale_x, scale_y);
        int dst_w = (int)Math.round(scale * src_w);
        int dst_h = (int)Math.round(scale * src_h);
        int dx = x + (w - dst_w) / 2;
        if (this.horizontalAlignment == 2) {
            dx = x;
        } else if (this.horizontalAlignment == 4) {
            dx = x + w - dst_w;
        }
        int dy = y + (h - dst_h) / 2;
        if (this.verticalAlignment == 1) {
            dy = y;
        } else if (this.verticalAlignment == 3) {
            dy = y + h - dst_h;
        }
        g.translate(dx, dy);
        g.scale(scale, scale);
        if (this.polygons != null) {
            Iterator iterator = this.polygons.iterator();
            while (iterator.hasNext()) {
                Color color = (Color)iterator.next();
                Shape polygon = (Shape)iterator.next();
                g.setColor(color);
                g.fill(polygon);
            }
        }
    }

    private void updateLogo() {
        this.polygons = new LinkedList();
        this.backgroundColor = this.getBackground();
        this.fill = true;
        this.color = this.focusColor;
        this.M(132.628, 37.1);
        this.h(-9.84);
        this.V(23.9);
        this.h(9.84);
        this.c(0.0, -17.88, 6.24, -23.4, 23.64, -23.4);
        this.c(3.24, 0.0, 6.6, 0.24, 9.84, 0.36);
        this.v(14.4);
        this.c(-1.92, -0.24, -3.72, -0.36, -5.52, -0.36);
        this.c(-4.68, 0.0, -7.56, 0.6, -7.56, 6.24);
        this.v(2.76);
        this.h(12.24);
        this.v(13.2);
        this.h(-12.24);
        this.v(49.081);
        this.h(-20.4);
        this.V(37.1);
        this.z();
        this.color = this.focusColor;
        this.M(166.585, 55.101);
        this.c(0.0, 18.72, 13.44, 32.88, 32.76, 32.88);
        this.c(19.32, 0.0, 32.88, -14.16, 32.88, -32.88);
        this.c(0.0, -18.72, -13.56, -33.0, -32.88, -33.0);
        this.c(-19.32, 0.0, -32.76, 14.28, -32.76, 33.0);
        this.polygon.closePath();
        Area bigO = new Area(this.polygon);
        this.M(186.985, 55.101);
        this.c(0.0, -7.92, 2.88, -17.4, 12.36, -17.4);
        this.c(9.48, 0.0, 12.48, 9.48, 12.48, 17.4);
        this.c(0.0, 7.92, -3.0, 17.28, -12.48, 17.28);
        this.c(-9.48, 0.0, -12.36, -9.36, -12.36, -17.28);
        this.polygon.closePath();
        Area innerBigO = new Area(this.polygon);
        bigO.subtract(innerBigO);
        this.polygons.add(this.color);
        this.polygons.add(bigO);
        this.M(281.464, 46.7);
        this.c(-0.12, -5.28, -4.8, -9.0, -9.96, -9.0);
        this.c(-11.4, 0.0, -13.2, 9.72, -13.2, 18.36);
        this.c(0.0, 8.04, 3.48, 16.32, 12.12, 16.32);
        this.c(7.08, 0.0, 10.68, -4.08, 11.641, -10.681);
        this.h(19.8);
        this.c(-1.8, 16.681, -14.761, 26.28, -31.32, 26.28);
        this.c(-18.72, 0.0, -32.64, -12.84, -32.64, -31.92);
        this.c(0.0, -19.8, 12.6, -33.96, 32.64, -33.96);
        this.c(15.48, 0.0, 29.28, 8.16, 30.72, 24.6);
        this.h(-19.8);
        this.z();
        this.M(372.782, 86.181);
        this.h(-19.8);
        this.V(77.66);
        this.h(-0.24);
        this.c(-3.84, 6.36, -11.76, 10.32, -18.96, 10.32);
        this.c(-17.88, 0.0, -23.04, -10.32, -23.04, -26.64);
        this.V(23.9);
        this.h(20.4);
        this.v(36.12);
        this.c(0.0, 8.28, 3.6, 11.16, 10.08, 11.16);
        this.c(4.439, 0.0, 11.16, -2.88, 11.16, -13.92);
        this.V(23.9);
        this.h(20.399);
        this.v(62.28);
        this.z();
        this.M(401.101, 65.66);
        this.c(0.0, 3.12, 1.32, 5.4, 3.36, 6.96);
        this.c(1.92, 1.44, 4.68, 2.16, 7.561, 2.16);
        this.c(3.96, 0.0, 9.6, -1.68, 9.6, -6.6);
        this.c(0.0, -4.8, -6.36, -5.76, -9.96, -6.601);
        this.c(-12.84, -3.239, -28.92, -3.6, -28.92, -20.4);
        this.c(0.0, -15.0, 16.2, -19.08, 28.439, -19.08);
        this.c(13.681, 0.0, 27.961, 3.96, 28.681, 20.16);
        this.h(-18.84);
        this.c(0.0, -2.64, -0.96, -4.32, -2.641, -5.4);
        this.c(-1.68, -1.08, -3.96, -1.56, -6.479, -1.56);
        this.c(-3.36, 0.0, -8.761, 0.36, -8.761, 4.68);
        this.c(0.0, 5.88, 13.681, 6.96, 23.041, 9.0);
        this.c(12.6, 2.52, 15.84, 11.64, 15.84, 16.8);
        this.c(0.0, 16.681, -15.84, 22.2, -29.881, 22.2);
        this.c(-14.76, 0.0, -29.88, -4.92, -30.479, -22.32);
        this.h(19.439);
        this.z();
        this.fill = true;
        this.color = this.macroColor;
        this.M(0.0, 36.482);
        this.h(11.88);
        this.v(5.112);
        this.h(0.144);
        this.c(2.232, -3.744, 6.192, -6.192, 10.728, -6.192);
        this.c(4.68, 0.0, 8.856, 1.512, 10.872, 6.048);
        this.c(2.952, -3.96, 6.625, -6.048, 11.665, -6.048);
        this.c(11.88, 0.0, 13.176, 9.0, 13.176, 16.128);
        this.v(22.32);
        this.h(-12.24);
        this.V(51.89);
        this.c(0.0, -4.032, -1.944, -6.408, -5.112, -6.408);
        this.c(-5.256, 0.0, -5.76, 4.032, -5.76, 10.08);
        this.V(73.85);
        this.h(-12.24);
        this.V(52.61);
        this.c(0.0, -4.392, -1.296, -7.128, -4.608, -7.128);
        this.c(-4.392, 0.0, -6.264, 2.52, -6.264, 10.152);
        this.V(73.85);
        this.H(0.0);
        this.V(36.482);
        this.z();
        this.M(77.616, 48.002);
        this.c(0.576, -3.168, 2.736, -4.68, 6.12, -4.68);
        this.c(2.52, 0.0, 5.904, 1.08, 5.904, 3.888);
        this.c(0.0, 2.304, -1.152, 3.024, -3.24, 3.456);
        this.c(-8.496, 1.728, -21.744, 0.792, -21.744, 12.96);
        this.c(0.0, 7.704, 5.616, 11.304, 12.744, 11.304);
        this.c(4.464, 0.0, 9.144, -1.296, 12.312, -4.608);
        this.c(0.144, 1.225, 0.288, 2.376, 0.72, 3.528);
        this.h(12.312);
        this.c(-1.44, -2.952, -1.44, -6.408, -1.44, -9.576);
        this.V(47.93);
        this.c(0.0, -10.584, -8.568, -12.528, -17.424, -12.528);
        this.c(-4.248, 0.0, -8.568, 0.72, -11.88, 2.592);
        this.c(-3.312, 1.944, -5.616, 5.112, -5.832, 10.008);
        this.h(11.448);
        this.polygon.closePath();
        Area a = new Area(this.polygon);
        this.M(76.896, 63.122);
        this.c(0.0, -2.951, 2.304, -4.104, 5.04, -4.752);
        this.c(2.664, -0.72, 5.832, -0.936, 7.56, -2.016);
        this.c(0.288, 7.704, -1.656, 11.016, -7.488, 11.016);
        this.c(-2.736, 0.0, -5.112, -1.224, -5.112, -4.248);
        this.polygon.closePath();
        Area innerA = new Area(this.polygon);
        a.subtract(innerA);
        this.polygons.add(this.color);
        this.polygons.add(a);
        this.color = this.macroColor;
        this.M(133.703, 50.162);
        this.c(-0.072, -3.168, -2.88, -5.4, -5.976, -5.4);
        this.c(-6.84, 0.0, -7.92, 5.832, -7.92, 11.016);
        this.c(0.0, 4.824, 2.088, 9.792, 7.272, 9.792);
        this.c(4.248, 0.0, 6.408, -2.448, 6.984, -6.408);
        this.h(11.88);
        this.c(-1.08, 10.009, -8.856, 15.769, -18.792, 15.769);
        this.c(-11.232, 0.0, -19.584, -7.704, -19.584, -19.152);
        this.c(0.0, -11.88, 7.56, -20.376, 19.584, -20.376);
        this.c(9.288, 0.0, 17.568, 4.896, 18.432, 14.76);
        this.h(-11.88);
        this.z();
        this.M(152.494, 36.482);
        this.h(11.88);
        this.v(6.552);
        this.h(0.144);
        this.c(1.8, -4.752, 5.976, -7.272, 11.232, -7.272);
        this.c(0.936, 0.0, 1.944, 0.072, 2.88, 0.288);
        this.v(11.16);
        this.c(-1.584, -0.432, -3.024, -0.72, -4.68, -0.72);
        this.c(-6.048, 0.0, -9.216, 4.176, -9.216, 8.856);
        this.V(73.85);
        this.h(-12.24);
        this.V(36.482);
        this.z();
        this.M(179.65, 55.202);
        this.c(0.0, 11.232, 8.064, 19.729, 19.656, 19.729);
        this.c(11.592, 0.0, 19.729, -8.496, 19.729, -19.729);
        this.c(0.0, -11.232, -8.136, -19.8, -19.729, -19.8);
        this.c(-11.592, 0.0, -19.656, 8.568, -19.656, 19.8);
        this.polygon.closePath();
        Area smallO = new Area(this.polygon);
        this.M(191.89, 55.202);
        this.c(0.0, -4.752, 1.728, -10.44, 7.416, -10.44);
        this.c(5.688, 0.0, 7.488, 5.688, 7.488, 10.44);
        this.s(-1.8, 10.368, -7.488, 10.368);
        this.c(-5.688, 0.0, -7.416, -5.616, -7.416, -10.368);
        this.polygon.closePath();
        Area smallInnerO = new Area(this.polygon);
        smallO.subtract(smallInnerO);
        this.polygons.add(this.color);
        this.polygons.add(smallO);
        this.color = this.macroColor;
    }

    private void M(double x, double y) {
        this.setX(x);
        this.setY(y);
        try {
            this.polygon = new GeneralPath(0);
        }
        catch (NoSuchFieldError e) {
            this.polygon = new GeneralPath();
        }
        this.polygon.moveTo(this.currentScreenX, this.currentScreenY);
    }

    private void z() {
        this.polygon.closePath();
        this.polygons.add(this.color);
        this.polygons.add(this.polygon);
    }

    private void L(double x, double y) {
        this.polygon.lineTo(this.worldToScreenX(x), this.worldToScreenY(y));
        this.setX(x);
        this.setY(y);
    }

    private void l(double x, double y) {
        this.polygon.lineTo(this.worldToScreenX(this.currentWorldX + x), this.worldToScreenY(this.currentWorldY + y));
        this.setX(this.currentWorldX + x);
        this.setY(this.currentWorldY + y);
    }

    private void H(double x) {
        this.polygon.lineTo(this.worldToScreenX(x), this.currentScreenY);
        this.setX(x);
    }

    private void h(double x) {
        this.polygon.lineTo(this.worldToScreenX(this.currentWorldX + x), this.currentScreenY);
        this.setX(this.currentWorldX + x);
    }

    private void V(double y) {
        this.polygon.lineTo(this.currentScreenX, this.worldToScreenY(y));
        this.setY(y);
    }

    private void v(double y) {
        this.polygon.lineTo(this.currentScreenX, this.worldToScreenY(this.currentWorldY + y));
        this.setY(this.currentWorldY + y);
    }

    private void C(double x1, double y1, double x2, double y2, double x, double y) {
        this.polygon.curveTo(this.worldToScreenX(x1), this.worldToScreenY(y1), this.worldToScreenX(x2), this.worldToScreenY(y2), this.worldToScreenX(x), this.worldToScreenY(y));
        this.setX(x);
        this.setY(y);
        this.previousX2 = x2;
        this.previousY2 = y2;
    }

    private void c(double x1, double y1, double x2, double y2, double x, double y) {
        double x0 = this.currentWorldX;
        double y0 = this.currentWorldY;
        this.C(x0 + x1, y0 + y1, x0 + x2, y0 + y2, x0 + x, y0 + y);
    }

    private void CSeg(double ax, double ay, double bx, double by, double cx, double cy, double x0, double y0, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double x = ax * t3 + bx * t2 + cx * t + x0;
        double y = ay * t3 + by * t2 + cy * t + y0;
        this.L(x, y);
    }

    private void S(double x2, double y2, double x, double y) {
        double x1 = 2.0 * this.currentWorldX - this.previousX2;
        double y1 = 2.0 * this.currentWorldY - this.previousY2;
        this.C(x1, y1, x2, y2, x, y);
    }

    private void s(double x2, double y2, double x, double y) {
        double x0 = this.currentWorldX;
        double y0 = this.currentWorldY;
        this.S(x0 + x2, y0 + y2, x0 + x, y0 + y);
    }

    private float worldToScreenX(double x) {
        return (float)x;
    }

    private float worldToScreenY(double y) {
        return (float)y;
    }

    private void setX(double x) {
        this.currentWorldX = x;
        this.currentScreenX = this.worldToScreenX(x);
        if (this.currentWorldX > this.worldX) {
            this.worldX = this.currentWorldX;
        }
        if (this.currentWorldY > this.worldY) {
            this.worldY = this.currentWorldY;
        }
    }

    private void setY(double y) {
        this.currentWorldY = y;
        this.currentScreenY = this.worldToScreenY(y);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = this.getBackground();
        if (propertiesModel.isAvailable("logo.macroColor")) {
            this.macroColor = (Color)propertiesModel.getValue("logo.macroColor");
        } else if (propertiesModel.isAvailable(this.getClass().getName() + ".macroColor")) {
            this.macroColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "macroColor")).getColor();
        }
        if (propertiesModel.isAvailable("logo.focusColor")) {
            this.focusColor = (Color)propertiesModel.getValue("logo.focusColor");
        } else if (propertiesModel.isAvailable(this.getClass().getName() + ".focusColor")) {
            this.focusColor = ((ColorModel)propertiesModel.getValue(this.getClass(), "focusColor")).getColor();
        }
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public void setMacroColor(Color macroColor) {
        this.macroColor = macroColor;
    }
}

