/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf;

import java.awt.Font;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalTheme;

public class MacrofocusMetalTheme
extends MetalTheme {
    private final ColorUIResource background = new ColorUIResource(0, 0, 127);
    private final ColorUIResource primary0 = new ColorUIResource(51, 51, 102);
    private final ColorUIResource primary1 = new ColorUIResource(102, 102, 153);
    private final ColorUIResource primary2 = new ColorUIResource(153, 153, 204);
    private final ColorUIResource primary3 = new ColorUIResource(204, 204, 255);
    private final ColorUIResource secondary0 = new ColorUIResource(0, 0, 0);
    private final ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
    private final ColorUIResource secondary2 = new ColorUIResource(153, 153, 153);
    private final ColorUIResource secondary3 = new ColorUIResource(204, 204, 204);
    private final ColorUIResource secondary4 = new ColorUIResource(255, 255, 255);
    private FontUIResource controlFont;
    private FontUIResource systemFont;
    private FontUIResource userFont;
    private FontUIResource smallFont;

    @Override
    public String getName() {
        return "Macrofocus";
    }

    public MacrofocusMetalTheme() {
        ImageIcon collapsedIcon = new ImageIcon(this.getClass().getResource("collapsed.gif"));
        ImageIcon expandedIcon = new ImageIcon(this.getClass().getResource("expanded.gif"));
        UIManager.put("Tree.expandedIcon", expandedIcon);
        UIManager.put("Tree.collapsedIcon", collapsedIcon);
    }

    ColorUIResource getPrimary0() {
        return this.primary0;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    ColorUIResource getSecondary0() {
        return this.secondary0;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    ColorUIResource getSecondary4() {
        return this.secondary4;
    }

    @Override
    public FontUIResource getControlTextFont() {
        if (this.controlFont == null) {
            try {
                this.controlFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Helvetica", 0, 11)));
            }
            catch (Exception e) {
                this.controlFont = new FontUIResource("Helvetica", 1, 12);
            }
        }
        return this.controlFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        if (this.systemFont == null) {
            try {
                this.systemFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.systemFont", new Font("Helvetica", 0, 11)));
            }
            catch (Exception e) {
                this.systemFont = new FontUIResource("Helvetica", 0, 12);
            }
        }
        return this.systemFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        if (this.userFont == null) {
            try {
                this.userFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.userFont", new Font("Helvetica", 0, 11)));
            }
            catch (Exception e) {
                this.userFont = new FontUIResource("Helvetica", 0, 12);
            }
        }
        return this.userFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        if (this.controlFont == null) {
            try {
                this.controlFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Helvetica", 1, 11)));
            }
            catch (Exception e) {
                this.controlFont = new FontUIResource("Helvetica", 1, 12);
            }
        }
        return this.controlFont;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        if (this.controlFont == null) {
            try {
                this.controlFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Helvetica", 1, 11)));
            }
            catch (Exception e) {
                this.controlFont = new FontUIResource("Helvetica", 1, 12);
            }
        }
        return this.controlFont;
    }

    @Override
    public FontUIResource getSubTextFont() {
        if (this.smallFont == null) {
            try {
                this.smallFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.smallFont", new Font("Helvetica", 0, 9)));
            }
            catch (Exception e) {
                this.smallFont = new FontUIResource("Helvetica", 0, 10);
            }
        }
        return this.smallFont;
    }

    private Font getPrivilegedFont(final String property, final Font defaultFont) {
        return (Font)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Font.getFont(property, defaultFont);
            }
        });
    }
}

