/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.print;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class PageSetupAction
extends AbstractAction {
    private String propertyKey;
    private final MutableProperty<PageFormat> pageFormat;

    public PageSetupAction(MutableProperty<PageFormat> pageFormat) {
        this(null, null, pageFormat);
    }

    public PageSetupAction(ResourcesModel resourcesModel, String propertyKey, MutableProperty<PageFormat> pageFormat) {
        super("Page Setup...");
        this.propertyKey = propertyKey;
        this.pageFormat = pageFormat;
        if (resourcesModel != null) {
            URL url = resourcesModel.getUrl("Print16.gif");
            if (url != null) {
                this.putValue("SmallIcon", new ImageIcon(url));
            }
            final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
            this.updateProperties(propertiesModel);
            if (propertiesModel != null) {
                propertiesModel.addPropertiesListener(new PropertiesListener(){

                    public void propertiesChanged(PropertiesEvent e) {
                        PageSetupAction.this.updateProperties(propertiesModel);
                    }
                });
            }
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 0x10 & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", 80);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (this.pageFormat.getValue() == null) {
            PageFormat defaultPf = job.defaultPage();
            defaultPf.setOrientation(0);
            this.pageFormat.setValue((Object)defaultPf);
        }
        PageFormat pf = job.pageDialog((PageFormat)this.pageFormat.getValue());
        this.pageFormat.setValue((Object)pf);
    }

    private void checkEnabled() {
        boolean enable = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            this.setEnabled(true);
        }
        catch (Exception e) {
            this.setEnabled(false);
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Page Setup...";
        if (propertiesModel != null && propertiesModel.isAvailable(this.propertyKey)) {
            name = String.valueOf(propertiesModel.getValue(this.propertyKey)) + "...";
        }
        this.putValue("Name", name);
    }
}

