/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.spinner;

import com.macrofocus.utils.PropertyChange;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SpinnerNumberModel;

public class DimensionBeanSpinnerModel
extends SpinnerNumberModel {
    private PropertyDescriptor pd;
    private Object o;
    private final Axe axe;

    public DimensionBeanSpinnerModel(Object o, String name, Axe axe) {
        this.o = o;
        this.axe = axe;
        if (o instanceof PropertyChange) {
            PropertyChange changeSupport = (PropertyChange)o;
            changeSupport.addPropertyChangeListener(name, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DimensionBeanSpinnerModel.this.fireStateChanged();
                }
            });
        }
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                this.pd = pd;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValue() {
        if (this.pd != null) {
            Dimension dimension = this.getDimension();
            if (dimension != null) {
                switch (this.axe.ordinal()) {
                    case 0: {
                        return dimension.width;
                    }
                    case 1: {
                        return dimension.height;
                    }
                }
                return null;
            }
            return 0;
        }
        return null;
    }

    public Dimension getDimension() {
        if (this.pd != null) {
            try {
                Dimension dimension = (Dimension)this.pd.getReadMethod().invoke(this.o, new Object[0]);
                return dimension;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (this.getValue() != value) {
            try {
                Dimension dimension = this.getDimension();
                switch (this.axe.ordinal()) {
                    case 0: {
                        this.pd.getWriteMethod().invoke(this.o, new Dimension((Integer)value, dimension.height));
                        break;
                    }
                    case 1: {
                        this.pd.getWriteMethod().invoke(this.o, new Dimension(dimension.width, (Integer)value));
                    }
                }
                this.fireStateChanged();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getNextValue() {
        if (this.getValue() instanceof Integer) {
            return (Integer)this.getValue() + 1;
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.getValue() instanceof Integer) {
            return (Integer)this.getValue() - 1;
        }
        return null;
    }

    public static enum Axe {
        Width,
        Height;

    }
}

