/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document;

import com.macrofocus.application.CompositeUICommand;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.util.file.FileHelper;
import com.treemap.app.document.TreeMapApplication;
import com.treemap.app.java.document.JavaTreeMapDocument;
import com.treemap.app.java.document.OpenDatasetCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;

public class PopulateOpenDatasetCommand<Window, Component>
implements Command {
    private TreeMapApplication<Window, Component, ?, JavaTreeMapDocument> application;
    private CPWindow<Window, Component> window;
    private String server;
    private List<UICommand> commands;

    public PopulateOpenDatasetCommand(TreeMapApplication<Window, Component, ?, JavaTreeMapDocument> application, CPWindow<Window, Component> window, String server) {
        this.application = application;
        this.window = window;
        this.server = server;
    }

    public void execute() {
        this.commands = new ArrayList<UICommand>();
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet getRequest = new HttpGet(this.server + "rest/list");
            getRequest.addHeader("accept", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code querying " + getRequest.toString() + ": " + response.getStatusLine().getStatusCode());
            }
            String string = PopulateOpenDatasetCommand.convertStreamToString(response.getEntity().getContent());
            httpClient.getConnectionManager().shutdown();
            JSONArray array = new JSONArray(string);
            String url = new URL(this.server).getHost();
            for (int i = 0; i < array.length(); ++i) {
                String filename = array.getString(i);
                this.commands.add((UICommand)new CompositeUICommand(FileHelper.removeSuffix((String)filename), new OpenDatasetCommand<Window, Component>(this.application, this.window, this.server, filename)));
            }
        }
        catch (UnknownHostException e) {
            System.out.println(e.getMessage());
        }
        catch (HttpHostConnectException e) {
            System.out.println(e.getMessage());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public List<UICommand> getCommands() {
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

