/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.java.document.persistence;

import com.macrofocus.colormap.ColorMap;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.common.interval.Interval;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import com.macrofocus.data.typemap.InvalidValueException;
import com.macrofocus.data.typemap.TypemapModel;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.Elements;
import com.treemap.app.document.persistence.ColorMapState;
import java.util.ArrayList;

public class DefaultColorMapState<Color>
implements ColorMapState<Color> {
    private final CPColorFactory<Color> colorFactory;
    private final PaletteFactory<Color> paletteFactory;
    private final ElementFactory elementFactory;

    public DefaultColorMapState(CPColorFactory<Color> colorFactory, PaletteFactory<Color> paletteFactory, ElementFactory elementFactory) {
        this.colorFactory = colorFactory;
        this.paletteFactory = paletteFactory;
        this.elementFactory = elementFactory;
    }

    public void loadCategorical(Class columnClass, Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String saturation;
            colorMap.clearAssignedColor();
            Elements entries = child.getChildElements();
            for (int i = 0; i < entries.size(); ++i) {
                Object o;
                Element entry = entries.get(i);
                if (!entry.getLocalName().equals("Entry")) continue;
                String value = entry.getAttributeValue("value");
                try {
                    DefaultTypemapModel typemapModel = new DefaultTypemapModel();
                    TypemapModel.Builder builder = typemapModel.getBuilder(columnClass);
                    o = builder.create(value);
                }
                catch (InvalidValueException | NullPointerException e) {
                    e.printStackTrace();
                    o = value;
                }
                CPColor color = this.colorFactory.parseHTMLColor(entry.getAttributeValue("color"));
                colorMap.setColor(o, color);
            }
            String brightness = child.getAttributeValue("brightness");
            if (brightness != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(this.colorFactory.parseHTMLColor(missingValuesColor));
            }
        }
    }

    public void loadCustom(Number min, Number max, Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String underflowColor;
            String overflowColor;
            String saturation;
            String brightness;
            CustomPalette palette = (CustomPalette)colorMap.getPalette();
            String mode = child.getAttributeValue("mode");
            if (mode != null) {
                palette.setMode(CustomPalette.Mode.valueOf((String)mode));
            }
            if ((brightness = child.getAttributeValue("brightness")) != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((overflowColor = child.getAttributeValue("overflowColor")) != null) {
                colorMap.setOverColor(this.colorFactory.parseHTMLColor(overflowColor));
            }
            if ((underflowColor = child.getAttributeValue("underflowColor")) != null) {
                colorMap.setUnderColor(this.colorFactory.parseHTMLColor(underflowColor));
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(this.colorFactory.parseHTMLColor(missingValuesColor));
            }
            ArrayList<CustomPalette.Entry> list = new ArrayList<CustomPalette.Entry>();
            Elements entries = child.getChildElements();
            for (int i = 0; i < entries.size(); ++i) {
                Element entry = entries.get(i);
                if (!entry.getLocalName().equals("Entry")) continue;
                double fraction = Double.valueOf(entry.getAttributeValue("fraction"));
                String absoluteString = entry.getAttributeValue("absolute");
                if (absoluteString != null) {
                    double absolute = Double.valueOf(absoluteString);
                    if (min != null && max != null) {
                        fraction = DefaultColorMapState.getFraction(absolute, min, max);
                    }
                }
                CPColor color = this.colorFactory.parseHTMLColor(entry.getAttributeValue("color"));
                list.add(new CustomPalette.Entry(fraction, color));
            }
            palette.setEntries(list);
        }
    }

    public void loadPredefined(Element child, MutableColorMap colorMap) {
        if (colorMap != null) {
            String missingValuesColor;
            String underflowColor;
            String overflowColor;
            String saturation;
            String brightness;
            String inverted;
            String numberOfSteps;
            String maximum;
            String minimum;
            String palette = child.getAttributeValue("palette");
            if (palette != null) {
                colorMap.setPalette((MutablePalette)this.paletteFactory.get(palette).getPalette());
            }
            if ((minimum = child.getAttributeValue("minimum")) != null) {
                colorMap.getInterval().setStart(Double.valueOf(minimum).doubleValue());
            }
            if ((maximum = child.getAttributeValue("maximum")) != null) {
                colorMap.getInterval().setEnd(Double.valueOf(maximum).doubleValue());
            }
            if ((numberOfSteps = child.getAttributeValue("numberOfSteps")) != null) {
                colorMap.setColorCount(Integer.valueOf(numberOfSteps).intValue());
            }
            if ((inverted = child.getAttributeValue("inverted")) != null) {
                colorMap.setInverted(Boolean.valueOf(inverted).booleanValue());
            }
            if ((brightness = child.getAttributeValue("brightness")) != null) {
                colorMap.setBrightness(Integer.valueOf(brightness).intValue());
            }
            if ((saturation = child.getAttributeValue("saturation")) != null) {
                colorMap.setSaturation(Integer.valueOf(saturation).intValue());
            }
            if ((overflowColor = child.getAttributeValue("overflowColor")) != null) {
                colorMap.setOverColor(this.colorFactory.parseHTMLColor(overflowColor));
            }
            if ((underflowColor = child.getAttributeValue("underflowColor")) != null) {
                colorMap.setUnderColor(this.colorFactory.parseHTMLColor(underflowColor));
            }
            if ((missingValuesColor = child.getAttributeValue("missingValuesColor")) != null) {
                colorMap.setNullColor(this.colorFactory.parseHTMLColor(missingValuesColor));
            }
        }
    }

    public Element savePredefinedColorMap(ColorMap colorMap) {
        Element colorMapElement = this.elementFactory.newElement("Colormap");
        colorMapElement.addAttribute(this.elementFactory.newAttribute("type", "predefined"));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("palette", this.paletteFactory.find(colorMap.getPalette()).getName()));
        Interval interval = colorMap.getInterval();
        colorMapElement.addAttribute(this.elementFactory.newAttribute("minimum", Double.toString(interval.getStart())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("maximum", Double.toString(interval.getEnd())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("numberOfSteps", Integer.toString(colorMap.getColorCount())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("inverted", Boolean.toString(colorMap.isInverted())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("overflowColor", colorMap.getOverflowColor().toHTMLColor()));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("underflowColor", colorMap.getUnderflowColor().toHTMLColor()));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    public Element saveCustomColorMap(Number min, Number max, ColorMap colorMap) {
        Element colorMapElement = this.elementFactory.newElement("Colormap");
        colorMapElement.addAttribute(this.elementFactory.newAttribute("type", "custom"));
        CustomPalette palette = (CustomPalette)colorMap.getPalette();
        colorMapElement.addAttribute(this.elementFactory.newAttribute("mode", palette.getMode().toString()));
        for (CustomPalette.Entry entry : palette.getEntries()) {
            Element entryElement = this.elementFactory.newElement("Entry");
            entryElement.addAttribute(this.elementFactory.newAttribute("fraction", Double.toString(entry.getFraction())));
            if (min != null && max != null) {
                entryElement.addAttribute(this.elementFactory.newAttribute("absolute", Double.toString(DefaultColorMapState.getAbsolute(entry.getFraction(), min, max))));
            }
            entryElement.addAttribute(this.elementFactory.newAttribute("color", entry.getColor().toHTMLColor()));
            colorMapElement.appendChild(entryElement);
        }
        colorMapElement.addAttribute(this.elementFactory.newAttribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("overflowColor", colorMap.getOverflowColor().toHTMLColor()));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("underflowColor", colorMap.getUnderflowColor().toHTMLColor()));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    public Element saveCategoricalColorMap(ColorMap colorMap) {
        Element colorMapElement = this.elementFactory.newElement("Colormap");
        colorMapElement.addAttribute(this.elementFactory.newAttribute("type", "categorical"));
        for (Object entry : colorMap.getAssignedValues()) {
            Element entryElement = this.elementFactory.newElement("Entry");
            entryElement.addAttribute(this.elementFactory.newAttribute("value", entry.toString()));
            entryElement.addAttribute(this.elementFactory.newAttribute("color", colorMap.getColor(entry).toHTMLColor()));
            colorMapElement.appendChild(entryElement);
        }
        colorMapElement.addAttribute(this.elementFactory.newAttribute("brightness", Integer.toString(colorMap.getBrightness())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("saturation", Integer.toString(colorMap.getSaturation())));
        colorMapElement.addAttribute(this.elementFactory.newAttribute("missingValuesColor", colorMap.getNullColor().toHTMLColor()));
        return colorMapElement;
    }

    private static double getFraction(double absolute, Number min, Number max) {
        return (absolute - min.doubleValue()) / (max.doubleValue() - min.doubleValue());
    }

    private static double getAbsolute(double fraction, Number min, Number max) {
        return min.doubleValue() + fraction * (max.doubleValue() - min.doubleValue());
    }
}

