/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data;

public class FileFormatInfo {
    public Compatibility compatibility = Compatibility.NATIVE;
    public Format format = Format.ASCII;
    public ASCIIFormat asciiFormat = ASCIIFormat.FIXED;
    public char asciiDelimiter = (char)9;
    public boolean namesOnFirstLine = true;

    public FileFormatInfo() {
    }

    public FileFormatInfo(Format format) {
        this.format = format;
    }

    public String toString() {
        String string = this.format.name();
        if (this.format == Format.ASCII) {
            string = string + "_" + this.asciiFormat.toString();
            if (this.compatibility != Compatibility.GENERIC) {
                string = string + "_" + this.compatibility.toString();
            }
        }
        return string;
    }

    public static enum ASCIIFormat {
        FIXED,
        DELIMITED,
        CSV;

    }

    public static enum Format {
        ASCII,
        SPSS,
        SAS,
        STATA;

    }

    public static enum Compatibility {
        NATIVE,
        GENERIC;

    }
}

